/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.context;

import com.metsci.glimpse.context.GlimpseTarget;
import com.metsci.glimpse.context.GlimpseTargetStack;
import com.metsci.glimpse.context.GlimpseTargetStackImpl;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class TargetStackUtil {
    public static GlimpseTargetStack newTargetStack(GlimpseTargetStack stack) {
        return TargetStackUtil.newTargetStack(new GlimpseTarget[0]).push(stack);
    }

    public static GlimpseTargetStack newTargetStack(GlimpseTarget ... targets) {
        return new GlimpseTargetStackImpl(targets);
    }

    public static boolean endsWith(GlimpseTargetStack query, GlimpseTargetStack suffix) {
        int querySize;
        int suffixSize = suffix.getSize();
        if (suffixSize > (querySize = query.getSize())) {
            return false;
        }
        List<GlimpseTarget> suffixList = suffix.getTargetList();
        ListIterator<GlimpseTarget> suffixIter = suffixList.listIterator(suffixList.size());
        List<GlimpseTarget> queryList = query.getTargetList();
        ListIterator<GlimpseTarget> queryIter = queryList.listIterator(queryList.size());
        while (suffixIter.hasPrevious()) {
            GlimpseTarget suffixTarget = suffixIter.previous();
            GlimpseTarget queryTarget = queryIter.previous();
            if (queryTarget.equals(suffixTarget)) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWith(GlimpseTargetStack query, GlimpseTargetStack prefix) {
        int querySize;
        int prefixSize = prefix.getSize();
        if (prefixSize > (querySize = query.getSize())) {
            return false;
        }
        Iterator<GlimpseTarget> prefixIter = prefix.getTargetList().iterator();
        Iterator<GlimpseTarget> queryIter = query.getTargetList().iterator();
        while (prefixIter.hasNext()) {
            GlimpseTarget prefixTarget = prefixIter.next();
            GlimpseTarget queryTarget = queryIter.next();
            if (queryTarget.equals(prefixTarget)) continue;
            return false;
        }
        return true;
    }
}

