/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.canvas;

import com.metsci.glimpse.layout.GlimpseLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class LayoutManager {
    protected LayoutOrderComparator comparator = new LayoutOrderComparator();
    protected Map<GlimpseLayout, LayoutOrder> layoutMap;
    protected List<LayoutOrder> layoutList = new ArrayList<LayoutOrder>();
    protected List<GlimpseLayout> unmodifiableLayoutList;

    public LayoutManager() {
        this.layoutMap = new LinkedHashMap<GlimpseLayout, LayoutOrder>();
        this.unmodifiableLayoutList = new LayoutList(this.layoutList);
    }

    public void removeLayout(GlimpseLayout layout) {
        LayoutOrder layoutOrder = this.layoutMap.remove(layout);
        this.layoutList.remove(layoutOrder);
    }

    public void removeAllLayouts() {
        this.layoutMap.clear();
        this.layoutList.clear();
    }

    public void addLayout(GlimpseLayout layout) {
        this.addLayout(layout, 0);
    }

    public void addLayout(GlimpseLayout layout, int zOrder) {
        LayoutOrder layoutOrder = new LayoutOrder(layout, zOrder);
        this.layoutMap.put(layout, layoutOrder);
        this.layoutList.add(layoutOrder);
        this.updateLayoutList();
    }

    public void setZOrder(GlimpseLayout layout, int zOrder) {
        LayoutOrder layoutOrder = this.layoutMap.get(layout);
        if (layoutOrder != null) {
            layoutOrder.setZOrder(zOrder);
            this.updateLayoutList();
        }
    }

    public List<GlimpseLayout> getLayoutList() {
        return this.unmodifiableLayoutList;
    }

    protected void updateLayoutList() {
        Collections.sort(this.layoutList, this.comparator);
    }

    public static class LayoutOrderComparator
    implements Comparator<LayoutOrder> {
        @Override
        public int compare(LayoutOrder arg0, LayoutOrder arg1) {
            if (arg0.getZOrder() < arg1.getZOrder()) {
                return -1;
            }
            if (arg0.getZOrder() > arg1.getZOrder()) {
                return 1;
            }
            return 0;
        }
    }

    public static class LayoutOrder {
        protected GlimpseLayout layout;
        protected int zOrder;

        public LayoutOrder(GlimpseLayout layout) {
            this(layout, 0);
        }

        public LayoutOrder(GlimpseLayout layout, int zOrder) {
            this.layout = layout;
            this.zOrder = zOrder;
        }

        public GlimpseLayout getLayout() {
            return this.layout;
        }

        public int getZOrder() {
            return this.zOrder;
        }

        public void setZOrder(int order) {
            this.zOrder = order;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.layout == null ? 0 : this.layout.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LayoutOrder other = (LayoutOrder)obj;
            return !(this.layout == null ? other.layout != null : !this.layout.equals(other.layout));
        }
    }

    public static class LayoutList
    implements List<GlimpseLayout> {
        protected List<LayoutOrder> backingList;

        public LayoutList(List<LayoutOrder> backingList) {
            this.backingList = backingList;
        }

        @Override
        public boolean add(GlimpseLayout e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, GlimpseLayout element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends GlimpseLayout> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends GlimpseLayout> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public GlimpseLayout remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public GlimpseLayout set(int index, GlimpseLayout element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListIterator<GlimpseLayout> listIterator(final int index) {
            return new ListIterator<GlimpseLayout>(){
                ListIterator<LayoutOrder> i;
                {
                    this.i = LayoutList.this.backingList.listIterator(index);
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public GlimpseLayout next() {
                    return this.i.next().getLayout();
                }

                @Override
                public boolean hasPrevious() {
                    return this.i.hasPrevious();
                }

                @Override
                public GlimpseLayout previous() {
                    return this.i.previous().getLayout();
                }

                @Override
                public int nextIndex() {
                    return this.i.nextIndex();
                }

                @Override
                public int previousIndex() {
                    return this.i.previousIndex();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void set(GlimpseLayout e) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void add(GlimpseLayout e) {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public GlimpseLayout get(int index) {
            LayoutOrder layoutOrder = this.backingList.get(index);
            return layoutOrder.getLayout();
        }

        @Override
        public boolean isEmpty() {
            return this.backingList.isEmpty();
        }

        @Override
        public Iterator<GlimpseLayout> iterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<GlimpseLayout> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public int size() {
            return this.backingList.size();
        }

        @Override
        public boolean contains(Object o) {
            for (LayoutOrder order : this.backingList) {
                if (!order.getLayout().equals(o)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            for (Object o : c) {
                if (this.contains(o)) continue;
                return false;
            }
            return true;
        }

        @Override
        public List<GlimpseLayout> subList(int fromIndex, int toIndex) {
            return new LayoutList(this.backingList.subList(fromIndex, toIndex));
        }

        @Override
        public int indexOf(Object o) {
            for (int i = 0; i < this.backingList.size(); ++i) {
                LayoutOrder order = this.backingList.get(i);
                if (!order.getLayout().equals(o)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            for (int i = this.backingList.size() - 1; i >= 0; --i) {
                LayoutOrder order = this.backingList.get(i);
                if (!order.getLayout().equals(o)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public Object[] toArray() {
            Object[] a = new Object[this.backingList.size()];
            for (int i = 0; i < this.backingList.size(); ++i) {
                LayoutOrder order = this.backingList.get(i);
                a[i] = order.getLayout();
            }
            return a;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            Object[] o = a;
            if (a.length < this.backingList.size()) {
                o = new Object[this.backingList.size()];
            }
            for (int i = 0; i < this.backingList.size(); ++i) {
                LayoutOrder order = this.backingList.get(i);
                o[i] = order.getLayout();
            }
            return o;
        }
    }
}

