/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.canvas;

import com.metsci.glimpse.canvas.GlimpseCanvas;
import com.metsci.glimpse.canvas.LayoutManager;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.context.GlimpseContextImpl;
import com.metsci.glimpse.context.GlimpseTarget;
import com.metsci.glimpse.context.GlimpseTargetStack;
import com.metsci.glimpse.gl.GLListenerInfo;
import com.metsci.glimpse.gl.GLRunnable;
import com.metsci.glimpse.gl.GLSimpleFrameBufferObject;
import com.metsci.glimpse.gl.GLSimpleListener;
import com.metsci.glimpse.gl.texture.DrawableTexture;
import com.metsci.glimpse.gl.util.GLPBufferUtils;
import com.metsci.glimpse.layout.GlimpseLayout;
import com.metsci.glimpse.support.settings.LookAndFeel;
import com.sun.opengl.util.texture.Texture;
import java.awt.Dimension;
import java.util.List;
import javax.media.opengl.GLContext;

public class FrameBufferGlimpseCanvas
implements GlimpseCanvas {
    protected GLSimpleFrameBufferObject fbo;
    protected LayoutManager layoutManager;
    protected int width;
    protected int height;
    protected boolean isDisposed = false;

    public FrameBufferGlimpseCanvas(int width, int height, GLContext context) {
        GLContext newContext = GLPBufferUtils.createPixelBuffer(1, 1, context).getContext();
        this.width = width;
        this.height = height;
        this.fbo = new GLSimpleFrameBufferObject(width, height, newContext);
        this.layoutManager = new LayoutManager();
        this.fbo.addListener(new GLSimpleListener(){

            @Override
            public void init(GLContext context) {
            }

            @Override
            public void display(GLContext context) {
                for (GlimpseLayout layout : FrameBufferGlimpseCanvas.this.layoutManager.getLayoutList()) {
                    layout.paintTo(FrameBufferGlimpseCanvas.this.getGlimpseContext());
                }
            }

            @Override
            public void reshape(GLContext context, int x, int y, int width, int height) {
                FrameBufferGlimpseCanvas.this.resize0();
            }

            @Override
            public void displayChanged(GLContext context, boolean modeChanged, boolean deviceChanged) {
            }

            @Override
            public void dispose(GLContext context) {
            }

            @Override
            public boolean isDisposed() {
                return false;
            }

            @Override
            public GLListenerInfo getInfo() {
                return null;
            }
        });
    }

    protected void resize0() {
        for (GlimpseLayout layout : this.layoutManager.getLayoutList()) {
            layout.layoutTo(this.getGlimpseContext());
        }
    }

    public void resize(int new_width, int new_height) {
        if (this.width != new_width || this.height != new_height) {
            this.width = new_width;
            this.height = new_height;
            this.fbo.resize(this.width, this.height);
            this.resize0();
        }
    }

    public GLSimpleFrameBufferObject getFrameBuffer() {
        return this.fbo;
    }

    public Texture getOpenGLTexture() {
        return this.fbo.getOpenGLTexture();
    }

    public DrawableTexture getGlimpseTexture() {
        return this.fbo.getGlimpseTexture();
    }

    public Dimension getDimension() {
        return this.fbo.getDimension();
    }

    public void glSyncExec(final GlimpseRunnable runnable) {
        this.fbo.glSyncExec(new GLRunnable(){

            @Override
            public Object run(GLContext context) {
                runnable.run(FrameBufferGlimpseCanvas.this.getGlimpseContext());
                return null;
            }
        });
    }

    @Override
    public GlimpseContext getGlimpseContext() {
        return new GlimpseContextImpl(this);
    }

    @Override
    public GLContext getGLContext() {
        return this.fbo.getGLContext();
    }

    @Override
    public GlimpseBounds getTargetBounds(GlimpseTargetStack stack) {
        return new GlimpseBounds(this.getDimension());
    }

    @Override
    public GlimpseBounds getTargetBounds() {
        return this.getTargetBounds(null);
    }

    @Override
    public void addLayout(GlimpseLayout layout) {
        this.layoutManager.addLayout(layout);
    }

    @Override
    public void addLayout(GlimpseLayout layout, int zOrder) {
        this.layoutManager.addLayout(layout, zOrder);
    }

    @Override
    public void setZOrder(GlimpseLayout layout, int zOrder) {
        this.layoutManager.setZOrder(layout, zOrder);
    }

    @Override
    public void removeLayout(GlimpseLayout layout) {
        this.layoutManager.removeLayout(layout);
    }

    @Override
    public void removeAllLayouts() {
        this.layoutManager.removeAllLayouts();
    }

    @Override
    public List<GlimpseTarget> getTargetChildren() {
        return this.layoutManager.getLayoutList();
    }

    @Override
    public void setLookAndFeel(LookAndFeel laf) {
        for (GlimpseLayout layout : this.layoutManager.getLayoutList()) {
            layout.setLookAndFeel(laf);
        }
    }

    @Override
    public void paint() {
        this.fbo.draw();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        GLContext context = this.getGLContext();
        context.makeCurrent();
        try {
            this.fbo.dispose(context);
        }
        finally {
            context.release();
        }
        this.isDisposed = true;
    }

    @Override
    public boolean isDisposed() {
        return this.isDisposed;
    }

    public String toString() {
        return FrameBufferGlimpseCanvas.class.getSimpleName();
    }

    @Override
    public boolean isEventConsumer() {
        return false;
    }

    @Override
    public void setEventConsumer(boolean consume) {
    }

    @Override
    public boolean isEventGenerator() {
        return false;
    }

    @Override
    public void setEventGenerator(boolean generate) {
    }

    public static interface GlimpseRunnable {
        public void run(GlimpseContext var1);
    }
}

