/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.axis.tagged.shader;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.listener.AxisListener1D;
import com.metsci.glimpse.axis.tagged.Tag;
import com.metsci.glimpse.axis.tagged.TaggedAxis1D;
import com.metsci.glimpse.gl.shader.Shader;
import com.metsci.glimpse.gl.shader.ShaderArg;
import com.metsci.glimpse.gl.shader.ShaderSource;
import com.metsci.glimpse.gl.shader.ShaderType;
import com.metsci.glimpse.util.io.StreamOpener;
import java.io.IOException;
import java.util.List;
import javax.media.opengl.GL;

public class TaggedColorScaleShader
extends Shader
implements AxisListener1D {
    private ShaderArg dataTexUnit;
    private ShaderArg colorTexUnit;
    private ShaderArg vertexCoordTexUnit;
    private ShaderArg textureCoordTexUnit;
    private ShaderArg sizeArg;
    private ShaderArg alphaArg;
    private ShaderArg discardNaN;
    private ShaderArg discardAbove;
    private ShaderArg discardBelow;
    private TaggedAxis1D taggedAxis;

    public TaggedColorScaleShader(TaggedAxis1D axis, int dataTexUnit, int colorTexUnit, int vertexTexUnit, int textureTexUnit) throws IOException {
        super("tagged_colorscale_shader", ShaderType.fragment, TaggedColorScaleShader.readSource());
        this.taggedAxis = axis;
        this.dataTexUnit = this.getArg("datatex");
        this.dataTexUnit.setValue(dataTexUnit);
        this.colorTexUnit = this.getArg("colortex");
        this.colorTexUnit.setValue(colorTexUnit);
        this.vertexCoordTexUnit = this.getArg("vcoordtex");
        this.vertexCoordTexUnit.setValue(vertexTexUnit);
        this.textureCoordTexUnit = this.getArg("tcoordtex");
        this.textureCoordTexUnit.setValue(textureTexUnit);
        this.alphaArg = this.getArg("alpha");
        this.alphaArg.setValue(Float.valueOf(1.0f));
        this.sizeArg = this.getArg("size");
        this.setSizeArgValue();
        this.discardNaN = this.getArg("discardNaN");
        this.discardNaN.setValue(false);
        this.discardAbove = this.getArg("discardAbove");
        this.discardAbove.setValue(false);
        this.discardBelow = this.getArg("discardBelow");
        this.discardBelow.setValue(false);
        this.taggedAxis.addAxisListener(this);
    }

    private static final ShaderSource readSource() throws IOException {
        return new ShaderSource("shaders/colormap/tagged_colorscale_shader.fs", StreamOpener.fileThenResource);
    }

    @Override
    public void axisUpdated(Axis1D axis) {
        this.setSizeArgValue();
    }

    protected void setSizeArgValue() {
        List<Tag> tags = this.taggedAxis.getSortedTags();
        int size = tags.size();
        int count = 0;
        for (int i = size - 1; i >= 0; --i) {
            Tag tag = tags.get(i);
            if (!tag.hasAttribute("TexCoord")) continue;
            ++count;
        }
        this.sizeArg.setValue(count);
    }

    public void setAlpha(float alpha) {
        this.alphaArg.setValue(Float.valueOf(alpha));
    }

    public void setDiscardNaN(boolean discard) {
        this.discardNaN.setValue(discard);
    }

    public void setDiscardAbove(boolean discard) {
        this.discardAbove.setValue(discard);
    }

    public void setDiscardBelow(boolean discard) {
        this.discardBelow.setValue(discard);
    }

    @Override
    public boolean preLink(GL gl, int glProgramHandle) {
        return true;
    }

    @Override
    public void preDisplay(GL gl) {
    }

    @Override
    public void postDisplay(GL gl) {
    }
}

