/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.axis.tagged;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.tagged.Constraint;
import com.metsci.glimpse.axis.tagged.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TaggedAxis1D
extends Axis1D {
    protected Map<String, Tag> tagMap;
    protected Map<String, Constraint> constraintMap;
    protected List<Tag> tags;
    protected Collection<Constraint> constraints;
    protected Comparator<Tag> valueComparator = new Comparator<Tag>(){

        @Override
        public int compare(Tag t1, Tag t2) {
            return Double.compare(t1.getValue(), t2.getValue());
        }
    };

    public TaggedAxis1D(Axis1D parent) {
        super(parent);
        super.initialize(parent);
    }

    public TaggedAxis1D() {
        this(null);
    }

    @Override
    protected void initialize(Axis1D parent) {
        this.constraintMap = new HashMap<String, Constraint>();
        this.tagMap = new HashMap<String, Tag>();
        this.updateTagArray();
        this.updateConstraintArray();
        super.initialize(parent);
    }

    @Override
    public Axis1D clone() {
        TaggedAxis1D axis = new TaggedAxis1D(this);
        for (Tag tag : this.getSortedTags()) {
            axis.addTag(new Tag(tag));
        }
        for (Constraint constraint : this.getAllConstraints()) {
            axis.addConstraint(constraint);
        }
        return axis;
    }

    public void validateTags() {
        this.applyTagConstraints();
        this.updateTagArray();
        this.updateLinkedAxes();
    }

    public Tag addTag(Tag tag) {
        this.tagMap.put(tag.getName(), tag);
        this.validateTags();
        return tag;
    }

    public Tag addTag(String name, double value) {
        return this.addTag(new Tag(name, value));
    }

    public void removeTag(String id) {
        this.tagMap.remove(id);
        this.validateTags();
    }

    public void removeAllTags() {
        this.tagMap.clear();
        this.validateTags();
    }

    public void addConstraint(Constraint constraint) {
        this.constraintMap.put(constraint.getName(), constraint);
        this.updateConstraintArray();
        this.validateTags();
    }

    public void removeConstraint(String name) {
        this.constraintMap.remove(name);
        this.updateConstraintArray();
        this.validateTags();
    }

    public Collection<Constraint> getAllConstraints() {
        return this.constraints;
    }

    public void removeAllConstraints() {
        this.constraintMap.clear();
        this.updateConstraintArray();
        this.validateTags();
    }

    public Tag getTag(String id) {
        return id == null ? null : this.tagMap.get(id);
    }

    public List<Tag> getSortedTags() {
        return this.tags;
    }

    public void applyTagConstraints() {
        for (Constraint constraint : this.constraints) {
            constraint.applyConstraint(this);
        }
    }

    protected void updateTagArray() {
        ArrayList<Tag> sortedTags = new ArrayList<Tag>();
        sortedTags.addAll(this.tagMap.values());
        Collections.sort(sortedTags, this.valueComparator);
        this.tags = Collections.unmodifiableList(sortedTags);
    }

    protected void updateConstraintArray() {
        this.constraints = Collections.unmodifiableCollection(this.constraintMap.values());
    }

    @Override
    protected void axisUpdated0(Axis1D axis) {
        super.axisUpdated0(axis);
        if (axis instanceof TaggedAxis1D) {
            TaggedAxis1D taggedAxis = (TaggedAxis1D)axis;
            for (Tag tag : taggedAxis.getSortedTags()) {
                Tag myTag = this.getTag(tag.getName());
                if (myTag == null) continue;
                myTag.setValue(tag.getValue());
            }
            this.applyTagConstraints();
        }
    }
}

