/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.axis.painter;

import com.metsci.glimpse.axis.painter.label.AxisLabelHandler;
import com.metsci.glimpse.painter.base.GlimpsePainter1D;
import com.metsci.glimpse.support.color.GlimpseColor;
import com.metsci.glimpse.support.font.FontUtils;
import com.metsci.glimpse.support.settings.AbstractLookAndFeel;
import com.metsci.glimpse.support.settings.LookAndFeel;
import com.sun.opengl.util.j2d.TextRenderer;
import java.awt.Font;
import javax.media.opengl.GLContext;

public abstract class NumericAxisPainter
extends GlimpsePainter1D {
    protected int tickBufferSize = 0;
    protected int tickSize = 8;
    protected int textBufferSize = 1;
    protected int labelBufferSize = 1;
    protected int tickLineWidth = 1;
    protected int markerWidth = 2;
    protected boolean keepLabelsForExtremaFullyVisible = true;
    protected boolean showLabelsForOffscreenTicks = false;
    protected boolean showSelectionLine = false;
    protected boolean showLabel = true;
    protected boolean showMinorTicks = false;
    protected Font font;
    protected TextRenderer textRenderer;
    protected float[] tickColor = GlimpseColor.getBlack();
    protected float[] tickLabelColor = GlimpseColor.getBlack();
    protected float[] axisLabelColor = GlimpseColor.getBlack();
    protected AxisLabelHandler ticks;
    protected boolean fontSet = false;

    public NumericAxisPainter(AxisLabelHandler ticks) {
        this.ticks = ticks;
        this.setFont(FontUtils.getDefaultPlain(12.0f), false);
    }

    public void setAxisLabel(String label) {
        this.ticks.setAxisLabel(label);
    }

    public void setShowLabelsForOffscreenTicks(boolean show) {
        this.showLabelsForOffscreenTicks = show;
    }

    public void setKeepLabelsForExtremaFullyVisible(boolean keepFullyVisible) {
        this.keepLabelsForExtremaFullyVisible = keepFullyVisible;
    }

    public void setShowLabel(boolean show) {
        this.showLabel = show;
    }

    public void setFont(Font font) {
        this.setFont(font, false);
    }

    public void setFont(Font font, boolean antialias) {
        this.font = font;
        if (this.textRenderer != null) {
            this.textRenderer.dispose();
        }
        this.textRenderer = new TextRenderer(font, antialias, false);
        this.textRenderer.setSmoothing(true);
        this.fontSet = true;
    }

    public void setTickSize(int size) {
        this.tickSize = size;
    }

    public void setTickBufferSize(int size) {
        this.tickBufferSize = size;
    }

    public void setTickLabelBufferSize(int size) {
        this.textBufferSize = size;
    }

    public void setAxisLabelBufferSize(int size) {
        this.labelBufferSize = size;
    }

    public void setMarkerWidth(int width) {
        this.markerWidth = width;
    }

    public void setShowMarker(boolean show) {
        this.showSelectionLine = show;
    }

    public void setTickColor(float[] color) {
        this.tickColor = color;
    }

    public void setTickLabelColor(float[] color) {
        this.tickLabelColor = color;
    }

    public void setAxisLabelColor(float[] color) {
        this.axisLabelColor = color;
    }

    public void setShowMinorTicks(boolean show) {
        this.showMinorTicks = show;
    }

    public AxisLabelHandler getTickCalculator() {
        return this.ticks;
    }

    @Override
    public void setLookAndFeel(LookAndFeel laf) {
        if (!this.fontSet) {
            this.setFont(laf.getFont(AbstractLookAndFeel.AXIS_FONT), false);
            this.fontSet = false;
        }
    }

    @Override
    public void dispose(GLContext context) {
        if (this.textRenderer != null) {
            this.textRenderer.dispose();
        }
        this.textRenderer = null;
    }
}

