/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.axis.painter;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.painter.NumericXAxisPainter;
import com.metsci.glimpse.axis.painter.label.AxisLabelHandler;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.gl.texture.ColorTexture1D;
import javax.media.opengl.GL;

public class ColorXAxisPainter
extends NumericXAxisPainter {
    protected ColorTexture1D colorTexture;
    protected int colorBarSize = 10;
    protected boolean outline = true;

    public ColorXAxisPainter(AxisLabelHandler ticks) {
        super(ticks);
        this.setTickSize(this.colorBarSize + 0);
    }

    public void setEnableOutline(boolean doOutline) {
        this.outline = doOutline;
    }

    public void setColorScale(ColorTexture1D colorTexture) {
        this.colorTexture = colorTexture;
    }

    public void setColorBarSize(int size) {
        this.colorBarSize = size;
        this.setTickSize(this.colorBarSize + 2);
    }

    @Override
    public void paintTo(GlimpseContext context, GlimpseBounds bounds, Axis1D axis) {
        GL gl = context.getGL();
        int width = bounds.getWidth();
        int height = bounds.getHeight();
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glOrtho(-0.5, (double)((float)(width - 1) + 0.5f), -0.5, (double)((float)(height - 1) + 0.5f), -1.0, 1.0);
        gl.glBlendFunc(770, 771);
        gl.glEnable(3042);
        this.paintColorScale(gl, axis, width, height);
        this.paintTicks(gl, axis, width, height);
        this.paintSelectionLine(gl, axis, width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintColorScale(GL gl, Axis1D axis, int width, int height) {
        if (this.colorTexture != null) {
            this.colorTexture.prepare(gl, 0);
            int y1 = this.getColorBarMinY(height);
            int y2 = this.getColorBarMaxY(height);
            gl.glTexEnvf(8960, 8704, 7681.0f);
            gl.glPolygonMode(1028, 6914);
            gl.glEnable(3552);
            gl.glBegin(7);
            try {
                gl.glTexCoord1f(0.0f);
                gl.glVertex2f(0.0f, (float)y2);
                gl.glTexCoord1f(0.0f);
                gl.glVertex2f(0.0f, (float)y1);
                gl.glTexCoord1f(1.0f);
                gl.glVertex2f((float)(width - 1), (float)y1);
                gl.glTexCoord1f(1.0f);
                gl.glVertex2f((float)(width - 1), (float)y2);
            }
            finally {
                gl.glEnd();
            }
            gl.glDisable(3552);
            this.outlineColorQuad(gl, axis, width, height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void outlineColorQuad(GL gl, Axis1D axis, int width, int height) {
        float y1 = this.getColorBarMinY(height);
        float y2 = this.getColorBarMaxY(height);
        gl.glColor4f(0.0f, 0.0f, 0.0f, 1.0f);
        gl.glBegin(1);
        try {
            gl.glVertex2f(0.0f, y2);
            gl.glVertex2f(0.0f, y1);
            gl.glVertex2f(0.0f, y1);
            gl.glVertex2f((float)(width - 1), y1);
            gl.glVertex2f((float)(width - 1), y1);
            gl.glVertex2f((float)(width - 1), y2);
            gl.glVertex2f((float)(width - 1), y2);
            gl.glVertex2f(0.0f, y2);
        }
        finally {
            gl.glEnd();
        }
    }

    public int getColorBarMinY(int height) {
        return height - 1 - this.tickBufferSize - this.colorBarSize;
    }

    public int getColorBarMaxY(int height) {
        return height - 1 - this.tickBufferSize;
    }
}

