/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.axis.listener.mouse;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.event.mouse.GlimpseMouseAllListener;
import com.metsci.glimpse.event.mouse.GlimpseMouseEvent;
import com.metsci.glimpse.event.mouse.ModifierKey;
import com.metsci.glimpse.event.mouse.MouseButton;
import com.metsci.glimpse.event.mouse.Mouseable;

public abstract class AxisMouseListener
implements GlimpseMouseAllListener {
    public final double zoomConstant = 0.12f;
    protected boolean allowSelectionLock = true;
    protected boolean allowSelectionZoom = true;
    protected boolean allowPan = true;
    protected boolean allowZoom = true;
    protected boolean anchoredX = false;
    protected boolean anchoredY = false;
    protected int anchorPixelsX = 0;
    protected int anchorPixelsY = 0;
    protected double anchorValueX = 0.0;
    protected double anchorValueY = 0.0;

    public void addAxisMouseListener(Mouseable mouseable) {
        mouseable.addGlimpseMouseListener(this);
        mouseable.addGlimpseMouseMotionListener(this);
        mouseable.addGlimpseMouseWheelListener(this);
    }

    public void setAllowSelectionLock(boolean b) {
        this.allowSelectionLock = b;
    }

    public void setAllowSelectionZoom(boolean b) {
        this.allowSelectionZoom = b;
    }

    public void setAllowZoom(boolean b) {
        this.allowZoom = b;
    }

    public void setAllowPan(boolean b) {
        this.allowPan = b;
    }

    protected int getDim(boolean horizontal, int x, int y) {
        return horizontal ? x : y;
    }

    protected double getDim(boolean horizontal, double x, double y) {
        return horizontal ? x : y;
    }

    public void mouseWheelMoved(GlimpseMouseEvent e, Axis1D axis, boolean horizontal) {
        if (e.isKeyDown(ModifierKey.Shift)) {
            this.zoomSelection(axis, horizontal, e.getWheelIncrement(), e.getX(), e.getY());
            this.zoom(axis, horizontal, -e.getWheelIncrement(), e.getX(), e.getY());
        } else if (e.isKeyDown(ModifierKey.Ctrl)) {
            this.zoomSelection(axis, horizontal, -e.getWheelIncrement(), e.getX(), e.getY());
        } else {
            this.zoom(axis, horizontal, -e.getWheelIncrement(), e.getX(), e.getY());
        }
    }

    public void mouseMoved(GlimpseMouseEvent e, Axis1D axis, boolean horizontal) {
        if (e.isButtonDown(MouseButton.Button1)) {
            this.pan(axis, horizontal, e.getX(), e.getY());
        } else {
            this.move(axis, horizontal, e.getX(), e.getY());
        }
    }

    public void mousePressed(GlimpseMouseEvent e, Axis1D axis, boolean horizontal) {
        if (e.isButtonDown(MouseButton.Button3)) {
            this.toggleSelectionLock(axis);
        }
    }

    public void mouseReleased(GlimpseMouseEvent e, Axis1D axis, boolean horizontal) {
        this.unanchor(axis, horizontal, e.getX(), e.getY());
    }

    public void unanchor(Axis1D axis, boolean horizontal, int posX, int posY) {
        if (horizontal) {
            this.anchoredX = false;
        } else {
            this.anchoredY = false;
        }
    }

    public void anchor(Axis1D axis, boolean horizontal, int posX, int posY) {
        if (horizontal && !this.anchoredX) {
            this.move(axis, horizontal, posX, posY);
            this.anchorValueX = axis.getMin();
            this.anchorPixelsX = posX;
            this.anchoredX = true;
        } else if (!horizontal && !this.anchoredY) {
            this.move(axis, horizontal, posX, posY);
            this.anchorValueY = axis.getMin();
            this.anchorPixelsY = axis.getSizePixels() - posY;
            this.anchoredY = true;
        }
    }

    public void pan(Axis1D axis, boolean horizontal, int posX, int posY) {
        if (!this.allowPan) {
            return;
        }
        this.anchor(axis, horizontal, posX, posY);
        int mousePosPixels = this.getDim(horizontal, posX, axis.getSizePixels() - posY);
        int panPixels = this.getDim(horizontal, this.anchorPixelsX, this.anchorPixelsY) - mousePosPixels;
        double diffValue = axis.getMax() - axis.getMin();
        double newMinValue = this.getDim(horizontal, this.anchorValueX, this.anchorValueY) + (double)panPixels / axis.getPixelsPerValue();
        double newMaxValue = newMinValue + diffValue;
        axis.setMin(newMinValue);
        axis.setMax(newMaxValue);
    }

    public void zoom(Axis1D axis, boolean horizontal, int zoomIncrements, int posX, int posY) {
        if (!this.allowZoom) {
            return;
        }
        int mousePosPixels = this.getDim(horizontal, posX, axis.getSizePixels() - posY);
        double mousePosValue = axis.screenPixelToValue(mousePosPixels);
        double zoomPercentDbl = 1.0;
        for (int i = 0; i < Math.abs(zoomIncrements); ++i) {
            zoomPercentDbl *= 1.119999997317791;
        }
        zoomPercentDbl = zoomIncrements > 0 ? zoomPercentDbl : 1.0 / zoomPercentDbl;
        double oldPixelsPerValue = axis.getPixelsPerValue();
        double newPixelsPerValue = oldPixelsPerValue * zoomPercentDbl;
        double newMinValue = mousePosValue - (double)mousePosPixels / newPixelsPerValue;
        double newMaxValue = newMinValue + (double)axis.getSizePixels() / newPixelsPerValue;
        axis.setMin(newMinValue);
        axis.setMax(newMaxValue);
    }

    public void zoomSelection(Axis1D axis, boolean horizontal, int zoomIncrements, int posX, int posY) {
        if (!this.allowSelectionZoom) {
            return;
        }
        double zoomPercentDbl = 1.0;
        for (int i = 0; i < Math.abs(zoomIncrements); ++i) {
            zoomPercentDbl *= 1.119999997317791;
        }
        zoomPercentDbl = zoomIncrements > 0 ? zoomPercentDbl : 1.0 / zoomPercentDbl;
        double newSelectionSize = axis.getSelectionSize() * zoomPercentDbl;
        axis.setSelectionSize(newSelectionSize);
    }

    public void move(Axis1D axis, boolean horizontal, int posX, int posY) {
        int mousePosPixels = this.getDim(horizontal, posX, axis.getSizePixels() - posY);
        double mousePosValue = axis.screenPixelToValue(mousePosPixels);
        axis.setMouseValue(mousePosValue);
        if (!axis.isSelectionLocked()) {
            axis.setSelectionCenter(mousePosValue);
        }
    }

    public void toggleSelectionLock(Axis1D axis) {
        if (!this.allowSelectionLock) {
            return;
        }
        axis.setSelectionLock(!axis.isSelectionLocked());
    }
}

