/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.support.screenshot;

import com.metsci.glimpse.canvas.FrameBufferGlimpseCanvas;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.gl.GLSimpleFrameBufferObject;
import com.metsci.glimpse.gl.util.GLPBufferUtils;
import com.metsci.glimpse.layout.GlimpseLayout;
import com.sun.opengl.util.Screenshot;
import java.io.File;
import java.io.IOException;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;

public class ScreenshotUtil {
    protected GLContext context;
    protected FrameBufferGlimpseCanvas frameBuffer;

    public ScreenshotUtil() {
        this.context = GLPBufferUtils.createPixelBuffer(1, 1).getContext();
        this.frameBuffer = new FrameBufferGlimpseCanvas(1, 1, this.context);
    }

    public ScreenshotUtil(GLContext _context) {
        this.context = GLPBufferUtils.createPixelBuffer(1, 1, _context).getContext();
        this.frameBuffer = new FrameBufferGlimpseCanvas(1, 1, this.context);
    }

    public FrameBufferGlimpseCanvas getGlimpseCanvas() {
        return this.frameBuffer;
    }

    public void captureScreenshot(GlimpseLayout layout, File outputFile, int width, int height) throws GLException, IOException {
        this.frameBuffer.resize(width, height);
        GlimpseContext context = this.frameBuffer.getGlimpseContext();
        GLSimpleFrameBufferObject fbo = this.frameBuffer.getFrameBuffer();
        GLContext glContext = context.getGLContext();
        glContext.makeCurrent();
        fbo.bind(glContext);
        layout.paintTo(context);
        Screenshot.writeToFile((File)outputFile, (int)width, (int)height);
        fbo.unbind(glContext);
        glContext.release();
    }
}

