/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.support.projection;

import com.metsci.glimpse.support.projection.InvertibleProjection;
import com.metsci.glimpse.support.projection.Projection;
import com.metsci.glimpse.util.geo.LatLonGeo;
import com.metsci.glimpse.util.geo.projection.GeoProjection;
import com.metsci.glimpse.util.geo.projection.TangentPlane;
import com.metsci.glimpse.util.vector.Vector2d;

public class TangentPlaneProjection
implements Projection,
InvertibleProjection {
    public static final double SIZE_DOWNSAMPLE = 0.1;
    protected double minLat;
    protected double maxLat;
    protected double minLon;
    protected double maxLon;
    protected double diffLat;
    protected double diffLon;
    protected GeoProjection plane;
    protected boolean latIsX;

    public TangentPlaneProjection(GeoProjection plane, double minLat, double maxLat, double minLon, double maxLon, boolean latIsX) {
        this.latIsX = latIsX;
        this.plane = plane;
        this.minLat = minLat;
        this.maxLat = maxLat;
        this.minLon = minLon;
        this.maxLon = maxLon;
        this.diffLat = this.maxLat - this.minLat;
        this.diffLon = this.maxLon - this.minLon;
    }

    public TangentPlaneProjection(TangentPlane plane, double minLat, double maxLat, double minLon, double maxLon) {
        this((GeoProjection)plane, minLat, maxLat, minLon, maxLon, true);
    }

    @Override
    public void getVertexXY(double textureFractionX, double textureFractionY, float[] resultXY) {
        Vector2d xy = this.project(textureFractionX, textureFractionY);
        resultXY[0] = (float)xy.getX();
        resultXY[1] = (float)xy.getY();
    }

    @Override
    public void getVertexXYZ(double textureFractionX, double textureFractionY, float[] resultXYZ) {
        this.getVertexXY(textureFractionX, textureFractionY, resultXYZ);
        resultXYZ[2] = 0.0f;
    }

    protected Vector2d project(double textureFractionX, double textureFractionY) {
        double lat0 = this.minLat + this.diffLat * (this.latIsX ? textureFractionX : textureFractionY);
        double lon0 = this.minLon + this.diffLon * (!this.latIsX ? textureFractionX : textureFractionY);
        int poleCrosses = (int)Math.floor((lat0 + 90.0) / 180.0);
        boolean latWrapped = poleCrosses % 2 != 0;
        double lat = (double)(latWrapped ? -1 : 1) * (lat0 - (double)(180 * poleCrosses));
        double lon = (double)(latWrapped ? 180 : 0) + lon0;
        return this.plane.project(LatLonGeo.fromDeg((double)lat, (double)lon));
    }

    @Override
    public int getSizeX(int textureSizeX) {
        return (int)Math.round(Math.max(1.0, (double)textureSizeX * 0.1));
    }

    @Override
    public int getSizeY(int textureSizeY) {
        return (int)Math.round(Math.max(1.0, (double)textureSizeY * 0.1));
    }

    @Override
    public double getTextureFractionX(double vertexX, double vertexY) {
        return this.getTextureFraction(vertexX, vertexY, true);
    }

    @Override
    public double getTextureFractionY(double vertexX, double vertexY) {
        return this.getTextureFraction(vertexX, vertexY, false);
    }

    protected double getTextureFraction(double vertexX, double vertexY, boolean getX) {
        LatLonGeo latLon = this.plane.unproject(vertexX, vertexY);
        if (this.latIsX ^ getX) {
            return (latLon.getLonDeg() - this.minLon) / this.diffLon;
        }
        return (latLon.getLatDeg() - this.minLat) / this.diffLat;
    }
}

