/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.support.colormap;

import com.metsci.glimpse.support.colormap.ColorGradient;
import com.metsci.glimpse.support.colormap.ColorMap;

public class ColorMapLinear
implements ColorMap {
    private final float min;
    private final float invExtent;
    private final ColorGradient gradient;

    public ColorMapLinear(float min, float max, ColorGradient gradient) {
        this.min = min;
        this.invExtent = 1.0f / (max - min);
        this.gradient = gradient;
    }

    @Override
    public void toColor(float value, float[] rgba) {
        float unclipped = (value - this.min) * this.invExtent;
        if (unclipped > 1.0f) {
            this.gradient.toColor(1.0f, rgba);
        } else if (unclipped < 0.0f) {
            this.gradient.toColor(0.0f, rgba);
        } else {
            this.gradient.toColor(unclipped, rgba);
        }
    }
}

