/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.support.colormap;

import com.metsci.glimpse.support.colormap.ColorGradient;
import com.metsci.glimpse.support.colormap.ColorGradients;

public class ColorGenerator {
    private int exp;
    private int index;
    private ColorGradient colors;

    public ColorGenerator() {
        this(ColorGradients.jet);
    }

    public ColorGenerator(ColorGradient colors) {
        this.colors = colors;
        this.exp = 0;
        this.index = 0;
    }

    public void next(float[] rgba) {
        float value = -1.0f;
        if (this.index == 0) {
            value = 0.0f;
            this.index = 1;
        } else if ((long)this.index == 1L << this.exp) {
            value = 1.0f;
            ++this.exp;
        }
        if (value >= 0.0f) {
            this.colors.toColor(value, rgba);
            return;
        }
        if ((long)this.index > 1L << this.exp) {
            this.index = 1;
            ++this.exp;
        }
        if (this.exp > 63) {
            this.index = 0;
            this.exp = 0;
        }
        value = (float)this.index / (float)(1L << this.exp);
        this.index += 2;
        this.colors.toColor(value, rgba);
    }
}

