/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.support.atlas.painter;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.context.GlimpseTargetStack;
import com.metsci.glimpse.context.TargetStackUtil;
import com.metsci.glimpse.event.mouse.GlimpseMouseEvent;
import com.metsci.glimpse.event.mouse.GlimpseMouseMotionListener;
import com.metsci.glimpse.gl.GLSimpleFrameBufferObject;
import com.metsci.glimpse.gl.attribute.GLBuffer;
import com.metsci.glimpse.gl.attribute.GLByteBuffer;
import com.metsci.glimpse.gl.attribute.GLFloatBuffer;
import com.metsci.glimpse.gl.attribute.GLFloatBuffer2D;
import com.metsci.glimpse.gl.attribute.GLVertexAttribute;
import com.metsci.glimpse.gl.shader.Pipeline;
import com.metsci.glimpse.layout.GlimpseLayout;
import com.metsci.glimpse.painter.base.GlimpseDataPainter2D;
import com.metsci.glimpse.support.atlas.TextureAtlas;
import com.metsci.glimpse.support.atlas.shader.TextureAtlasIconShaderFragment;
import com.metsci.glimpse.support.atlas.shader.TextureAtlasIconShaderGeometry;
import com.metsci.glimpse.support.atlas.shader.TextureAtlasIconShaderVertex;
import com.metsci.glimpse.support.atlas.support.ImageData;
import com.metsci.glimpse.support.atlas.support.ImageDrawer;
import com.metsci.glimpse.support.atlas.support.TextureAtlasUpdateListener;
import com.metsci.glimpse.support.selection.SpatialSelectionListener;
import com.sun.opengl.util.BufferUtil;
import com.sun.opengl.util.texture.TextureCoords;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;

public class IconPainter
extends GlimpseDataPainter2D {
    private static final Logger logger = Logger.getLogger(IconPainter.class.getSimpleName());
    private static final int DEFAULT_INITIAL_SIZE = 10;
    private static final float DEFAULT_GROWTH_FACTOR = 1.6f;
    private static final int COMPONENTS_PER_COLOR = 4;
    private static final int WIDTH_BUFFER = 5;
    private static final int HEIGHT_BUFFER = 5;
    protected int initialSize;
    protected TextureAtlas atlas;
    protected TextureAtlasIconShaderVertex vertexShader = new TextureAtlasIconShaderVertex(this.pixelCoordsAttributeIndex, this.texCoordsAttributeIndex, this.colorCoordsAttributeIndex);
    protected TextureAtlasIconShaderFragment fragmentShader;
    protected TextureAtlasIconShaderGeometry geometryShader;
    protected Pipeline pipeline;
    protected int pixelCoordsAttributeIndex = 1;
    protected int texCoordsAttributeIndex = 2;
    protected int colorCoordsAttributeIndex = 3;
    protected Map<Object, IconGroup> iconGroupMap;
    protected Collection<GLBuffer> oldBuffers;
    protected ByteBuffer pickResultBuffer;
    protected GLSimpleFrameBufferObject pickFrameBuffer;
    protected boolean pickSupportEnabled = false;
    protected GlimpseMouseMotionListener pickMouseListener;
    protected GlimpseLayout pickTarget;
    protected GlimpseMouseEvent pickMouseEvent;
    protected Collection<PickResult> pickResults;
    protected List<SpatialSelectionListener<PickResult>> pickListeners;
    protected Executor pickNotificationThread;
    protected ReentrantLock lock;

    public IconPainter(TextureAtlas atlas, int initialSize, boolean enablePicking) {
        this.fragmentShader = new TextureAtlasIconShaderFragment(0, enablePicking);
        this.geometryShader = new TextureAtlasIconShaderGeometry();
        this.pipeline = new Pipeline("Pipeline", this.geometryShader, this.vertexShader, this.fragmentShader);
        this.lock = new ReentrantLock();
        this.iconGroupMap = new HashMap<Object, IconGroup>();
        this.oldBuffers = new LinkedList<GLBuffer>();
        this.pickSupportEnabled = enablePicking;
        this.pickResultBuffer = BufferUtil.newByteBuffer((int)484);
        this.pickListeners = new CopyOnWriteArrayList<SpatialSelectionListener<PickResult>>();
        this.pickNotificationThread = Executors.newSingleThreadExecutor();
        this.atlas = atlas;
        this.atlas.addListener(new TextureAtlasUpdateListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reorganized() {
                IconPainter.this.lock.lock();
                try {
                    logger.info("Texture Atlas was reorganized. Adjusting IconPainter with new texture coordinates.");
                    for (IconGroup group : IconPainter.this.iconGroupMap.values()) {
                        group.reloadTextureCoordinates();
                    }
                }
                finally {
                    IconPainter.this.lock.unlock();
                }
            }
        });
        this.initialSize = initialSize;
    }

    public IconPainter(TextureAtlas atlas) {
        this(atlas, 10, false);
    }

    public IconPainter() {
        this(new TextureAtlas(), 10, false);
    }

    public void addSpatialSelectionListener(SpatialSelectionListener<PickResult> listener) {
        this.pickListeners.add(listener);
    }

    public void removeSpatialSelectionListener(SpatialSelectionListener<PickResult> listener) {
        this.pickListeners.remove(listener);
    }

    public boolean isPickingEnabled() {
        return this.pickSupportEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPickingEnabled(GlimpseLayout layout) {
        this.lock.lock();
        try {
            if (this.pickMouseListener != null && this.pickTarget != null) {
                this.pickTarget.removeGlimpseMouseMotionListener(this.pickMouseListener);
            }
            this.pickSupportEnabled = true;
            this.pickMouseListener = new GlimpseMouseMotionListener(){

                @Override
                public void mouseMoved(GlimpseMouseEvent e) {
                    IconPainter.this.pickMouseEvent = e;
                }
            };
            this.pickTarget = layout;
            this.pickTarget.addGlimpseMouseMotionListener(this.pickMouseListener);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPickingDisabled() {
        this.lock.lock();
        try {
            this.pickSupportEnabled = false;
            if (this.pickMouseListener != null && this.pickTarget != null) {
                this.pickTarget.removeGlimpseMouseMotionListener(this.pickMouseListener);
            }
            this.pickMouseEvent = null;
            this.pickTarget = null;
            this.pickMouseListener = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    public TextureAtlas getTextureAtlas() {
        return this.atlas;
    }

    public void loadIcon(Object iconId, BufferedImage image) {
        this.atlas.loadImage(iconId, image);
    }

    public void loadIcon(Object iconId, BufferedImage image, int centerX, int centerY) {
        this.atlas.loadImage(iconId, image, centerX, centerY);
    }

    public void loadIcon(Object iconId, int width, int height, ImageDrawer drawer) {
        this.atlas.loadImage(iconId, width, height, drawer);
    }

    public void loadIcon(Object iconId, int width, int height, int centerX, int centerY, ImageDrawer drawer) {
        this.atlas.loadImage(iconId, width, height, centerX, centerY, drawer);
    }

    public void setGlobalScale(float scale) {
        this.geometryShader.setGlobalScale(scale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        this.lock.lock();
        try {
            int count = 0;
            for (IconGroup group : this.iconGroupMap.values()) {
                count += group.getCurrentSize();
            }
            int n = count;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIconGroup(Object iconGroupId, int initialSize) {
        this.lock.lock();
        try {
            IconGroup group = this.iconGroupMap.get(iconGroupId);
            if (group == null) {
                group = new IconGroup(iconGroupId, initialSize);
                this.iconGroupMap.put(iconGroupId, group);
            } else {
                group.resize(initialSize, false);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addIcon(Object iconGroupId, Object iconId, float positionX, float positionY) {
        this.addIcon(iconGroupId, iconId, 1.0f, positionX, positionY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIcon(Object iconGroupId, Object iconId, float scale, float positionX, float positionY) {
        this.lock.lock();
        try {
            IconGroup group = this.getIconGroup(iconGroupId);
            group.addIcon(iconId, scale, positionX, positionY);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addIcons(Object iconGroupId, Object iconId, float[] positionX, float[] positionY) {
        this.addIcons(iconGroupId, iconId, 1.0f, positionX, positionY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIcons(Object iconGroupId, Object iconId, float scale, float[] positionX, float[] positionY) {
        this.lock.lock();
        try {
            IconGroup group = this.getIconGroup(iconGroupId);
            group.addIcons(iconId, scale, positionX, positionY);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIcons(Object iconGroupId, Object iconId, float scale, float[] positions) {
        this.lock.lock();
        try {
            IconGroup group = this.getIconGroup(iconGroupId);
            group.addIcons(iconId, scale, positions);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIcons(Object iconGroupId, Object iconId, float scale, FloatBuffer positions, int vertexOffset, int vertexCount) {
        this.lock.lock();
        try {
            IconGroup group = this.getIconGroup(iconGroupId);
            group.addIcons(iconId, scale, positions, vertexOffset, vertexCount);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIconGroup(Object iconGroupId) {
        this.lock.lock();
        try {
            IconGroup group = this.iconGroupMap.remove(iconGroupId);
            if (group != null) {
                group.dispose();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showIconGroup(Object iconGroupId, boolean show) {
        this.lock.lock();
        try {
            IconGroup group = this.getIconGroup(iconGroupId);
            group.setVisible(show);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintTo(GlimpseContext context, GlimpseBounds bounds, Axis2D axis) {
        this.lock.lock();
        try {
            GL gl = context.getGL();
            if (!this.pipeline.isLinked(gl)) {
                this.pipeline.beginUse(gl);
                this.pipeline.endUse(gl);
            }
            this.disposeOldBuffers(gl);
            if (this.pickSupportEnabled) {
                if (this.pickFrameBuffer == null) {
                    this.pickFrameBuffer = new GLSimpleFrameBufferObject(11, 11, context.getGLContext());
                }
                this.pickTo(context, bounds, axis);
            }
            super.paintTo(context, bounds, axis);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintTo(GL gl, GlimpseBounds bounds, Axis2D axis) {
        if (!this.pipeline.isLinked(gl)) {
            this.pipeline.beginUse(gl);
            this.pipeline.endUse(gl);
        }
        this.fragmentShader.setPickMode(false);
        this.geometryShader.updateViewport(bounds);
        this.atlas.beginRendering();
        this.pipeline.beginUse(gl);
        try {
            for (IconGroup group : this.iconGroupMap.values()) {
                group.addQueuedIcons();
                if (!group.isVisible()) continue;
                group.getBufferTexCoords().bind(this.texCoordsAttributeIndex, gl);
                group.getBufferPixelCoords().bind(this.pixelCoordsAttributeIndex, gl);
                group.getPickColorCoords().bind(this.colorCoordsAttributeIndex, gl);
                group.getBufferXY().bind(GLVertexAttribute.ATTRIB_POSITION_2D, gl);
                gl.glDrawArrays(0, 0, group.getCurrentSize());
            }
        }
        finally {
            this.pipeline.endUse(gl);
            this.atlas.endRendering();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pickTo(GlimpseContext context, GlimpseBounds bounds, Axis2D axis) {
        if (this.pickMouseEvent == null) {
            return;
        }
        HashSet<PickResult> pickedIcons = new HashSet<PickResult>();
        GLContext glContext = context.getGLContext();
        GL gl = context.getGL();
        this.setPickOrthoProjection(gl, bounds, axis, this.pickMouseEvent.getX(), bounds.getHeight() - this.pickMouseEvent.getY());
        this.fragmentShader.setPickMode(true);
        this.geometryShader.updateViewport(11, 11);
        this.pickFrameBuffer.bind(glContext);
        this.atlas.beginRendering();
        this.pipeline.beginUse(gl);
        try {
            for (IconGroup group : this.iconGroupMap.values()) {
                if (!group.isVisible()) continue;
                group.getBufferTexCoords().bind(this.texCoordsAttributeIndex, gl);
                group.getBufferPixelCoords().bind(this.pixelCoordsAttributeIndex, gl);
                group.getPickColorCoords().bind(this.colorCoordsAttributeIndex, gl);
                group.getBufferXY().bind(GLVertexAttribute.ATTRIB_POSITION_2D, gl);
                this.resetPickFrameBuffer(glContext);
                gl.glDrawArrays(0, 0, group.getCurrentSize());
                this.checkPickFrameBuffer(context, group, pickedIcons);
            }
        }
        finally {
            this.pipeline.endUse(gl);
            this.atlas.endRendering();
            this.pickFrameBuffer.unbind(glContext);
            gl.glEnable(3089);
            gl.glViewport(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
        }
        this.notifySpatialSelectionListeners(pickedIcons);
    }

    protected void resetPickFrameBuffer(GLContext glContext) {
        GL gl = glContext.getGL();
        gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        gl.glClear(16384);
    }

    protected void setPickOrthoProjection(GL gl, GlimpseBounds bounds, Axis2D axis, int clickX, int clickY) {
        Axis1D axisX = axis.getAxisX();
        Axis1D axisY = axis.getAxisY();
        double minX = axisX.screenPixelToValue(clickX - 5);
        double maxX = axisX.screenPixelToValue(clickX + 5 + 1);
        double minY = axisY.screenPixelToValue(clickY - 5);
        double maxY = axisY.screenPixelToValue(clickY + 5 + 1);
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glOrtho(minX, maxX, minY, maxY, -1.0, 1.0);
        gl.glViewport(0, 0, 11, 11);
        gl.glDisable(3089);
    }

    protected void checkPickFrameBuffer(GlimpseContext context, IconGroup group, Set<PickResult> resultSet) {
        GlimpseTargetStack stack = TargetStackUtil.newTargetStack(context.getTargetStack());
        int width = 11;
        int height = 11;
        context.getGL().glReadPixels(0, 0, width, height, 6408, 5121, this.pickResultBuffer.rewind());
        for (int i = 0; i < width * height; ++i) {
            byte r = this.pickResultBuffer.get();
            byte g = this.pickResultBuffer.get();
            byte b = this.pickResultBuffer.get();
            byte a = this.pickResultBuffer.get();
            if (a == 0) continue;
            int iconIndex = this.s2u(r) << 16 | this.s2u(g) << 8 | this.s2u(b);
            Object groupId = group.getId();
            Object iconId = group.getIconId(iconIndex);
            resultSet.add(new PickResult(groupId, iconId, iconIndex, stack));
        }
    }

    protected int s2u(int b) {
        return b < 0 ? 256 + b : b;
    }

    protected void notifySpatialSelectionListeners(final Set<PickResult> resultSet) {
        this.pickNotificationThread.execute(new Runnable(){

            @Override
            public void run() {
                for (SpatialSelectionListener<PickResult> listener : IconPainter.this.pickListeners) {
                    listener.selectionChanged(resultSet);
                }
            }
        });
    }

    protected void copy(GLBuffer from, final GLBuffer to) {
        from.mutate(new GLBuffer.Mutator(){

            @Override
            public void mutate(final ByteBuffer fromData, int length) {
                to.mutate(new GLBuffer.Mutator(){

                    @Override
                    public void mutate(ByteBuffer toData, int length) {
                        fromData.rewind();
                        toData.rewind();
                        toData.put(fromData);
                    }
                });
            }
        });
    }

    protected IconGroup getIconGroup(Object iconGroupId) {
        IconGroup group = this.iconGroupMap.get(iconGroupId);
        if (group == null) {
            group = new IconGroup(iconGroupId);
            this.iconGroupMap.put(iconGroupId, group);
        }
        return group;
    }

    protected void disposeOldBuffers(GL gl) {
        for (GLBuffer oldBuffer : this.oldBuffers) {
            oldBuffer.dispose(gl);
        }
        this.oldBuffers.clear();
    }

    @Override
    public void dispose(GLContext context) {
        for (IconGroup group : this.iconGroupMap.values()) {
            group.dispose();
        }
        this.disposeOldBuffers(context.getGL());
        if (this.pickFrameBuffer != null) {
            this.pickFrameBuffer.dispose(context);
        }
    }

    private final class IconGroup {
        private Object id;
        private boolean visible;
        private int currentSize;
        private int maxSize;
        private List<Object> iconIds;
        private GLFloatBuffer2D xyValues;
        private GLFloatBuffer pixelCoordsValues;
        private GLFloatBuffer texCoordsValues;
        private GLByteBuffer pickColorValues;
        private Collection<AddIcons> addQueue;

        public IconGroup(Object id, int initialIconSpace) {
            this.id = id;
            this.visible = true;
            this.iconIds = new ArrayList<Object>();
            this.xyValues = new GLFloatBuffer2D(initialIconSpace);
            this.pixelCoordsValues = new GLFloatBuffer(initialIconSpace, 4);
            this.texCoordsValues = new GLFloatBuffer(initialIconSpace, 4);
            this.pickColorValues = new GLByteBuffer(initialIconSpace, 3);
            this.addQueue = new LinkedList<AddIcons>();
            this.currentSize = 0;
            this.maxSize = initialIconSpace;
        }

        public IconGroup(Object id) {
            this(id, iconPainter.initialSize);
        }

        public final Object getId() {
            return this.id;
        }

        public final int getCurrentSize() {
            return this.currentSize;
        }

        public final void setVisible(boolean visible) {
            this.visible = visible;
        }

        public final boolean isVisible() {
            return this.visible;
        }

        public final Object getIconId(int index) {
            return this.iconIds.get(index);
        }

        public final GLFloatBuffer2D getBufferXY() {
            return this.xyValues;
        }

        public final GLFloatBuffer getBufferPixelCoords() {
            return this.pixelCoordsValues;
        }

        public final GLFloatBuffer getBufferTexCoords() {
            return this.texCoordsValues;
        }

        public final GLByteBuffer getPickColorCoords() {
            return this.pickColorValues;
        }

        public void addIcons(Object iconId, float scale, float[] positionX, float[] positionY) {
            this.addQueue.add(new AddIconsSeparate(iconId, scale, positionX, positionY));
        }

        public void addIcons(Object iconId, float scale, float[] positions) {
            this.addQueue.add(new AddIconsInterleaved(iconId, scale, positions));
        }

        public void addIcons(Object iconId, float scale, FloatBuffer positions, int vertexOffset, int vertexCount) {
            this.addQueue.add(new AddIconsBuffer(iconId, scale, positions, vertexOffset, vertexCount));
        }

        public void addIcon(Object iconId, float scale, float positionX, float positionY) {
            this.addIcons(iconId, scale, new float[]{positionX}, new float[]{positionY});
        }

        public void addQueuedIcons() {
            for (AddIcons addIcons : this.addQueue) {
                addIcons.addIcons(this);
            }
            this.addQueue.clear();
        }

        public void grow(int size) {
            this.currentSize += size;
            if (this.currentSize >= this.maxSize) {
                int newSize = Math.max(this.maxSize + size, (int)((float)this.maxSize * 1.6f));
                this.resize(newSize, false);
            }
        }

        public void resize(int newSize, boolean allowShrinking) {
            if (newSize <= this.maxSize && !allowShrinking) {
                return;
            }
            GLFloatBuffer2D xyValues_temp = new GLFloatBuffer2D(newSize);
            GLFloatBuffer pixelCoordsValues_temp = new GLFloatBuffer(newSize, 4);
            GLFloatBuffer texCoordsValues_temp = new GLFloatBuffer(newSize, 4);
            GLByteBuffer pickColorValues_temp = new GLByteBuffer(newSize, 3);
            IconPainter.this.copy(this.xyValues, xyValues_temp);
            IconPainter.this.copy(this.pixelCoordsValues, pixelCoordsValues_temp);
            IconPainter.this.copy(this.texCoordsValues, texCoordsValues_temp);
            IconPainter.this.copy(this.pickColorValues, pickColorValues_temp);
            this.dispose();
            this.xyValues = xyValues_temp;
            this.pixelCoordsValues = pixelCoordsValues_temp;
            this.texCoordsValues = texCoordsValues_temp;
            this.pickColorValues = pickColorValues_temp;
            this.maxSize = newSize;
        }

        public void reloadTextureCoordinates() {
            this.texCoordsValues.mutate(new GLFloatBuffer.Mutator(){

                @Override
                public void mutate(FloatBuffer data, int length) {
                    data.limit(IconGroup.this.currentSize * length);
                    data.position(0);
                    Object prevIconId = null;
                    TextureCoords texData = null;
                    for (int i = 0; i < IconGroup.this.currentSize; ++i) {
                        Object iconId = IconGroup.this.iconIds.get(i);
                        if (!iconId.equals(prevIconId)) {
                            ImageData imageData = IconPainter.this.atlas.getImageData(iconId);
                            texData = imageData.getTextureCoordinates();
                        }
                        data.put(texData.left());
                        data.put(texData.right());
                        data.put(texData.top());
                        data.put(texData.bottom());
                        prevIconId = iconId;
                    }
                }
            });
        }

        public void dispose() {
            IconPainter.this.oldBuffers.add(this.xyValues);
            IconPainter.this.oldBuffers.add(this.pixelCoordsValues);
            IconPainter.this.oldBuffers.add(this.texCoordsValues);
            IconPainter.this.oldBuffers.add(this.pickColorValues);
        }
    }

    private final class AddIconsBuffer
    extends AddIcons {
        FloatBuffer positions;
        int vertexOffset;
        int vertexCount;

        public AddIconsBuffer(Object iconId, float scale, FloatBuffer positions, int vertexOffset, int vertexCount) {
            this.iconId = iconId;
            this.positions = positions;
            this.scale = scale;
            this.vertexOffset = vertexOffset;
            this.vertexCount = vertexCount;
        }

        @Override
        public int getSize() {
            return this.vertexCount;
        }

        @Override
        public void addPosition(final IconGroup group) {
            group.xyValues.mutate(new GLFloatBuffer.Mutator(){

                @Override
                public void mutate(FloatBuffer data, int length) {
                    int currentSize = group.getCurrentSize();
                    data.limit(currentSize * length);
                    data.position((currentSize - AddIconsBuffer.this.vertexCount) * length);
                    int limit = AddIconsBuffer.this.positions.limit();
                    AddIconsBuffer.this.positions.position(AddIconsBuffer.this.vertexOffset * length);
                    AddIconsBuffer.this.positions.limit((AddIconsBuffer.this.vertexOffset + AddIconsBuffer.this.vertexCount) * length);
                    data.put(AddIconsBuffer.this.positions);
                    AddIconsBuffer.this.positions.limit(limit);
                }
            });
        }
    }

    private final class AddIconsInterleaved
    extends AddIcons {
        float[] positions;
        int size;

        public AddIconsInterleaved(Object iconId, float scale, float[] positions) {
            this.iconId = iconId;
            this.positions = positions;
            this.scale = scale;
            if (positions.length % 2 != 0) {
                throw new IllegalArgumentException(String.format("Size of position array must be even. Found: %d.", positions.length));
            }
            this.size = positions.length / 2;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        @Override
        public void addPosition(final IconGroup group) {
            group.xyValues.mutate(new GLFloatBuffer.Mutator(){

                @Override
                public void mutate(FloatBuffer data, int length) {
                    int currentSize = group.getCurrentSize();
                    data.limit(currentSize * length);
                    data.position((currentSize - AddIconsInterleaved.this.size) * length);
                    data.put(AddIconsInterleaved.this.positions, 0, AddIconsInterleaved.this.size * length);
                }
            });
        }
    }

    private final class AddIconsSeparate
    extends AddIcons {
        float[] positionX;
        float[] positionY;
        int size;

        public AddIconsSeparate(Object iconId, float scale, float[] positionX, float[] positionY) {
            this.iconId = iconId;
            this.positionX = positionX;
            this.positionY = positionY;
            this.scale = scale;
            if (positionX.length != positionY.length) {
                throw new IllegalArgumentException(String.format("Size of positionX and positionY arrays must be identical. Found: %d and %d.", positionX.length, positionY.length));
            }
            this.size = positionX.length;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        @Override
        public void addPosition(final IconGroup group) {
            group.xyValues.mutate(new GLFloatBuffer.Mutator(){

                @Override
                public void mutate(FloatBuffer data, int length) {
                    int currentSize = group.getCurrentSize();
                    data.limit(currentSize * length);
                    data.position((currentSize - AddIconsSeparate.this.size) * length);
                    for (int i = 0; i < AddIconsSeparate.this.size; ++i) {
                        data.put(AddIconsSeparate.this.positionX[i]);
                        data.put(AddIconsSeparate.this.positionY[i]);
                    }
                }
            });
        }
    }

    private abstract class AddIcons {
        protected float scale;
        protected Object iconId;

        private AddIcons() {
        }

        public abstract int getSize();

        public abstract void addPosition(IconGroup var1);

        public void addIcons(IconGroup group) {
            final int size = this.getSize();
            group.grow(size);
            final int currentSize = group.getCurrentSize();
            final ImageData imageData = IconPainter.this.atlas.getImageData(this.iconId);
            final TextureCoords texData = imageData.getTextureCoordinates();
            this.addPosition(group);
            for (int i = 0; i < size; ++i) {
                group.iconIds.add(this.iconId);
            }
            group.pixelCoordsValues.mutate(new GLFloatBuffer.Mutator(){

                @Override
                public void mutate(FloatBuffer data, int length) {
                    data.limit(currentSize * length);
                    data.position((currentSize - size) * length);
                    float width = (float)(imageData.getWidth() + imageData.getBufferX() * 2) * AddIcons.this.scale;
                    float height = (float)(imageData.getHeight() + imageData.getBufferY() * 2) * AddIcons.this.scale;
                    float offsetX = (float)(imageData.getCenterX() + imageData.getBufferX()) * AddIcons.this.scale;
                    float offsetY = (float)(imageData.getCenterY() + imageData.getBufferY()) * AddIcons.this.scale;
                    for (int i = 0; i < size; ++i) {
                        data.put(width);
                        data.put(height);
                        data.put(offsetX);
                        data.put(offsetY);
                    }
                }
            });
            group.texCoordsValues.mutate(new GLFloatBuffer.Mutator(){

                @Override
                public void mutate(FloatBuffer data, int length) {
                    data.limit(currentSize * length);
                    data.position((currentSize - size) * length);
                    for (int i = 0; i < size; ++i) {
                        data.put(texData.left());
                        data.put(texData.right());
                        data.put(texData.top());
                        data.put(texData.bottom());
                    }
                }
            });
            group.pickColorValues.mutate(new GLBuffer.Mutator(){

                @Override
                public void mutate(ByteBuffer data, int length) {
                    data.limit(currentSize * length);
                    data.position((currentSize - size) * length);
                    for (int i = 0; i < size; ++i) {
                        int index = currentSize - size + i;
                        byte r = (byte)((index & 0xFF0000) >> 16);
                        byte g = (byte)((index & 0xFF00) >> 8);
                        byte b = (byte)(index & 0xFF);
                        System.out.printf("%d %d %d%n", r, g, b);
                        data.put(r).put(g).put(b);
                    }
                }
            });
        }
    }

    public class PickResult {
        private Object groupId;
        private Object iconId;
        private int iconIndex;
        private GlimpseTargetStack stack;

        public PickResult(Object groupId, Object iconId, int iconIndex, GlimpseTargetStack stack) {
            this.groupId = groupId;
            this.iconId = iconId;
            this.iconIndex = iconIndex;
            this.stack = stack;
        }

        public Object getGroupId() {
            return this.groupId;
        }

        public Object getIconId() {
            return this.iconId;
        }

        public int getIconIndex() {
            return this.iconIndex;
        }

        public GlimpseTargetStack getTargetStack() {
            return this.stack;
        }

        public String toString() {
            return this.groupId + " " + this.iconId + " : " + this.iconIndex;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
            result = 31 * result + this.iconIndex;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PickResult other = (PickResult)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
                return false;
            }
            return this.iconIndex == other.iconIndex;
        }

        private IconPainter getOuterType() {
            return IconPainter.this;
        }
    }
}

