/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.support.atlas;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.support.atlas.support.ImageData;
import com.metsci.glimpse.support.atlas.support.ImageDataExternal;
import com.metsci.glimpse.support.atlas.support.ImageDataInternal;
import com.metsci.glimpse.support.atlas.support.ImageDrawer;
import com.metsci.glimpse.support.atlas.support.TextureAtlasUpdateListener;
import com.sun.opengl.impl.packrect.BackingStoreManager;
import com.sun.opengl.impl.packrect.Rect;
import com.sun.opengl.impl.packrect.RectVisitor;
import com.sun.opengl.impl.packrect.RectanglePacker;
import com.sun.opengl.util.j2d.TextureRenderer;
import com.sun.opengl.util.texture.TextureCoords;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;
import javax.media.opengl.GL;
import javax.media.opengl.GLException;
import javax.media.opengl.glu.GLU;

public class TextureAtlas {
    private static final int INITIAL_WIDTH = 2048;
    private static final int INITIAL_HEIGHT = 2048;
    private static final float MAX_VERTICAL_FRAGMENTATION = 0.7f;
    private ReentrantLock lock;
    private Map<Object, ImageDataExternal> additionQueue;
    private Set<Object> deletionQueue;
    private Collection<TextureAtlasUpdateListener> updateListeners;
    private Map<Object, Rect> imageMap;
    private RectanglePacker packer;
    private TextureRenderer cachedBackingStore;
    private Graphics2D cachedGraphics;
    private boolean inBeginEndPair;
    private boolean isOrthoMode;
    private int beginRenderingWidth;
    private int beginRenderingHeight;
    private boolean beginRenderingDepthTestDisabled;
    private boolean smoothing = true;
    private boolean isExtensionAvailable_GL_VERSION_1_5;
    private boolean checkFor_isExtensionAvailable_GL_VERSION_1_5;
    private boolean mipmap;
    private boolean haveMaxSize;

    public TextureAtlas(int initalWidth, int initialHeight) {
        this.packer = new RectanglePacker((BackingStoreManager)new Manager(), initalWidth, initialHeight);
        this.additionQueue = new HashMap<Object, ImageDataExternal>();
        this.deletionQueue = new HashSet<Object>();
        this.imageMap = new HashMap<Object, Rect>();
        this.updateListeners = new CopyOnWriteArrayList<TextureAtlasUpdateListener>();
        this.lock = new ReentrantLock();
    }

    public TextureAtlas() {
        this(2048, 2048);
    }

    public void addListener(TextureAtlasUpdateListener listener) {
        this.updateListeners.add(listener);
    }

    public void removeListener(TextureAtlasUpdateListener listener) {
        this.updateListeners.remove(listener);
    }

    public void loadImage(Object id, final BufferedImage image, int centerX, int centerY) {
        ImageDrawer drawer = new ImageDrawer(){

            @Override
            public void drawImage(Graphics2D g, int width, int height) {
                g.drawImage((Image)image, 0, 0, null);
            }
        };
        int height = image.getHeight();
        int width = image.getWidth();
        this.loadImage(id, width, height, centerX, centerY, drawer);
    }

    public void loadImage(Object id, BufferedImage image) {
        int height = image.getHeight();
        int width = image.getWidth();
        this.loadImage(id, image, width / 2, height / 2);
    }

    public void loadImage(Object id, int width, int height, ImageDrawer drawer) {
        this.loadImage(id, width, height, width / 2, height / 2, drawer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadImage(Object id, int width, int height, int centerX, int centerY, ImageDrawer drawer) {
        this.lock.lock();
        try {
            Rect rect = this.imageMap.get(id);
            if (rect != null) {
                throw new IllegalArgumentException(String.format("Image id \"%s\" already exists.", id));
            }
            this.additionQueue.put(id, new ImageDataExternal(id, centerX, centerY, width, height, drawer));
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteImage(Object id) {
        this.lock.lock();
        try {
            this.deletionQueue.add(id);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isImageLoaded(Object id) {
        this.lock.lock();
        try {
            boolean bl = this.imageMap.containsKey(id);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageData getImageData(Object id) {
        this.lock.lock();
        try {
            Rect rect = this.imageMap.get(id);
            if (rect == null) {
                throw new IllegalArgumentException(String.format("Image id \"%s\" does not exist.", id));
            }
            ImageData imageData = new ImageData((ImageDataInternal)rect.getUserData());
            return imageData;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void drawImage(GL gl, Object id, Axis2D axis, double positionX, double positionY) {
        this.drawImage(gl, id, axis, positionX, positionY, 1.0);
    }

    public void drawImage(GL gl, Object id, Axis2D axis, double positionX, double positionY, double scale) {
        this.drawImage(gl, id, axis, positionX, positionY, scale, scale);
    }

    public void drawImage(GL gl, Object id, Axis2D axis, double positionX, double positionY, double scaleX, double scaleY) {
        ImageDataInternal data = this.getImageDataInternal(id);
        double ppvX = axis.getAxisX().getPixelsPerValue();
        double ppvY = axis.getAxisY().getPixelsPerValue();
        this.drawImage(gl, id, ppvX, ppvY, data, positionX, positionY, scaleX, scaleY, data.getCenterX(), data.getCenterY());
    }

    public void drawImage(GL gl, Object id, Axis2D axis, double positionX, double positionY, double scaleX, double scaleY, int centerX, int centerY) {
        ImageDataInternal data = this.getImageDataInternal(id);
        double ppvX = axis.getAxisX().getPixelsPerValue();
        double ppvY = axis.getAxisY().getPixelsPerValue();
        this.drawImage(gl, id, ppvX, ppvY, data, positionX, positionY, scaleX, scaleY, centerX, centerY);
    }

    public void drawImageAxisX(GL gl, Object id, Axis1D axis, double positionX, double positionY) {
        ImageDataInternal data = this.getImageDataInternal(id);
        double ppvX = axis.getPixelsPerValue();
        this.drawImage(gl, id, ppvX, 1.0, data, positionX, positionY, 1.0, 1.0, data.getCenterX(), data.getCenterY());
    }

    public void drawImageAxisX(GL gl, Object id, Axis1D axis, double positionX, double positionY, double scaleX, double scaleY, int centerX, int centerY) {
        ImageDataInternal data = this.getImageDataInternal(id);
        double ppvX = axis.getPixelsPerValue();
        this.drawImage(gl, id, ppvX, 1.0, data, positionX, positionY, scaleX, scaleY, centerX, centerY);
    }

    public void drawImageAxisY(GL gl, Object id, Axis1D axis, double positionX, double positionY) {
        ImageDataInternal data = this.getImageDataInternal(id);
        double ppvY = axis.getPixelsPerValue();
        this.drawImage(gl, id, 1.0, ppvY, data, positionX, positionY, 1.0, 1.0, data.getCenterX(), data.getCenterY());
    }

    public void drawImageAxisY(GL gl, Object id, Axis1D axis, double positionX, double positionY, double scaleX, double scaleY, int centerX, int centerY) {
        ImageDataInternal data = this.getImageDataInternal(id);
        double ppvY = axis.getPixelsPerValue();
        this.drawImage(gl, id, 1.0, ppvY, data, positionX, positionY, scaleX, scaleY, centerX, centerY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawImage(GL gl, Object id, double ppvX, double ppvY, ImageDataInternal data, double positionX, double positionY, double scaleX, double scaleY, int centerX, int centerY) {
        double vppX = 1.0 / ppvX;
        double vppY = 1.0 / ppvY;
        int width = data.getBufferedWidth();
        int height = data.getBufferedHeight();
        TextureCoords texCoords = data.getTextureCoordinates();
        float minX = (float)(positionX - (double)(centerX + data.getBufferX()) * vppX * scaleX);
        float minY = (float)(positionY - (double)(height - centerY - data.getBufferY()) * vppY * scaleY);
        float maxX = minX + (float)((double)width * vppX * scaleX);
        float maxY = minY + (float)((double)height * vppY * scaleY);
        gl.glBegin(7);
        try {
            gl.glTexCoord2f(texCoords.left(), texCoords.bottom());
            gl.glVertex2f(minX, minY);
            gl.glTexCoord2f(texCoords.right(), texCoords.bottom());
            gl.glVertex2f(maxX, minY);
            gl.glTexCoord2f(texCoords.right(), texCoords.top());
            gl.glVertex2f(maxX, maxY);
            gl.glTexCoord2f(texCoords.left(), texCoords.top());
            gl.glVertex2f(minX, maxY);
        }
        finally {
            gl.glEnd();
        }
    }

    public void beginRendering() throws GLException {
        this.beginRendering(false, 0, 0, false);
    }

    public void endRendering() throws GLException {
        this.endRendering(false);
    }

    public void dispose() throws GLException {
        this.packer.dispose();
        this.packer = null;
        this.cachedBackingStore = null;
        this.cachedGraphics = null;
    }

    private ImageDataInternal getImageDataInternal(Object id) {
        Rect rect = this.imageMap.get(id);
        if (rect == null) {
            throw new IllegalArgumentException(String.format("Image id \"%s\" does not exist.", id));
        }
        return (ImageDataInternal)rect.getUserData();
    }

    private Graphics2D getGraphics2D() {
        TextureRenderer renderer = this.getBackingStore();
        if (this.cachedGraphics == null) {
            this.cachedGraphics = renderer.createGraphics();
            this.cachedGraphics.setComposite(AlphaComposite.Src);
            this.cachedGraphics.setColor(Color.WHITE);
        }
        return this.cachedGraphics;
    }

    private void beginRendering(boolean ortho, int width, int height, boolean disableDepthTestForOrtho) {
        this.updateImages();
        this.inBeginEndPair = true;
        this.isOrthoMode = ortho;
        this.beginRenderingWidth = width;
        this.beginRenderingHeight = height;
        this.beginRenderingDepthTestDisabled = disableDepthTestForOrtho;
        if (ortho) {
            this.getBackingStore().beginOrthoRendering(width, height, disableDepthTestForOrtho);
        } else {
            this.getBackingStore().begin3DRendering();
        }
        GL gl = GLU.getCurrentGL();
        gl.glPushClientAttrib(-1);
        if (!this.haveMaxSize) {
            int[] sz = new int[1];
            gl.glGetIntegerv(3379, sz, 0);
            this.packer.setMaxSize(sz[0], sz[0]);
            this.haveMaxSize = true;
        }
        if (this.mipmap && !this.getBackingStore().isUsingAutoMipmapGeneration()) {
            this.mipmap = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateImages() {
        this.lock.lock();
        try {
            for (ImageDataExternal addImage : this.additionQueue.values()) {
                this.newImage0(addImage);
            }
            for (Object deleteImage : this.deletionQueue) {
                Rect rect = this.imageMap.get(deleteImage);
                if (rect == null) continue;
                ImageDataInternal data = (ImageDataInternal)rect.getUserData();
                data.delete();
            }
            this.additionQueue.clear();
            this.deletionQueue.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void newImage0(ImageDataExternal data) {
        Object id = data.getId();
        Rect rect = this.imageMap.get(data.getId());
        if (rect != null) {
            throw new IllegalArgumentException(String.format("Image id \"%s\" already exists.", id));
        }
        int width = data.getWidth();
        int height = data.getHeight();
        int centerX = data.getCenterX();
        int centerY = data.getCenterY();
        Graphics2D g = this.getGraphics2D();
        ImageDataInternal imageData = new ImageDataInternal(id, centerX, centerY, 1, 1, width, height);
        rect = new Rect(0, 0, imageData.getBufferedWidth(), imageData.getBufferedHeight(), (Object)imageData);
        this.packer.add(rect);
        this.imageMap.put(id, rect);
        this.updateTextureCoordinates(rect, imageData, imageData.getBufferedWidth(), imageData.getBufferedHeight());
        g = this.getGraphics2D();
        g.setComposite(AlphaComposite.Clear);
        g.fillRect(rect.x(), rect.y(), rect.w(), rect.h());
        g.setComposite(AlphaComposite.Src);
        int x = rect.x() + imageData.getBufferX();
        int y = rect.y() + imageData.getBufferY();
        AffineTransform transform = g.getTransform();
        g.translate(x, y);
        data.getImageDrawer().drawImage(g, width, height);
        g.setTransform(transform);
        this.getBackingStore().markDirty(rect.x(), rect.y(), rect.w(), rect.h());
    }

    private void updateTextureCoordinates(TextureRenderer backingStore, Rect rect, ImageDataInternal imageData, int width, int height) {
        int texX = rect.x();
        int texY = backingStore.getHeight() - rect.y() - height;
        TextureCoords textureCoordinates = backingStore.getTexture().getSubImageTexCoords(texX, texY, texX + width, texY + height);
        imageData.setTextureCoordinates(textureCoordinates);
    }

    private void updateTextureCoordinates(Rect rect, ImageDataInternal imageData, int width, int height) {
        this.updateTextureCoordinates(this.getBackingStore(), rect, imageData, width, height);
    }

    private void updateTextureCoordinates(TextureRenderer backingStore, Rect rect) {
        ImageDataInternal imageData = (ImageDataInternal)rect.getUserData();
        int width = imageData.getBufferedWidth();
        int height = imageData.getBufferedHeight();
        this.updateTextureCoordinates(backingStore, rect, imageData, width, height);
    }

    private void endRendering(boolean ortho) throws GLException {
        this.inBeginEndPair = false;
        GL gl = GLU.getCurrentGL();
        gl.glPopClientAttrib();
        if (this.is15Available(gl)) {
            try {
                gl.glBindBuffer(34962, 0);
            }
            catch (Exception e) {
                this.isExtensionAvailable_GL_VERSION_1_5 = false;
            }
        }
        if (ortho) {
            this.getBackingStore().endOrthoRendering();
        } else {
            this.getBackingStore().end3DRendering();
        }
    }

    private void clearUnusedEntries() {
        final ArrayList deadRects = new ArrayList();
        this.packer.visit(new RectVisitor(){

            public void visit(Rect rect) {
                ImageDataInternal data = (ImageDataInternal)rect.getUserData();
                if (data.isMarkedForDelete()) {
                    deadRects.add(rect);
                }
            }
        });
        for (Rect r : deadRects) {
            this.packer.remove(r);
            this.imageMap.remove(((ImageDataInternal)r.getUserData()).getId());
        }
        float frag = this.packer.verticalFragmentationRatio();
        if (!deadRects.isEmpty() && frag > 0.7f) {
            this.packer.compact();
        }
    }

    private TextureRenderer getBackingStore() {
        TextureRenderer renderer = (TextureRenderer)this.packer.getBackingStore();
        if (renderer != this.cachedBackingStore) {
            if (this.cachedGraphics != null) {
                this.cachedGraphics.dispose();
                this.cachedGraphics = null;
            }
            this.cachedBackingStore = renderer;
        }
        return this.cachedBackingStore;
    }

    private boolean is15Available(GL gl) {
        if (!this.checkFor_isExtensionAvailable_GL_VERSION_1_5) {
            this.isExtensionAvailable_GL_VERSION_1_5 = gl.isExtensionAvailable("GL_VERSION_1_5");
            this.checkFor_isExtensionAvailable_GL_VERSION_1_5 = true;
        }
        return this.isExtensionAvailable_GL_VERSION_1_5;
    }

    class Manager
    implements BackingStoreManager {
        private Graphics2D g;

        Manager() {
        }

        public Object allocateBackingStore(int w, int h) {
            TextureRenderer renderer = new TextureRenderer(w, h, true, TextureAtlas.this.mipmap);
            renderer.setSmoothing(TextureAtlas.this.smoothing);
            return renderer;
        }

        public void deleteBackingStore(Object backingStore) {
            ((TextureRenderer)backingStore).dispose();
        }

        public boolean preExpand(Rect cause, int attemptNumber) {
            if (attemptNumber == 0) {
                TextureAtlas.this.clearUnusedEntries();
                return true;
            }
            return false;
        }

        public void additionFailed(Rect cause, int attemptNumber) {
            TextureAtlas.this.packer.clear();
            TextureAtlas.this.imageMap.clear();
        }

        public void beginMovement(Object oldBackingStore, Object newBackingStore) {
            if (TextureAtlas.this.inBeginEndPair) {
                GL gl = GLU.getCurrentGL();
                gl.glPopClientAttrib();
                if (TextureAtlas.this.is15Available(gl)) {
                    try {
                        gl.glBindBuffer(34962, 0);
                    }
                    catch (Exception e) {
                        TextureAtlas.this.isExtensionAvailable_GL_VERSION_1_5 = false;
                    }
                }
                if (TextureAtlas.this.isOrthoMode) {
                    ((TextureRenderer)oldBackingStore).endOrthoRendering();
                } else {
                    ((TextureRenderer)oldBackingStore).end3DRendering();
                }
            }
            TextureRenderer newRenderer = (TextureRenderer)newBackingStore;
            this.g = newRenderer.createGraphics();
        }

        public void move(Object oldBackingStore, Rect oldLocation, Object newBackingStore, Rect newLocation) {
            TextureRenderer oldRenderer = (TextureRenderer)oldBackingStore;
            TextureRenderer newRenderer = (TextureRenderer)newBackingStore;
            if (oldRenderer == newRenderer) {
                this.g.copyArea(oldLocation.x(), oldLocation.y(), oldLocation.w(), oldLocation.h(), newLocation.x() - oldLocation.x(), newLocation.y() - oldLocation.y());
            } else {
                Image img = oldRenderer.getImage();
                this.g.drawImage(img, newLocation.x(), newLocation.y(), newLocation.x() + newLocation.w(), newLocation.y() + newLocation.h(), oldLocation.x(), oldLocation.y(), oldLocation.x() + oldLocation.w(), oldLocation.y() + oldLocation.h(), null);
            }
            ImageDataInternal data = (ImageDataInternal)oldLocation.getUserData();
            newLocation.setUserData(oldLocation.getUserData());
            TextureAtlas.this.imageMap.put(data.getId(), newLocation);
            TextureAtlas.this.updateTextureCoordinates(newRenderer, newLocation);
        }

        public void endMovement(Object oldBackingStore, Object newBackingStore) {
            this.g.dispose();
            TextureRenderer newRenderer = (TextureRenderer)newBackingStore;
            newRenderer.markDirty(0, 0, newRenderer.getWidth(), newRenderer.getHeight());
            if (TextureAtlas.this.inBeginEndPair) {
                if (TextureAtlas.this.isOrthoMode) {
                    ((TextureRenderer)newBackingStore).beginOrthoRendering(TextureAtlas.this.beginRenderingWidth, TextureAtlas.this.beginRenderingHeight, TextureAtlas.this.beginRenderingDepthTestDisabled);
                } else {
                    ((TextureRenderer)newBackingStore).begin3DRendering();
                }
                GL gl = GLU.getCurrentGL();
                gl.glPushClientAttrib(-1);
            }
            for (TextureAtlasUpdateListener listener : TextureAtlas.this.updateListeners) {
                listener.reorganized();
            }
        }
    }
}

