/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.plot.timeline.painter;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.tagged.Tag;
import com.metsci.glimpse.axis.tagged.TaggedAxis1D;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.painter.base.GlimpsePainter1D;
import com.metsci.glimpse.plot.StackedPlot2D;
import com.metsci.glimpse.support.color.GlimpseColor;
import com.metsci.glimpse.support.font.FontUtils;
import com.sun.opengl.util.j2d.TextRenderer;
import java.awt.Font;
import java.util.List;
import javax.media.opengl.GL;

public class SimpleSelectedTimeRegionPainter
extends GlimpsePainter1D {
    protected float[] selectionFillColor = GlimpseColor.fromColorRgba(0, 153, 204, 40);
    protected float[] selectionBorderColor = GlimpseColor.fromColorRgba(0, 51, 255, 255);
    protected TextRenderer textRenderer;
    protected Font font;
    protected StackedPlot2D.Orientation orientation;

    public SimpleSelectedTimeRegionPainter(StackedPlot2D.Orientation orientation) {
        this.orientation = orientation;
        this.font = FontUtils.getDefaultBold(12.0f);
        this.textRenderer = new TextRenderer(this.font);
    }

    public void setSelectionFillColor(float[] color) {
        this.selectionFillColor = color;
    }

    public void setSelectionBorderColor(float[] color) {
        this.selectionBorderColor = color;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paint(GL gl, TaggedAxis1D taggedAxis, List<Tag> tags, float min, float max, float current, int width, int height) {
        GlimpseColor.glColor(gl, this.selectionFillColor);
        gl.glBegin(7);
        try {
            if (this.orientation == StackedPlot2D.Orientation.VERTICAL) {
                gl.glVertex2f(min, 0.0f);
                gl.glVertex2f(min, (float)height);
                gl.glVertex2f(max, (float)height);
                gl.glVertex2f(max, 0.0f);
            } else {
                gl.glVertex2f(0.0f, min);
                gl.glVertex2f((float)width, min);
                gl.glVertex2f((float)width, max);
                gl.glVertex2f(0.0f, max);
            }
        }
        finally {
            gl.glEnd();
        }
        GlimpseColor.glColor(gl, this.selectionBorderColor);
        gl.glBegin(2);
        try {
            if (this.orientation == StackedPlot2D.Orientation.VERTICAL) {
                gl.glVertex2f(min, 0.0f);
                gl.glVertex2f(min, (float)height);
                gl.glVertex2f(max, (float)height);
                gl.glVertex2f(max, 0.0f);
            } else {
                gl.glVertex2f(0.0f, min);
                gl.glVertex2f((float)width, min);
                gl.glVertex2f((float)width, max);
                gl.glVertex2f(0.0f, max);
            }
        }
        finally {
            gl.glEnd();
        }
        gl.glLineWidth(3.0f);
        gl.glBegin(1);
        try {
            if (this.orientation == StackedPlot2D.Orientation.VERTICAL) {
                gl.glVertex2f(current, 0.0f);
                gl.glVertex2f(current, (float)height);
            } else {
                gl.glVertex2f(0.0f, current);
                gl.glVertex2f((float)width, current);
            }
        }
        finally {
            gl.glEnd();
        }
    }

    @Override
    public void paintTo(GlimpseContext context, GlimpseBounds bounds, Axis1D axis) {
        GL gl = context.getGL();
        TaggedAxis1D taggedAxis = (TaggedAxis1D)axis;
        int height = bounds.getHeight();
        int width = bounds.getWidth();
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        if (this.orientation == StackedPlot2D.Orientation.VERTICAL) {
            gl.glOrtho(taggedAxis.getMin(), taggedAxis.getMax(), -0.5, (double)((float)(height - 1) + 0.5f), -1.0, 1.0);
        } else {
            gl.glOrtho(-0.5, (double)((float)(width - 1) + 0.5f), taggedAxis.getMin(), taggedAxis.getMax(), -1.0, 1.0);
        }
        gl.glBlendFunc(770, 771);
        gl.glEnable(3042);
        Tag minTag = taggedAxis.getTag("min_time");
        Tag maxTag = taggedAxis.getTag("max_time");
        Tag currentTag = taggedAxis.getTag("current_time");
        if (minTag == null || maxTag == null || currentTag == null) {
            return;
        }
        List<Tag> tags = taggedAxis.getSortedTags();
        float min = (float)minTag.getValue();
        float current = (float)currentTag.getValue();
        float max = (float)maxTag.getValue();
        this.paint(gl, taggedAxis, tags, min, max, current, width, height);
    }
}

