/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.plot.timeline.listener;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.axis.listener.mouse.AxisMouseListener1D;
import com.metsci.glimpse.axis.listener.mouse.AxisMouseListener2D;
import com.metsci.glimpse.event.mouse.GlimpseMouseEvent;
import com.metsci.glimpse.event.mouse.ModifierKey;
import com.metsci.glimpse.layout.GlimpseAxisLayout2D;
import com.metsci.glimpse.plot.StackedPlot2D;
import com.metsci.glimpse.plot.timeline.StackedTimePlot2D;
import com.metsci.glimpse.plot.timeline.listener.TimelineMouseListener1D;

public class TimelineMouseListener2D
extends AxisMouseListener2D {
    public static final int TIMELINE_WIDTH = 28;
    protected StackedTimePlot2D plot;
    protected AxisMouseListener1D delegateListener;
    protected StackedPlot2D.PlotInfo info;
    protected boolean axisSelected;
    protected boolean timeIsX;

    public TimelineMouseListener2D(StackedTimePlot2D plot, StackedPlot2D.PlotInfo info) {
        this.info = info;
        this.plot = plot;
        this.timeIsX = plot.isTimeAxisHorizontal();
        this.delegateListener = new TimelineMouseListener1D(plot);
        if (this.timeIsX) {
            this.setAllowSelectionZoomX(false);
        } else {
            this.setAllowSelectionZoomY(false);
        }
        this.setAllowSelectionLock(false);
    }

    @Override
    public void mouseMoved(GlimpseMouseEvent e) {
        GlimpseAxisLayout2D layout = this.getAxisLayout(e);
        if (layout == null) {
            return;
        }
        Axis2D axis = layout.getAxis(e.getTargetStack());
        Axis1D axisX = axis.getAxisX();
        Axis1D axisY = axis.getAxisY();
        if (e.isAnyButtonDown()) {
            if (this.axisSelected) {
                if (this.timeIsX) {
                    this.mouseMoved(e, axisY, false);
                } else {
                    this.mouseMoved(e, axisX, true);
                }
            } else if (this.timeIsX) {
                this.delegateListener.mouseMoved(e, axisX, true);
            } else {
                this.delegateListener.mouseMoved(e, axisY, false);
            }
        } else if (this.timeIsX) {
            this.mouseMoved(e, axisY, false);
            this.delegateListener.mouseMoved(e, axisX, true);
        } else {
            this.mouseMoved(e, axisX, true);
            this.delegateListener.mouseMoved(e, axisY, false);
        }
        this.applyAndUpdate(axisX, axisY);
    }

    @Override
    public void mousePressed(GlimpseMouseEvent e) {
        GlimpseAxisLayout2D layout = this.getAxisLayout(e);
        if (layout == null) {
            return;
        }
        this.plot.setSelectedPlot(this.info);
        Axis2D axis = layout.getAxis(e.getTargetStack());
        Axis1D axisX = axis.getAxisX();
        Axis1D axisY = axis.getAxisY();
        if (this.timeIsX && (e.getX() < 28 || e.isKeyDown(ModifierKey.Shift))) {
            this.axisSelected = true;
            this.mousePressed(e, axisY, false);
        } else if (!this.timeIsX && (e.getY() < 28 || e.isKeyDown(ModifierKey.Shift))) {
            this.axisSelected = true;
            this.mousePressed(e, axisX, true);
        } else {
            this.axisSelected = false;
            if (this.timeIsX) {
                this.delegateListener.mousePressed(e, axisX, true);
            } else {
                this.delegateListener.mousePressed(e, axisY, false);
            }
        }
        this.applyAndUpdate(axisX, axisY);
    }

    @Override
    public void mouseReleased(GlimpseMouseEvent e) {
        GlimpseAxisLayout2D layout = this.getAxisLayout(e);
        if (layout == null) {
            return;
        }
        Axis2D axis = layout.getAxis(e.getTargetStack());
        Axis1D axisX = axis.getAxisX();
        Axis1D axisY = axis.getAxisY();
        if (this.timeIsX) {
            this.mouseReleased(e, axisY, false);
            this.delegateListener.mouseReleased(e, axisX, true);
        } else {
            this.mouseReleased(e, axisX, true);
            this.delegateListener.mouseReleased(e, axisY, false);
        }
        this.applyAndUpdate(axisX, axisY);
    }

    @Override
    public void mouseWheelMoved(GlimpseMouseEvent e) {
        GlimpseAxisLayout2D layout = this.getAxisLayout(e);
        if (layout == null) {
            return;
        }
        Axis2D axis = layout.getAxis(e.getTargetStack());
        Axis1D axisX = axis.getAxisX();
        Axis1D axisY = axis.getAxisY();
        if (this.timeIsX && (e.getX() < 28 || e.isKeyDown(ModifierKey.Shift))) {
            this.mouseWheelMoved(e, axisY, false);
        } else if (!this.timeIsX && (e.getY() < 28 || e.isKeyDown(ModifierKey.Shift))) {
            this.mouseWheelMoved(e, axisX, true);
        } else {
            this.delegateListener.mouseWheelMoved(e);
        }
        this.applyAndUpdate(axisX, axisY);
    }

    public void setAllowSelectionLockX(boolean b) {
        if (this.timeIsX) {
            this.delegateListener.setAllowSelectionLock(b);
        } else {
            this.allowSelectionLock = b;
        }
    }

    public void setAllowSelectionZoomX(boolean b) {
        if (this.timeIsX) {
            this.delegateListener.setAllowSelectionZoom(b);
        } else {
            this.allowSelectionZoom = b;
        }
    }

    public void setAllowZoomX(boolean b) {
        if (this.timeIsX) {
            this.delegateListener.setAllowZoom(b);
        } else {
            this.allowZoom = b;
        }
    }

    public void setAllowPanX(boolean b) {
        if (this.timeIsX) {
            this.delegateListener.setAllowPan(b);
        } else {
            this.allowPan = b;
        }
    }

    public void setAllowSelectionLockY(boolean b) {
        if (!this.timeIsX) {
            this.delegateListener.setAllowSelectionLock(b);
        } else {
            this.allowSelectionLock = b;
        }
    }

    public void setAllowSelectionZoomY(boolean b) {
        if (!this.timeIsX) {
            this.delegateListener.setAllowSelectionZoom(b);
        } else {
            this.allowSelectionZoom = b;
        }
    }

    public void setAllowZoomY(boolean b) {
        if (!this.timeIsX) {
            this.delegateListener.setAllowZoom(b);
        } else {
            this.allowZoom = b;
        }
    }

    public void setAllowPanY(boolean b) {
        if (!this.timeIsX) {
            this.delegateListener.setAllowPan(b);
        } else {
            this.allowPan = b;
        }
    }

    @Override
    public void setAllowSelectionLock(boolean b) {
        this.delegateListener.setAllowSelectionLock(b);
        this.allowSelectionLock = b;
    }

    @Override
    public void setAllowSelectionZoom(boolean b) {
        this.delegateListener.setAllowSelectionZoom(b);
        this.allowSelectionZoom = b;
    }

    @Override
    public void setAllowZoom(boolean b) {
        this.delegateListener.setAllowZoom(b);
        this.allowZoom = b;
    }

    @Override
    public void setAllowPan(boolean b) {
        this.delegateListener.setAllowPan(b);
        this.allowPan = b;
    }

    public void setTimelineMouseListener1D(AxisMouseListener1D mouseListener) {
        this.delegateListener = mouseListener;
    }

    public AxisMouseListener1D getTimeMouseListener1D() {
        return this.delegateListener;
    }
}

