/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.painter.texture;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.gl.shader.Pipeline;
import com.metsci.glimpse.gl.texture.ColorTexture1D;
import com.metsci.glimpse.painter.texture.ShadedTexturePainter;
import com.metsci.glimpse.support.projection.Projection;
import com.metsci.glimpse.support.shader.SampledColorScaleShader;
import com.metsci.glimpse.support.texture.FloatTextureProjected2D;
import java.io.IOException;
import java.util.logging.Logger;

public class HeatMapPainter
extends ShadedTexturePainter {
    public static final Logger logger = Logger.getLogger(HeatMapPainter.class.getName());
    protected FloatTextureProjected2D heatMap;
    protected ColorTexture1D colorScale;
    protected SampledColorScaleShader fragShader;

    public HeatMapPainter(Axis1D axis) {
        try {
            this.loadDefaultPipeline(axis);
        }
        catch (IOException e) {
            logger.warning("Unable to load HeatMapPainter shader.");
        }
    }

    protected void loadDefaultPipeline(Axis1D axis) throws IOException {
        this.fragShader = new SampledColorScaleShader(axis, 0, 1);
        this.setPipeline(new Pipeline("colormap", null, null, this.fragShader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAlpha(float alpha) {
        this.lock.lock();
        try {
            this.fragShader.setAlpha(alpha);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(FloatTextureProjected2D texture) {
        this.lock.lock();
        try {
            this.removeDrawableTexture(this.heatMap);
            this.heatMap = texture;
            this.addDrawableTexture(this.heatMap, 0);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColorScale(ColorTexture1D texture) {
        this.lock.lock();
        try {
            this.removeNonDrawableTexture(this.colorScale);
            this.colorScale = texture;
            this.addNonDrawableTexture(this.colorScale, 1);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColorTexture1D getColorScale() {
        this.lock.lock();
        try {
            if (this.heatMap != null) {
                ColorTexture1D colorTexture1D = this.colorScale;
                return colorTexture1D;
            }
            ColorTexture1D colorTexture1D = null;
            return colorTexture1D;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FloatTextureProjected2D getData() {
        this.lock.lock();
        try {
            if (this.heatMap != null) {
                FloatTextureProjected2D floatTextureProjected2D = this.heatMap;
                return floatTextureProjected2D;
            }
            FloatTextureProjected2D floatTextureProjected2D = null;
            return floatTextureProjected2D;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Projection getProjection() {
        this.lock.lock();
        try {
            if (this.heatMap != null) {
                Projection projection = this.heatMap.getProjection();
                return projection;
            }
            Projection projection = null;
            return projection;
        }
        finally {
            this.lock.unlock();
        }
    }
}

