/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.painter.shape;

import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.painter.base.GlimpsePainter2D;
import com.metsci.glimpse.painter.base.GlimpsePainterImpl;
import com.metsci.glimpse.support.polygon.Polygon;
import com.metsci.glimpse.support.polygon.PolygonTessellator;
import com.metsci.glimpse.support.polygon.SimpleVertexAccumulator;
import com.metsci.glimpse.util.logging.LoggerUtils;
import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;

public class PolygonPainter
extends GlimpsePainter2D {
    protected static final Comparator<IdPolygon> startTimeComparator = new Comparator<IdPolygon>(){

        @Override
        public int compare(IdPolygon p1, IdPolygon p2) {
            if (p1.startTime < p2.startTime) {
                return -1;
            }
            if (p1.startTime > p2.startTime) {
                return 1;
            }
            if (p1.groupId < p2.groupId) {
                return -1;
            }
            if (p1.groupId > p2.groupId) {
                return 1;
            }
            if (p1.polygonId < p2.polygonId) {
                return -1;
            }
            if (p1.polygonId > p2.polygonId) {
                return 1;
            }
            return 0;
        }
    };
    protected static final Comparator<IdPolygon> endTimeComparator = new Comparator<IdPolygon>(){

        @Override
        public int compare(IdPolygon p1, IdPolygon p2) {
            if (p1.endTime < p2.endTime) {
                return -1;
            }
            if (p1.endTime > p2.endTime) {
                return 1;
            }
            if (p1.groupId < p2.groupId) {
                return -1;
            }
            if (p1.groupId > p2.groupId) {
                return 1;
            }
            if (p1.polygonId < p2.polygonId) {
                return -1;
            }
            if (p1.polygonId > p2.polygonId) {
                return 1;
            }
            return 0;
        }
    };
    protected byte[] halftone = new byte[]{-86, -86, -86, -86, 85, 85, 85, 85, -86, -86, -86, -86, 85, 85, 85, 85, -86, -86, -86, -86, 85, 85, 85, 85, -86, -86, -86, -86, 85, 85, 85, 85, -86, -86, -86, -86, 85, 85, 85, 85, -86, -86, -86, -86, 85, 85, 85, 85, -86, -86, -86, -86, 85, 85, 85, 85, -86, -86, -86, -86, 85, 85, 85, 85, -86, -86, -86, -86, 85, 85, 85, 85, -86, -86, -86, -86, 85, 85, 85, 85, -86, -86, -86, -86, 85, 85, 85, 85, -86, -86, -86, -86, 85, 85, 85, 85, -86, -86, -86, -86, 85, 85, 85, 85, -86, -86, -86, -86, 85, 85, 85, 85, -86, -86, -86, -86, 85, 85, 85, 85, -86, -86, -86, -86, 85, 85, 85, 85};
    protected PolygonTessellator tessellator = new PolygonTessellator(this.glu);
    protected int dataBufferSize = 0;
    protected FloatBuffer dataBuffer = null;
    protected Map<Integer, Group> groups = new LinkedHashMap<Integer, Group>();
    protected volatile boolean newData = false;
    protected Set<Group> updatedGroups = new LinkedHashSet<Group>();
    protected Map<Integer, LoadedGroup> loadedGroups = new LinkedHashMap<Integer, LoadedGroup>();
    protected ReentrantLock updateLock = new ReentrantLock();
    protected IdPolygon globalSelectionStart;
    protected IdPolygon globalSelectionEnd;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPolygon(int groupId, int polygonId, float[] dataX, float[] dataY, float z) {
        this.updateLock.lock();
        try {
            this.addPolygon(groupId, new IdPolygon(groupId, polygonId, PolygonPainter.buildPolygon(dataX, dataY), z));
        }
        finally {
            this.updateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPolygon(int groupId, int polygonId, Polygon geometry, float z) {
        this.updateLock.lock();
        try {
            this.addPolygon(groupId, new IdPolygon(groupId, polygonId, geometry, z));
        }
        finally {
            this.updateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPolygon(int groupId, int polygonId, Shape shape, float z) {
        this.updateLock.lock();
        try {
            this.addPolygon(groupId, new IdPolygon(groupId, polygonId, PolygonPainter.buildPolygon(shape), z));
        }
        finally {
            this.updateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPolygon(int groupId, int polygonId, long startTime, long endTime, float[] dataX, float[] dataY, float z) {
        this.updateLock.lock();
        try {
            this.addPolygon(groupId, new IdPolygon(groupId, polygonId, startTime, endTime, PolygonPainter.buildPolygon(dataX, dataY), z));
        }
        finally {
            this.updateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPolygon(int groupId, int polygonId, long startTime, long endTime, Polygon geometry, float z) {
        this.updateLock.lock();
        try {
            this.addPolygon(groupId, new IdPolygon(groupId, polygonId, startTime, endTime, geometry, z));
        }
        finally {
            this.updateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPolygon(int groupId, int polygonId, long startTime, long endTime, Shape shape, float z) {
        this.updateLock.lock();
        try {
            this.addPolygon(groupId, new IdPolygon(groupId, polygonId, startTime, endTime, PolygonPainter.buildPolygon(shape), z));
        }
        finally {
            this.updateLock.unlock();
        }
    }

    public void displayTimeRange(int groupId, double startTime, double endTime) {
        this.displayTimeRange(groupId, (long)Math.ceil(startTime), (long)Math.floor(endTime));
    }

    public void displayTimeRange(double startTime, double endTime) {
        this.displayTimeRange((long)Math.ceil(startTime), (long)Math.floor(endTime));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayTimeRange(int groupId, long startTime, long endTime) {
        IdPolygon startPoint = this.createSearchBoundStart(startTime);
        IdPolygon endPoint = this.createSearchBoundEnd(endTime);
        this.updateLock.lock();
        try {
            Group group = this.getOrCreateGroup(groupId);
            group.setTimeRange(startPoint, endPoint);
            this.updatedGroups.add(group);
            this.newData = true;
        }
        finally {
            this.updateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayTimeRange(long startTime, long endTime) {
        this.globalSelectionStart = this.createSearchBoundStart(startTime);
        this.globalSelectionEnd = this.createSearchBoundEnd(endTime);
        this.updateLock.lock();
        try {
            for (Group group : this.groups.values()) {
                group.setTimeRange(this.globalSelectionStart, this.globalSelectionEnd);
            }
            this.updatedGroups.addAll(this.groups.values());
            this.newData = true;
        }
        finally {
            this.updateLock.unlock();
        }
    }

    protected IdPolygon createSearchBoundEnd(long time) {
        return new IdPolygon(Integer.MAX_VALUE, Integer.MAX_VALUE, time, time, null, 0.0f);
    }

    protected IdPolygon createSearchBoundStart(long time) {
        return new IdPolygon(Integer.MIN_VALUE, Integer.MIN_VALUE, time, time, null, 0.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLineColor(int groupId, float[] rgba) {
        this.updateLock.lock();
        try {
            Group group = this.getOrCreateGroup(groupId);
            group.setLineColor(rgba);
            this.updatedGroups.add(group);
            this.newData = true;
        }
        finally {
            this.updateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLineColor(int groupId, float r, float g, float b, float a) {
        this.updateLock.lock();
        try {
            Group group = this.getOrCreateGroup(groupId);
            group.setLineColor(r, g, b, a);
            this.updatedGroups.add(group);
            this.newData = true;
        }
        finally {
            this.updateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLineWidth(int groupId, float width) {
        this.updateLock.lock();
        try {
            Group group = this.getOrCreateGroup(groupId);
            group.setLineWidth(width);
            this.updatedGroups.add(group);
            this.newData = true;
        }
        finally {
            this.updateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShowLines(int groupId, boolean show) {
        this.updateLock.lock();
        try {
            Group group = this.getOrCreateGroup(groupId);
            group.setShowLines(show);
            this.updatedGroups.add(group);
            this.newData = true;
        }
        finally {
            this.updateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPolyDotted(int groupId, byte[] stipple) {
        this.updateLock.lock();
        try {
            Group group = this.getOrCreateGroup(groupId);
            group.setPolyStipple(true);
            group.setPolyStipple(stipple);
            this.updatedGroups.add(group);
            this.newData = true;
        }
        finally {
            this.updateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPolyDotted(int groupId, boolean dotted) {
        this.updateLock.lock();
        try {
            Group group = this.getOrCreateGroup(groupId);
            group.setPolyStipple(dotted);
            this.updatedGroups.add(group);
            this.newData = true;
        }
        finally {
            this.updateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLineDotted(int groupId, boolean dotted) {
        this.updateLock.lock();
        try {
            Group group = this.getOrCreateGroup(groupId);
            group.setLineStipple(dotted);
            this.updatedGroups.add(group);
            this.newData = true;
        }
        finally {
            this.updateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLineDotted(int groupId, int stippleFactor, short stipplePattern) {
        this.updateLock.lock();
        try {
            Group group = this.getOrCreateGroup(groupId);
            group.setLineStipple(true);
            group.setLineStipple(stippleFactor, stipplePattern);
            this.updatedGroups.add(group);
            this.newData = true;
        }
        finally {
            this.updateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFill(int groupId, boolean show) {
        this.updateLock.lock();
        try {
            Group group = this.getOrCreateGroup(groupId);
            group.setShowPoly(show);
            this.updatedGroups.add(group);
            this.newData = true;
        }
        finally {
            this.updateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFillColor(int groupId, float[] rgba) {
        this.updateLock.lock();
        try {
            Group group = this.getOrCreateGroup(groupId);
            group.setFillColor(rgba);
            this.updatedGroups.add(group);
            this.newData = true;
        }
        finally {
            this.updateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFillColor(int groupId, float r, float g, float b, float a) {
        this.updateLock.lock();
        try {
            Group group = this.getOrCreateGroup(groupId);
            group.setFillColor(r, g, b, a);
            this.updatedGroups.add(group);
            this.newData = true;
        }
        finally {
            this.updateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll() {
        this.updateLock.lock();
        try {
            for (Group group : this.groups.values()) {
                group.delete();
            }
            this.updatedGroups.addAll(this.groups.values());
            this.newData = true;
        }
        finally {
            this.updateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteGroup(int groupId) {
        this.updateLock.lock();
        try {
            if (!this.groups.containsKey(groupId)) {
                return;
            }
            Group group = this.groups.get(groupId);
            group.delete();
            this.updatedGroups.add(group);
            this.newData = true;
        }
        finally {
            this.updateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearGroup(int groupId) {
        this.updateLock.lock();
        try {
            if (!this.groups.containsKey(groupId)) {
                return;
            }
            Group group = this.groups.get(groupId);
            group.clear();
            this.updatedGroups.add(group);
            this.newData = true;
        }
        finally {
            this.updateLock.unlock();
        }
    }

    public void deletePolygon(int groupId, int polygonId) {
        throw new UnsupportedOperationException("Deletion of single polygons is not currently supported. Use deleteGroup() to remove an entire group.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPolygon(int groupId, IdPolygon polygon) {
        this.updateLock.lock();
        try {
            Group group = this.getOrCreateGroup(groupId);
            group.add(polygon);
            this.updatedGroups.add(group);
            this.newData = true;
        }
        finally {
            this.updateLock.unlock();
        }
    }

    protected Group getOrCreateGroup(int groupId) {
        Group group = this.groups.get(groupId);
        if (group == null) {
            group = new Group(groupId);
            if (this.globalSelectionStart != null && this.globalSelectionEnd != null) {
                group.setTimeRange(this.globalSelectionStart, this.globalSelectionEnd);
            }
            this.groups.put(groupId, group);
        }
        return group;
    }

    protected void ensureDataBufferSize(int needed) {
        if (this.dataBuffer == null || this.dataBufferSize < needed) {
            this.dataBufferSize = needed;
            this.dataBuffer = ByteBuffer.allocateDirect(needed * 3 * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        }
        this.dataBuffer.rewind();
    }

    protected LoadedGroup getOrCreateLoadedGroup(int id, Group group) {
        LoadedGroup loaded = this.loadedGroups.get(id);
        if (loaded == null) {
            loaded = new LoadedGroup(group);
            this.loadedGroups.put(id, loaded);
        }
        return loaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintTo(GlimpseContext context, GlimpseBounds bounds, Axis2D axis) {
        GL gl = context.getGL();
        if (this.newData) {
            this.updateLock.lock();
            try {
                for (Group group : this.updatedGroups) {
                    LoadedGroup loaded;
                    int id = group.groupId;
                    if (group.isDeletePending() || group.isClearPending()) {
                        loaded = this.getOrCreateLoadedGroup(id, group);
                        loaded.dispose(gl);
                        this.loadedGroups.remove(id);
                        if (group.isDeletePending() && !group.isDataInserted()) {
                            this.groups.remove(id);
                            continue;
                        }
                    }
                    loaded = this.getOrCreateLoadedGroup(id, group);
                    loaded.loadSettings(group);
                    if (group.isDataInserted()) {
                        int insertVertices;
                        int insertCount;
                        int[] bufferHandle;
                        if (!loaded.glLineBufferInitialized || loaded.glLineBufferMaxSize < group.getTotalLineVertices()) {
                            if (loaded.glLineBufferInitialized) {
                                gl.glDeleteBuffers(1, new int[]{loaded.glLineBufferHandle}, 0);
                                loaded.glLineBufferMaxSize = Math.max((int)((double)loaded.glLineBufferMaxSize * 1.5), group.getTotalLineVertices());
                            } else {
                                loaded.glLineBufferMaxSize = group.getTotalLineVertices();
                            }
                            this.ensureDataBufferSize(loaded.glLineBufferMaxSize);
                            loaded.loadLineVerticesIntoBuffer(group, this.dataBuffer, 0, 0, group.getPolygonCount());
                            bufferHandle = new int[1];
                            gl.glGenBuffers(1, bufferHandle, 0);
                            loaded.glLineBufferHandle = bufferHandle[0];
                            loaded.loadLineSelectionIntoBuffer(group.selectedPolygons, group.selectedLinePrimitiveCount, 0);
                            gl.glBindBuffer(34962, loaded.glLineBufferHandle);
                            this.glHandleError(gl, "glBindBuffer Line Error (Case 1)");
                            gl.glBufferData(34962, loaded.glLineBufferMaxSize * 3 * 4, this.dataBuffer.rewind(), 35048);
                            this.glHandleError(gl, "glBufferData Line Error");
                            loaded.glLineBufferInitialized = true;
                        } else {
                            int insertOffset = group.getOffsetInsertPolygons();
                            insertCount = group.getCountInsertPolygons();
                            insertVertices = group.getLineInsertCountVertices();
                            this.ensureDataBufferSize(insertVertices);
                            loaded.loadLineVerticesIntoBuffer(group, this.dataBuffer, loaded.glLineBufferCurrentSize, insertOffset, insertCount);
                            loaded.loadLineSelectionIntoBuffer(group.newSelectedPolygons, group.selectedLinePrimitiveCount);
                            gl.glBindBuffer(34962, loaded.glLineBufferHandle);
                            this.glHandleError(gl, "glBindBuffer Line Error  (Case 2)");
                            gl.glBufferSubData(34962, loaded.glLineBufferCurrentSize * 3 * 4, insertVertices * 3 * 4, this.dataBuffer.rewind());
                            this.glHandleError(gl, "glBufferSubData Line Error");
                        }
                        loaded.glLineBufferCurrentSize = group.getTotalLineVertices();
                        if (!loaded.glFillBufferInitialized || loaded.glFillBufferMaxSize < group.getTotalFillVertices()) {
                            if (loaded.glFillBufferInitialized) {
                                gl.glDeleteBuffers(1, new int[]{loaded.glFillBufferHandle}, 0);
                                loaded.glFillBufferMaxSize = Math.max((int)((double)loaded.glFillBufferMaxSize * 1.5), group.getTotalFillVertices());
                            } else {
                                loaded.glFillBufferMaxSize = group.getTotalFillVertices();
                            }
                            this.ensureDataBufferSize(loaded.glFillBufferMaxSize);
                            loaded.loadFillVerticesIntoBuffer(group, this.dataBuffer, 0, 0, group.getPolygonCount());
                            bufferHandle = new int[1];
                            gl.glGenBuffers(1, bufferHandle, 0);
                            loaded.glFillBufferHandle = bufferHandle[0];
                            loaded.loadFillSelectionIntoBuffer(group.selectedPolygons, group.selectedFillPrimitiveCount, 0);
                            gl.glBindBuffer(34962, loaded.glFillBufferHandle);
                            this.glHandleError(gl, "glBindBuffer Fill Error  (Case 1)");
                            gl.glBufferData(34962, loaded.glFillBufferMaxSize * 3 * 4, this.dataBuffer.rewind(), 35048);
                            this.glHandleError(gl, "glBufferData Fill Error");
                            loaded.glFillBufferInitialized = true;
                        } else {
                            int insertOffset = group.getOffsetInsertPolygons();
                            insertCount = group.getCountInsertPolygons();
                            insertVertices = group.getFillInsertCountVertices();
                            this.ensureDataBufferSize(insertVertices);
                            loaded.loadFillVerticesIntoBuffer(group, this.dataBuffer, loaded.glFillBufferCurrentSize, insertOffset, insertCount);
                            loaded.loadFillSelectionIntoBuffer(group.newSelectedPolygons, group.selectedFillPrimitiveCount);
                            gl.glBindBuffer(34962, loaded.glFillBufferHandle);
                            this.glHandleError(gl, "glBindBuffer Fill Error  (Case 2)");
                            gl.glBufferSubData(34962, loaded.glFillBufferCurrentSize * 3 * 4, insertVertices * 3 * 4, this.dataBuffer.rewind());
                            this.glHandleError(gl, "glBufferSubData Fill Error");
                        }
                        loaded.glFillBufferCurrentSize = group.getTotalFillVertices();
                    }
                    if (group.selectionChanged && loaded.glLineBufferInitialized && loaded.glFillBufferInitialized) {
                        loaded.loadLineSelectionIntoBuffer(group.selectedPolygons, group.selectedLinePrimitiveCount, 0);
                        loaded.loadFillSelectionIntoBuffer(group.selectedPolygons, group.selectedFillPrimitiveCount, 0);
                    }
                    group.reset();
                }
                this.updatedGroups.clear();
                this.newData = false;
            }
            finally {
                this.updateLock.unlock();
            }
            this.glHandleError(gl, "Update Error");
        }
        if (this.loadedGroups.isEmpty()) {
            return;
        }
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glOrtho(axis.getMinX(), axis.getMaxX(), axis.getMinY(), axis.getMaxY(), -8388608.0, 1.0);
        gl.glBlendFunc(770, 771);
        gl.glEnable(3042);
        gl.glEnable(2848);
        gl.glEnableClientState(32884);
        for (LoadedGroup loaded : this.loadedGroups.values()) {
            int offset;
            int fillCountTotal;
            int fillCountRemaining;
            int fillCount;
            int i;
            if (!loaded.glFillBufferInitialized || !loaded.glLineBufferInitialized) continue;
            if (loaded.fillOn) {
                gl.glColor4fv(loaded.fillColor, 0);
                if (loaded.polyStippleOn) {
                    gl.glEnable(2882);
                    gl.glPolygonStipple(loaded.polyStipplePattern, 0);
                }
                gl.glBindBuffer(34962, loaded.glFillBufferHandle);
                gl.glVertexPointer(3, 5126, 0, 0L);
                loaded.glFillOffsetBuffer.rewind();
                loaded.glFillCountBuffer.rewind();
                for (i = 0; i < loaded.glTotalFillPrimitives; ++i) {
                    for (fillCountRemaining = fillCountTotal = loaded.glFillCountBuffer.get(i); fillCountRemaining > 0; fillCountRemaining -= fillCount) {
                        fillCount = Math.min(60000, fillCountRemaining);
                        offset = loaded.glFillOffsetBuffer.get(i) + (fillCountTotal - fillCountRemaining);
                        gl.glDrawArrays(4, offset, fillCount);
                    }
                }
                if (loaded.polyStippleOn) {
                    gl.glDisable(2882);
                }
            }
            if (!loaded.linesOn) continue;
            gl.glColor4fv(loaded.lineColor, 0);
            gl.glLineWidth(loaded.lineWidth);
            if (loaded.lineStippleOn) {
                gl.glEnable(2852);
                gl.glLineStipple(loaded.lineStippleFactor, loaded.lineStipplePattern);
            }
            gl.glBindBuffer(34962, loaded.glLineBufferHandle);
            gl.glVertexPointer(3, 5126, 0, 0L);
            loaded.glLineOffsetBuffer.rewind();
            loaded.glLineCountBuffer.rewind();
            for (i = 0; i < loaded.glTotalLinePrimitives; ++i) {
                for (fillCountRemaining = fillCountTotal = loaded.glLineCountBuffer.get(i); fillCountRemaining > 0; fillCountRemaining -= fillCount) {
                    fillCount = Math.min(60000, fillCountRemaining);
                    offset = loaded.glLineOffsetBuffer.get(i) + (fillCountTotal - fillCountRemaining);
                    gl.glDrawArrays(2, offset, fillCount);
                }
            }
            if (!loaded.lineStippleOn) continue;
            gl.glDisable(2852);
        }
        this.glHandleError(gl, "Draw Error");
        gl.glDisable(2929);
        gl.glDisable(3042);
        gl.glDisable(2848);
    }

    protected static Polygon buildPolygon(float[] geometryX, float[] geometryY) {
        Polygon p = new Polygon();
        int size = Math.min(geometryX.length, geometryY.length);
        double[] geometry = new double[size * 2];
        for (int i = 0; i < size; ++i) {
            geometry[2 * i] = geometryX[i];
            geometry[2 * i + 1] = geometryY[i];
        }
        Polygon.Loop.LoopBuilder b = new Polygon.Loop.LoopBuilder();
        b.addVertices(geometry, size);
        p.add(b.complete(Polygon.Interior.onRight));
        return p;
    }

    protected static Polygon buildPolygon(Shape shape) {
        Polygon p = new Polygon();
        PathIterator iter = shape.getPathIterator(null);
        double[] vertices = new double[6];
        Polygon.Loop.LoopBuilder b = new Polygon.Loop.LoopBuilder();
        while (!iter.isDone()) {
            int type = iter.currentSegment(vertices);
            if (type == 4) {
                p.add(b.complete(Polygon.Interior.onLeft));
                b = new Polygon.Loop.LoopBuilder();
            } else if (type == 1) {
                b.addVertices(vertices, 1);
            } else if (type == 0) {
                p.add(b.complete(Polygon.Interior.onLeft));
                b = new Polygon.Loop.LoopBuilder();
                b.addVertices(vertices, 1);
            } else {
                throw new UnsupportedOperationException("Shape Not Supported.");
            }
            iter.next();
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose(GLContext context) {
        GL gl = context.getGL();
        this.updateLock.lock();
        try {
            for (LoadedGroup group : this.loadedGroups.values()) {
                group.dispose(gl);
            }
        }
        finally {
            this.updateLock.unlock();
        }
        this.tessellator.destroy();
    }

    private class Group {
        float[] lineColor = new float[]{1.0f, 1.0f, 0.0f, 1.0f};
        float lineWidth = 1.0f;
        boolean linesOn = true;
        int lineStippleFactor = 1;
        short lineStipplePattern = (short)255;
        boolean lineStippleOn = false;
        byte[] polyStipplePattern;
        boolean polyStippleOn;
        float[] fillColor;
        boolean fillOn;
        int groupId;
        List<IdPolygon> polygonIndices;
        NavigableSet<IdPolygon> startTimes;
        NavigableSet<IdPolygon> endTimes;
        Set<IdPolygon> selectedPolygons;
        Set<IdPolygon> newSelectedPolygons;
        IdPolygon selectionStart;
        IdPolygon selectionEnd;
        int selectedFillPrimitiveCount;
        int selectedLinePrimitiveCount;
        int totalFillVertexCount;
        int totalLineVertexCount;
        int fillInsertVertexCount;
        int lineInsertVertexCount;
        int offsetInsertPolygons;
        boolean selectionChanged;
        boolean dataInserted;
        boolean deletePending;
        boolean clearPending;

        public Group(int groupId) {
            this.polyStipplePattern = PolygonPainter.this.halftone;
            this.polyStippleOn = false;
            this.fillColor = new float[]{1.0f, 0.0f, 0.0f, 1.0f};
            this.fillOn = false;
            this.selectionChanged = false;
            this.dataInserted = false;
            this.deletePending = false;
            this.clearPending = false;
            this.groupId = groupId;
            this.selectedPolygons = new LinkedHashSet<IdPolygon>();
            this.newSelectedPolygons = new LinkedHashSet<IdPolygon>();
            this.polygonIndices = new LinkedList<IdPolygon>();
            this.startTimes = new TreeSet<IdPolygon>(startTimeComparator);
            this.endTimes = new TreeSet<IdPolygon>(endTimeComparator);
            this.selectionStart = PolygonPainter.this.createSearchBoundStart(-9223372036854775807L);
            this.selectionEnd = PolygonPainter.this.createSearchBoundEnd(Long.MAX_VALUE);
        }

        public void delete() {
            this.deletePending = true;
            this.clear();
        }

        public void clear() {
            this.polygonIndices.clear();
            this.startTimes.clear();
            this.endTimes.clear();
            this.totalLineVertexCount = 0;
            this.lineInsertVertexCount = 0;
            this.totalFillVertexCount = 0;
            this.fillInsertVertexCount = 0;
            this.selectedPolygons.clear();
            this.newSelectedPolygons.clear();
            this.selectedFillPrimitiveCount = 0;
            this.selectedLinePrimitiveCount = 0;
            this.offsetInsertPolygons = 0;
            this.dataInserted = false;
            this.selectionChanged = false;
            this.clearPending = true;
        }

        public void add(IdPolygon polygon) {
            int polygonInsertIndex = this.polygonIndices.size();
            this.polygonIndices.add(polygon);
            this.startTimes.add(polygon);
            this.endTimes.add(polygon);
            int lineVertexCount = polygon.lineVertexCount;
            this.totalLineVertexCount += lineVertexCount;
            this.lineInsertVertexCount += lineVertexCount;
            int fillVertexCount = polygon.fillVertexCount;
            this.totalFillVertexCount += fillVertexCount;
            this.fillInsertVertexCount += fillVertexCount;
            if (polygon.getStartTime() <= this.selectionEnd.endTime && polygon.getEndTime() >= this.selectionStart.startTime) {
                this.selectedFillPrimitiveCount += polygon.fillPrimitiveCount;
                this.selectedLinePrimitiveCount += polygon.linePrimitiveCount;
                this.selectedPolygons.add(polygon);
                this.newSelectedPolygons.add(polygon);
            }
            if (!this.dataInserted || polygonInsertIndex < this.offsetInsertPolygons) {
                this.offsetInsertPolygons = polygonInsertIndex;
                this.dataInserted = true;
            }
        }

        public void setTimeRange(IdPolygon startPoint, IdPolygon endPoint) {
            this.selectionStart = startPoint;
            this.selectionEnd = endPoint;
            this.checkTimeRange();
        }

        public void checkTimeRange() {
            if (this.selectionStart == null || this.selectionEnd == null) {
                return;
            }
            NavigableSet<IdPolygon> startSet = this.startTimes.headSet(this.selectionEnd, true);
            NavigableSet<IdPolygon> endSet = this.endTimes.tailSet(this.selectionStart, true);
            this.selectedPolygons.clear();
            this.selectedPolygons.addAll(startSet);
            this.selectedPolygons.retainAll(endSet);
            this.selectedFillPrimitiveCount = 0;
            this.selectedLinePrimitiveCount = 0;
            for (IdPolygon polygon : this.selectedPolygons) {
                this.selectedFillPrimitiveCount += polygon.fillPrimitiveCount;
                this.selectedLinePrimitiveCount += polygon.linePrimitiveCount;
            }
            this.selectionChanged = true;
        }

        public void setLineColor(float[] rgba) {
            this.lineColor = rgba;
        }

        public void setLineColor(float r, float g, float b, float a) {
            this.lineColor[0] = r;
            this.lineColor[1] = g;
            this.lineColor[2] = b;
            this.lineColor[3] = a;
        }

        public void setFillColor(float[] rgba) {
            this.fillColor = rgba;
        }

        public void setFillColor(float r, float g, float b, float a) {
            this.fillColor[0] = r;
            this.fillColor[1] = g;
            this.fillColor[2] = b;
            this.fillColor[3] = a;
        }

        public void setLineWidth(float width) {
            this.lineWidth = width;
        }

        public void setShowLines(boolean show) {
            this.linesOn = show;
        }

        public void setShowPoly(boolean show) {
            this.fillOn = show;
        }

        public void setPolyStipple(boolean activate) {
            this.polyStippleOn = activate;
        }

        public void setPolyStipple(byte[] pattern) {
            this.polyStipplePattern = pattern;
        }

        public void setLineStipple(boolean activate) {
            this.lineStippleOn = activate;
        }

        public void setLineStipple(int stippleFactor, short stipplePattern) {
            this.lineStippleFactor = stippleFactor;
            this.lineStipplePattern = stipplePattern;
        }

        public boolean isDataInserted() {
            return this.dataInserted;
        }

        public boolean isDeletePending() {
            return this.deletePending;
        }

        public boolean isClearPending() {
            return this.clearPending;
        }

        public void reset() {
            this.newSelectedPolygons.clear();
            this.lineInsertVertexCount = 0;
            this.fillInsertVertexCount = 0;
            this.dataInserted = false;
            this.selectionChanged = false;
            this.clearPending = false;
            this.deletePending = false;
        }

        public int getLineInsertCountVertices() {
            return this.lineInsertVertexCount;
        }

        public int getFillInsertCountVertices() {
            return this.fillInsertVertexCount;
        }

        public int getOffsetInsertPolygons() {
            return this.offsetInsertPolygons;
        }

        public int getCountInsertPolygons() {
            return this.getPolygonCount() - this.getOffsetInsertPolygons();
        }

        public int getTotalLineVertices() {
            return this.totalLineVertexCount;
        }

        public int getTotalFillVertices() {
            return this.totalFillVertexCount;
        }

        public int getPolygonCount() {
            return this.polygonIndices.size();
        }
    }

    private static class LoadedGroup {
        float[] lineColor = new float[4];
        float lineWidth;
        boolean linesOn;
        int lineStippleFactor;
        short lineStipplePattern;
        boolean lineStippleOn;
        byte[] polyStipplePattern = new byte[32];
        boolean polyStippleOn;
        float[] fillColor = new float[4];
        boolean fillOn;
        boolean glFillBufferInitialized = false;
        boolean glLineBufferInitialized = false;
        int glFillBufferHandle;
        int glLineBufferHandle;
        int glFillBufferMaxSize;
        int glLineBufferMaxSize;
        int glFillBufferCurrentSize;
        int glLineBufferCurrentSize;
        IntBuffer glLineOffsetBuffer;
        IntBuffer glFillOffsetBuffer;
        IntBuffer glLineCountBuffer;
        IntBuffer glFillCountBuffer;
        int glTotalLinePrimitives;
        int glTotalFillPrimitives;

        public LoadedGroup(Group group) {
            this.loadSettings(group);
        }

        public void loadSettings(Group group) {
            this.glTotalLinePrimitives = group.selectedLinePrimitiveCount;
            this.glTotalFillPrimitives = group.selectedFillPrimitiveCount;
            this.lineColor[0] = group.lineColor[0];
            this.lineColor[1] = group.lineColor[1];
            this.lineColor[2] = group.lineColor[2];
            this.lineColor[3] = group.lineColor[3];
            this.fillColor[0] = group.fillColor[0];
            this.fillColor[1] = group.fillColor[1];
            this.fillColor[2] = group.fillColor[2];
            this.fillColor[3] = group.fillColor[3];
            this.lineWidth = group.lineWidth;
            this.fillOn = group.fillOn;
            this.linesOn = group.linesOn;
            this.lineStippleOn = group.lineStippleOn;
            this.polyStippleOn = group.polyStippleOn;
            this.lineStippleFactor = group.lineStippleFactor;
            this.lineStipplePattern = group.lineStipplePattern;
            System.arraycopy(group.polyStipplePattern, 0, this.polyStipplePattern, 0, this.polyStipplePattern.length);
        }

        protected void ensureLineOffsetBufferSize(int neededSize) {
            this.glLineOffsetBuffer = this.ensureBufferSize(this.glLineOffsetBuffer, neededSize);
        }

        protected void ensureLineCountBufferSize(int neededSize) {
            this.glLineCountBuffer = this.ensureBufferSize(this.glLineCountBuffer, neededSize);
        }

        protected void ensureFillOffsetBufferSize(int neededSize) {
            this.glFillOffsetBuffer = this.ensureBufferSize(this.glFillOffsetBuffer, neededSize);
        }

        protected void ensureFillCountBufferSize(int neededSize) {
            this.glFillCountBuffer = this.ensureBufferSize(this.glFillCountBuffer, neededSize);
        }

        protected IntBuffer ensureBufferSize(IntBuffer buffer, int neededSize) {
            if (buffer == null || buffer.capacity() < neededSize) {
                int newCapacity = this.getNewBufferCapacity(buffer, neededSize);
                IntBuffer temp = ByteBuffer.allocateDirect(newCapacity * 4).order(ByteOrder.nativeOrder()).asIntBuffer();
                if (buffer != null) {
                    buffer.rewind();
                    temp.put(buffer);
                }
                buffer = temp;
            }
            buffer.rewind();
            return buffer;
        }

        protected int getNewBufferCapacity(IntBuffer buffer, int neededSize) {
            if (buffer != null) {
                return Math.max((int)((double)buffer.capacity() * 1.5), neededSize);
            }
            return neededSize;
        }

        public void loadLineVerticesIntoBuffer(Group group, FloatBuffer vertexBuffer, int offsetVertex, int offset, int size) {
            int vertexCount = 0;
            for (int i = 0; i < size; ++i) {
                IdPolygon polygon = group.polygonIndices.get(offset + i);
                vertexCount += polygon.loadLineVerticesIntoBuffer(polygon.depth, vertexBuffer, offsetVertex + vertexCount);
            }
        }

        public void loadLineSelectionIntoBuffer(Collection<IdPolygon> polygons, int size) {
            int primitiveCount = 0;
            for (IdPolygon polygon : polygons) {
                primitiveCount += polygon.linePrimitiveCount;
            }
            this.loadLineSelectionIntoBuffer(polygons, size, size - primitiveCount);
        }

        public void loadLineSelectionIntoBuffer(Collection<IdPolygon> polygons, int size, int offset) {
            this.ensureLineOffsetBufferSize(size);
            this.ensureLineCountBufferSize(size);
            if (size <= 0 || offset < 0) {
                return;
            }
            this.glLineOffsetBuffer.position(offset);
            this.glLineCountBuffer.position(offset);
            for (IdPolygon polygon : polygons) {
                polygon.loadLineIntoBuffer(this.glLineOffsetBuffer, this.glLineCountBuffer);
            }
        }

        public void loadFillVerticesIntoBuffer(Group group, FloatBuffer vertexBuffer, int offsetVertex, int offset, int size) {
            if (size <= 0) {
                return;
            }
            int vertexCount = 0;
            for (int i = 0; i < size; ++i) {
                IdPolygon polygon = group.polygonIndices.get(offset + i);
                vertexCount += polygon.loadFillVerticesIntoBuffer(polygon.depth + 0.5f, vertexBuffer, offsetVertex + vertexCount);
            }
        }

        public void loadFillSelectionIntoBuffer(Collection<IdPolygon> polygons, int size) {
            if (size <= 0) {
                return;
            }
            int primitiveCount = 0;
            for (IdPolygon polygon : polygons) {
                primitiveCount += polygon.fillPrimitiveCount;
            }
            this.loadFillSelectionIntoBuffer(polygons, size, size - primitiveCount);
        }

        public void loadFillSelectionIntoBuffer(Collection<IdPolygon> polygons, int size, int offset) {
            this.ensureFillOffsetBufferSize(size);
            this.ensureFillCountBufferSize(size);
            if (size <= 0 || offset < 0) {
                return;
            }
            this.glFillOffsetBuffer.position(offset);
            this.glFillCountBuffer.position(offset);
            for (IdPolygon polygon : polygons) {
                polygon.loadFillIntoBuffer(this.glFillOffsetBuffer, this.glFillCountBuffer);
            }
        }

        public void dispose(GL gl) {
            if (this.glLineBufferInitialized) {
                gl.glDeleteBuffers(1, new int[]{this.glLineBufferHandle}, 0);
                gl.glDeleteBuffers(1, new int[]{this.glFillBufferHandle}, 0);
            }
        }
    }

    private class IdPolygon {
        int groupId;
        int polygonId;
        long startTime;
        long endTime;
        Polygon geometry;
        float[] fillVertices;
        float depth;
        int lineVertexCount;
        int fillVertexCount;
        int linePrimitiveCount;
        int fillPrimitiveCount;
        int[] lineOffsets;
        int[] lineSizes;
        int[] fillOffsets;
        int[] fillSizes;

        protected IdPolygon(int groupId, int polygonId, long startTime, long endTime, Polygon geometry, float depth) {
            this.groupId = groupId;
            this.polygonId = polygonId;
            this.startTime = startTime;
            this.endTime = endTime;
            this.geometry = geometry;
            this.depth = depth;
            if (this.geometry != null) {
                this.calculateLineCounts();
                this.calculateFillCounts();
                this.lineOffsets = new int[this.linePrimitiveCount];
                this.lineSizes = new int[this.linePrimitiveCount];
                this.fillOffsets = new int[this.fillPrimitiveCount];
                this.fillSizes = new int[this.fillPrimitiveCount];
            }
        }

        protected IdPolygon(int groupId, int polygonId, Polygon geometry, float z) {
            this(groupId, polygonId, Long.MIN_VALUE, Long.MAX_VALUE, geometry, z);
        }

        protected void calculateLineCounts() {
            int vertexCount = 0;
            int primitiveCount = 0;
            Iterator<Polygon.Loop> iter = this.geometry.getIterator();
            while (iter.hasNext()) {
                Polygon.Loop loop = iter.next();
                int size = loop.size();
                vertexCount += size;
                ++primitiveCount;
            }
            this.lineVertexCount = vertexCount;
            this.linePrimitiveCount = primitiveCount;
        }

        protected void calculateFillCounts() {
            this.fillVertices = this.tessellate();
            this.fillVertexCount = this.fillVertices.length / 2;
            this.fillPrimitiveCount = 1;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public int loadLineVerticesIntoBuffer(float zCoord, FloatBuffer vertexBuffer, int offsetVertex) {
            int totalSize = 0;
            int primitiveCount = 0;
            Iterator<Polygon.Loop> iter = this.geometry.getIterator();
            while (iter.hasNext()) {
                Polygon.Loop loop = iter.next();
                int size = loop.size();
                for (int i = 0; i < size; ++i) {
                    double[] vertex = loop.get(i);
                    vertexBuffer.put((float)vertex[0]).put((float)vertex[1]).put(zCoord);
                }
                this.lineOffsets[primitiveCount] = offsetVertex + totalSize;
                this.lineSizes[primitiveCount] = size;
                ++primitiveCount;
                totalSize += size;
            }
            return this.lineVertexCount;
        }

        public void loadLineIntoBuffer(IntBuffer offsetBuffer, IntBuffer sizeBuffer) {
            for (int index = 0; index < this.linePrimitiveCount; ++index) {
                offsetBuffer.put(this.lineOffsets[index]);
                sizeBuffer.put(this.lineSizes[index]);
            }
        }

        public int loadFillVerticesIntoBuffer(float zCoord, FloatBuffer vertexBuffer, int offsetVertex) {
            for (int i = 0; i < this.fillVertexCount * 2; ++i) {
                vertexBuffer.put(this.fillVertices[i]);
                if (i % 2 == 0) continue;
                vertexBuffer.put(zCoord);
            }
            this.fillOffsets[0] = offsetVertex;
            this.fillSizes[0] = this.fillVertexCount;
            return this.fillVertexCount;
        }

        public void loadFillIntoBuffer(IntBuffer offsetBuffer, IntBuffer sizeBuffer) {
            offsetBuffer.put(this.fillOffsets[0]);
            sizeBuffer.put(this.fillSizes[0]);
        }

        protected float[] tessellate() {
            try {
                SimpleVertexAccumulator accumulator = new SimpleVertexAccumulator();
                PolygonPainter.this.tessellator.tessellate(this.geometry, accumulator);
                return accumulator.getVertices();
            }
            catch (PolygonTessellator.TessellationException e) {
                LoggerUtils.logWarning((Logger)GlimpsePainterImpl.logger, (String)"Problem tessellating polygon.", (Throwable)e, (Object[])new Object[0]);
                return new float[0];
            }
        }

        private PolygonPainter getOuterType() {
            return PolygonPainter.this;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + this.groupId;
            result = 31 * result + this.polygonId;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IdPolygon other = (IdPolygon)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.groupId != other.groupId) {
                return false;
            }
            return this.polygonId == other.polygonId;
        }

        public String toString() {
            return "[ " + this.groupId + ", " + this.polygonId + ", " + this.startTime + ", " + this.endTime + " ]";
        }
    }
}

