/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.painter.shape;

import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.painter.base.GlimpseDataPainter2D;
import com.metsci.glimpse.painter.shape.PointSetPainter;
import com.metsci.glimpse.util.quadtree.QuadTreeXys;
import com.metsci.glimpse.util.quadtree.Xy;
import com.sun.opengl.util.BufferUtil;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.concurrent.locks.ReentrantLock;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;

public class LineSetPainter
extends GlimpseDataPainter2D {
    public static final int QUAD_TREE_BIN_MAX = 1000;
    protected float[] lineColor = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    protected float lineWidth = 1.0f;
    protected int totalPointCount = 0;
    protected int lineCount = 0;
    protected int[] bufferHandle = null;
    protected FloatBuffer dataBuffer = null;
    protected IntBuffer offsetBuffer = null;
    protected IntBuffer sizeBuffer = null;
    protected ReentrantLock dataBufferLock = new ReentrantLock();
    protected volatile boolean newData = false;
    protected volatile boolean bufferInitialized = false;
    protected QuadTreeXys<PointSetPainter.IdXy> spatialIndex;
    protected boolean enableSpatialIndex;

    public LineSetPainter() {
        this(false);
    }

    public LineSetPainter(boolean enableSpatialIndex) {
        this.enableSpatialIndex = enableSpatialIndex;
    }

    public void setData(float[] dataX, float[] dataY) {
        float[][] tempX = new float[1][dataX.length];
        tempX[0] = dataX;
        float[][] tempY = new float[1][dataY.length];
        tempY[0] = dataY;
        this.setData(tempX, tempY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(float[][] dataX, float[][] dataY) {
        this.dataBufferLock.lock();
        try {
            int i;
            int trackLength;
            float[] trackY;
            float[] trackX;
            int trackId;
            this.lineCount = Math.min(dataX.length, dataY.length);
            for (int trackId2 = 0; trackId2 < this.lineCount; ++trackId2) {
                int pointCount = Math.min(dataX[trackId2].length, dataY[trackId2].length);
                this.totalPointCount += pointCount;
            }
            if (this.dataBuffer == null || this.dataBuffer.rewind().capacity() < this.totalPointCount * 2) {
                this.dataBuffer = BufferUtil.newFloatBuffer((int)(this.totalPointCount * 2));
            }
            if (this.sizeBuffer == null || this.sizeBuffer.rewind().capacity() < this.lineCount) {
                this.sizeBuffer = BufferUtil.newIntBuffer((int)this.lineCount);
            }
            if (this.offsetBuffer == null || this.offsetBuffer.rewind().capacity() < this.lineCount) {
                this.offsetBuffer = BufferUtil.newIntBuffer((int)this.lineCount);
            }
            int pointCount = 0;
            for (trackId = 0; trackId < this.lineCount; ++trackId) {
                trackX = dataX[trackId];
                trackY = dataY[trackId];
                trackLength = Math.min(dataX[trackId].length, dataY[trackId].length);
                this.offsetBuffer.put(pointCount);
                this.sizeBuffer.put(trackLength);
                pointCount += trackLength;
                for (i = 0; i < trackLength; ++i) {
                    this.dataBuffer.put(trackX[i]).put(trackY[i]);
                }
            }
            pointCount = 0;
            if (this.enableSpatialIndex) {
                this.spatialIndex = new QuadTreeXys(1000);
                for (trackId = 0; trackId < this.lineCount; ++trackId) {
                    trackX = dataX[trackId];
                    trackY = dataY[trackId];
                    trackLength = Math.min(dataX[trackId].length, dataY[trackId].length);
                    for (i = 0; i < trackLength; ++i) {
                        this.spatialIndex.add((Xy)new PointSetPainter.IdXy(pointCount++, trackX[i], trackY[i]));
                    }
                }
            }
            this.newData = true;
        }
        finally {
            this.dataBufferLock.unlock();
        }
    }

    public void setLineColor(float r, float g, float b, float a) {
        this.lineColor[0] = r;
        this.lineColor[1] = g;
        this.lineColor[2] = b;
        this.lineColor[3] = a;
    }

    public void setLineColor(float[] color) {
        this.lineColor = color;
    }

    public void setLineWidth(float width) {
        this.lineWidth = width;
    }

    @Override
    public void dispose(GLContext context) {
        if (this.bufferInitialized) {
            context.getGL().glDeleteBuffers(1, this.bufferHandle, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintTo(GL gl, GlimpseBounds bounds, Axis2D axis) {
        if (this.lineCount == 0) {
            return;
        }
        if (!this.bufferInitialized) {
            this.bufferHandle = new int[1];
            gl.glGenBuffers(1, this.bufferHandle, 0);
            this.bufferInitialized = true;
        }
        gl.glBindBuffer(34962, this.bufferHandle[0]);
        if (this.newData) {
            this.dataBufferLock.lock();
            try {
                gl.glBufferData(34962, this.totalPointCount * 2 * 4, this.dataBuffer.rewind(), 35048);
                this.glHandleError(gl);
                this.newData = false;
            }
            finally {
                this.dataBufferLock.unlock();
            }
        }
        gl.glBindBuffer(34962, this.bufferHandle[0]);
        gl.glVertexPointer(2, 5126, 0, 0L);
        gl.glEnableClientState(32884);
        gl.glColor4fv(this.lineColor, 0);
        gl.glLineWidth(this.lineWidth);
        this.offsetBuffer.rewind();
        this.sizeBuffer.rewind();
        gl.glMultiDrawArrays(3, this.offsetBuffer, this.sizeBuffer, this.lineCount);
    }
}

