/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.painter.decoration;

import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.painter.base.GlimpsePainter2D;
import com.metsci.glimpse.support.color.GlimpseColor;
import com.metsci.glimpse.support.font.FontUtils;
import com.sun.opengl.util.j2d.TextRenderer;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;

public abstract class LegendPainter
extends GlimpsePainter2D {
    private Font textFont = FontUtils.getDefaultBold(15.0f);
    private float[] textColor = GlimpseColor.getBlack();
    protected int itemWidth = 30;
    private int spacer = 10;
    private TextRenderer textRenderer;
    private final List<String> list;
    private final Map<String, float[]> map;
    private LegendPlacement placement;
    private int offsetX = 10;
    private int offsetY = 10;

    public LegendPainter(LegendPlacement placement) {
        this.placement = placement;
        this.list = new ArrayList<String>();
        this.map = new HashMap<String, float[]>();
        this.setFont(15.0f, false);
    }

    public void setFont(Font font) {
        this.textFont = font;
        if (this.textRenderer != null) {
            this.textRenderer.dispose();
        }
        this.textRenderer = new TextRenderer(this.textFont, true, false);
    }

    public void setFont(float size, boolean bold) {
        this.setFont(bold ? FontUtils.getDefaultBold(size) : FontUtils.getDefaultPlain(size));
    }

    public void setTextColor(float[] rgba) {
        this.textColor = rgba;
    }

    public void setTextColor(float r, float g, float b, float a) {
        this.textColor[0] = r;
        this.textColor[1] = g;
        this.textColor[2] = b;
        this.textColor[3] = a;
    }

    public void addItem(String label, float r, float g, float b, float a) {
        this.addItem(label, new float[]{r, g, b, a});
    }

    public void addItem(String label, float[] rgba) {
        if (!this.map.containsKey(label)) {
            this.list.add(label);
        }
        this.map.put(label, rgba);
    }

    public void removeItem(String label) {
        this.list.remove(label);
        this.map.remove(label);
    }

    public void clear() {
        this.list.clear();
        this.map.clear();
    }

    public void setColor(String label, float r, float g, float b, float a) {
        float[] rgba = this.map.get(label);
        rgba[0] = r;
        rgba[1] = g;
        rgba[2] = b;
        rgba[3] = a;
    }

    public void setColor(String label, float[] rgba) {
        this.setColor(label, rgba[0], rgba[1], rgba[2], rgba[3]);
    }

    public void setPlacement(LegendPlacement placement) {
        this.placement = placement;
    }

    public void setOffsetX(int offset) {
        this.offsetX = offset;
    }

    public void setOffsetY(int offset) {
        this.offsetY = offset;
    }

    public void setOffset(int offsetX, int offsetY) {
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    public void setSpacing(int spacer) {
        this.spacer = spacer;
    }

    public void setLegendItemWidth(int width) {
        this.itemWidth = width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayLegend(GL gl, int width, int height) {
        int labelHeight;
        Rectangle2D bounds;
        int lw = 0;
        int lh = this.spacer;
        for (String l : this.list) {
            Rectangle2D bounds2 = this.textRenderer.getBounds(l);
            lh = (int)((double)lh + (bounds2.getHeight() + (double)this.spacer));
            lw = (int)Math.max(bounds2.getWidth() + (double)this.itemWidth + (double)this.spacer, (double)lw);
        }
        int lx = this.upperLeftX(width, height, lw += this.spacer * 2, lh);
        int ly = this.upperLeftY(width, height, lw, lh);
        gl.glColor4fv(GlimpseColor.getWhite(), 0);
        gl.glBegin(9);
        try {
            gl.glVertex2f((float)lx, (float)ly);
            gl.glVertex2f((float)lx, (float)(ly - lh));
            gl.glVertex2f((float)(lx + lw), (float)(ly - lh));
            gl.glVertex2f((float)(lx + lw), (float)ly);
        }
        finally {
            gl.glEnd();
        }
        gl.glColor4fv(GlimpseColor.getBlack(), 0);
        gl.glLineWidth(2.0f);
        gl.glBegin(2);
        try {
            gl.glVertex2f((float)lx, (float)ly);
            gl.glVertex2f((float)lx, (float)(ly - lh));
            gl.glVertex2f((float)(lx + lw), (float)(ly - lh));
            gl.glVertex2f((float)(lx + lw), (float)ly);
        }
        finally {
            gl.glEnd();
        }
        int xpos = lx + this.spacer;
        int ypos = ly - this.spacer;
        for (String label : this.list) {
            bounds = this.textRenderer.getBounds(label);
            labelHeight = (int)bounds.getHeight();
            float[] rgba = this.map.get(label);
            this.drawLegendItem(gl, label, xpos, ypos, rgba, labelHeight);
            ypos -= labelHeight + this.spacer;
        }
        xpos = lx + this.spacer + this.itemWidth + this.spacer;
        ypos = ly - this.spacer;
        this.textRenderer.beginRendering(width, height);
        GlimpseColor.setColor(this.textRenderer, this.textColor);
        try {
            for (String label : this.list) {
                bounds = this.textRenderer.getBounds(label);
                labelHeight = (int)bounds.getHeight();
                this.textRenderer.draw(label, xpos, ypos - labelHeight);
                ypos -= labelHeight + this.spacer;
            }
        }
        finally {
            this.textRenderer.endRendering();
        }
    }

    private int upperLeftX(int width, int height, int lw, int lh) {
        switch (this.placement) {
            case N: 
            case S: {
                return (width - lw) / 2;
            }
            case NE: 
            case E: 
            case SE: {
                return width - (lw + this.offsetX);
            }
            case NW: 
            case SW: 
            case W: {
                return this.offsetX;
            }
        }
        return 0;
    }

    private int upperLeftY(int width, int height, int lw, int lh) {
        switch (this.placement) {
            case N: 
            case NE: 
            case NW: {
                return height - this.offsetY;
            }
            case S: 
            case SE: 
            case SW: {
                return lh + this.offsetY;
            }
            case E: 
            case W: {
                return (height + lh) / 2;
            }
        }
        return 0;
    }

    protected abstract void drawLegendItem(GL var1, String var2, int var3, int var4, float[] var5, int var6);

    @Override
    public void dispose(GLContext context) {
        if (this.textRenderer != null) {
            this.textRenderer.dispose();
        }
        this.textRenderer = null;
    }

    @Override
    public void paintTo(GlimpseContext context, GlimpseBounds bounds, Axis2D axis) {
        GL gl = context.getGL();
        int width = bounds.getWidth();
        int height = bounds.getHeight();
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glOrtho(0.0, (double)width, 0.0, (double)height, -1.0, 1.0);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        gl.glBlendFunc(770, 771);
        gl.glEnable(3042);
        gl.glEnable(2848);
        gl.glEnable(2832);
        if (this.isVisible() && !this.list.isEmpty()) {
            this.displayLegend(gl, width, height);
        }
    }

    public static class LineLegendPainter
    extends LegendPainter {
        private Set<String> stippleLabels;
        private int stippleFactor = 1;
        private short stipplePattern = (short)255;

        public LineLegendPainter(LegendPlacement placement) {
            super(placement);
            this.stippleLabels = new HashSet<String>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void drawLegendItem(GL gl, String label, int xpos, int ypos, float[] rgba, int height) {
            gl.glColor4fv(rgba, 0);
            if (this.stippleLabels.contains(label)) {
                gl.glEnable(2852);
                gl.glLineStipple(this.stippleFactor, this.stipplePattern);
            } else {
                gl.glDisable(2852);
            }
            gl.glLineWidth(1.0f);
            gl.glBegin(3);
            double ymid = (double)ypos - (double)height / 2.0;
            try {
                gl.glVertex2d((double)xpos, ymid);
                gl.glVertex2d((double)(xpos + this.itemWidth), ymid);
            }
            finally {
                gl.glEnd();
            }
        }

        public void setLineStipplePattern(int stippleFactor, short stipplePattern) {
            this.stippleFactor = stippleFactor;
            this.stipplePattern = stipplePattern;
        }

        public void setLineStipple(String label, boolean stipple) {
            if (stipple) {
                this.stippleLabels.add(label);
            } else {
                this.stippleLabels.remove(label);
            }
        }

        public void addItem(String label, float r, float g, float b, float a, boolean stipple) {
            this.addItem(label, r, g, b, a);
            this.setLineStipple(label, stipple);
        }

        public void addItem(String label, float[] rgba, boolean stipple) {
            this.addItem(label, rgba);
            this.setLineStipple(label, stipple);
        }

        @Override
        public void removeItem(String label) {
            super.removeItem(label);
            this.stippleLabels.remove(label);
        }

        @Override
        public void clear() {
            super.clear();
            this.stippleLabels.clear();
        }
    }

    public static class BlockLegendPainter
    extends LegendPainter {
        public BlockLegendPainter(LegendPlacement placement) {
            super(placement);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void drawLegendItem(GL gl, String label, int xpos, int ypos, float[] rgba, int height) {
            gl.glColor4fv(rgba, 0);
            gl.glBegin(9);
            try {
                gl.glVertex2d((double)xpos, (double)ypos);
                gl.glVertex2d((double)(xpos + this.itemWidth), (double)ypos);
                gl.glVertex2d((double)(xpos + this.itemWidth), (double)(ypos - height));
                gl.glVertex2d((double)xpos, (double)(ypos - height));
            }
            finally {
                gl.glEnd();
            }
        }
    }

    public static enum LegendPlacement {
        N,
        NE,
        E,
        SE,
        S,
        SW,
        W,
        NW;

    }
}

