/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.painter.decoration;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.axis.painter.label.AxisLabelHandler;
import com.metsci.glimpse.axis.painter.label.AxisUnitConverter;
import com.metsci.glimpse.axis.painter.label.GridAxisLabelHandler;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.painter.base.GlimpsePainter2D;
import com.metsci.glimpse.support.color.GlimpseColor;
import javax.media.opengl.GL;

public class GridPainter
extends GlimpsePainter2D {
    protected float[] majorLineColor = new float[]{0.5f, 0.5f, 0.5f, 1.0f};
    protected int majorLineThickness = 1;
    protected float[] minorLineColor = new float[]{0.5f, 0.5f, 0.5f, 0.15f};
    protected int minorLineThickness = 1;
    protected boolean showHorizontal = true;
    protected boolean showVertical = true;
    protected boolean showMinorTicks = true;
    protected AxisLabelHandler ticksX;
    protected AxisLabelHandler ticksY;

    public GridPainter(AxisLabelHandler ticksX, AxisLabelHandler ticksY) {
        this.ticksX = ticksX;
        this.ticksY = ticksY;
    }

    public GridPainter() {
        this(new GridAxisLabelHandler(), new GridAxisLabelHandler());
    }

    public GridPainter setLineColor(float r, float g, float b, float a) {
        this.majorLineColor[0] = r;
        this.majorLineColor[1] = g;
        this.majorLineColor[2] = b;
        this.majorLineColor[3] = a;
        return this;
    }

    public GridPainter setLineColor(float[] rgba) {
        this.majorLineColor = rgba;
        return this;
    }

    public GridPainter setMinorLineColor(float[] rgba) {
        this.minorLineColor = rgba;
        return this;
    }

    public GridPainter setShowMinorGrid(boolean showMinorTicks) {
        this.showMinorTicks = showMinorTicks;
        return this;
    }

    public GridPainter setShowVerticalLines(boolean show) {
        this.showVertical = show;
        return this;
    }

    public GridPainter setShowHorizontalLines(boolean show) {
        this.showHorizontal = show;
        return this;
    }

    public GridPainter setTickHandlerX(AxisLabelHandler ticksX) {
        this.ticksX = ticksX;
        return this;
    }

    public GridPainter setTickHandlerY(AxisLabelHandler ticksY) {
        this.ticksY = ticksY;
        return this;
    }

    @Override
    public void paintTo(GlimpseContext context, GlimpseBounds bounds, Axis2D axis) {
        int i;
        int i2;
        int stipplePhase;
        int width = bounds.getWidth();
        int height = bounds.getHeight();
        if (this.ticksX == null || this.ticksY == null || axis == null || axis.getAxisX() == null || axis.getAxisY() == null || width <= 0 || height <= 0) {
            return;
        }
        GL gl = context.getGL();
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glOrtho(-0.5, (double)((float)(width - 1) + 0.5f), -0.5, (double)((float)(height - 1) + 0.5f), -1.0, 1.0);
        gl.glEnable(2852);
        gl.glBlendFunc(770, 771);
        gl.glEnable(3042);
        double[] xTicks = this.ticksX.getTickPositions(axis.getAxisX());
        AxisUnitConverter converterX = this.ticksX.getAxisUnitConverter();
        converterX = converterX == null ? new AxisUnitConverter(){

            @Override
            public double toAxisUnits(double value) {
                return value;
            }

            @Override
            public double fromAxisUnits(double value) {
                return value;
            }
        } : converterX;
        Axis1D axisX = axis.getAxisX();
        double[] yTicks = this.ticksY.getTickPositions(axis.getAxisY());
        AxisUnitConverter converterY = this.ticksY.getAxisUnitConverter();
        converterY = converterY == null ? new AxisUnitConverter(){

            @Override
            public double toAxisUnits(double value) {
                return value;
            }

            @Override
            public double fromAxisUnits(double value) {
                return value;
            }
        } : converterY;
        Axis1D axisY = axis.getAxisY();
        if (this.showVertical) {
            gl.glLineWidth((float)this.majorLineThickness);
            gl.glColor4fv(this.majorLineColor, 0);
            stipplePhase = (int)axisY.valueToScreenPixelUnits(converterY.fromAxisUnits(0.0)) % 4;
            stipplePhase = stipplePhase < 0 ? stipplePhase + 4 : stipplePhase;
            switch (stipplePhase) {
                case 3: {
                    gl.glLineStipple(1, (short)Integer.parseInt("1100110011001100", 2));
                    break;
                }
                case 2: {
                    gl.glLineStipple(1, (short)Integer.parseInt("0110011001100110", 2));
                    break;
                }
                case 1: {
                    gl.glLineStipple(1, (short)Integer.parseInt("0011001100110011", 2));
                    break;
                }
                case 0: {
                    gl.glLineStipple(1, (short)Integer.parseInt("1001100110011001", 2));
                    break;
                }
            }
            for (i2 = 0; i2 < xTicks.length; ++i2) {
                int iTick = axisX.valueToScreenPixel(converterX.fromAxisUnits(xTicks[i2]));
                if (iTick == width) {
                    --iTick;
                }
                if (iTick < 0) continue;
                if (iTick > width) break;
                gl.glBegin(1);
                gl.glVertex2f((float)iTick, 0.0f);
                gl.glVertex2f((float)iTick, (float)height);
                gl.glEnd();
            }
            if (this.showMinorTicks) {
                GlimpseColor.glColor(gl, this.majorLineColor, 0.1f);
                double[] xMinor = this.ticksX.getMinorTickPositions(xTicks);
                for (i = 0; i < xMinor.length; ++i) {
                    int iTick = axisX.valueToScreenPixel(converterX.fromAxisUnits(xMinor[i]));
                    gl.glBegin(1);
                    gl.glVertex2f((float)iTick, 0.0f);
                    gl.glVertex2f((float)iTick, (float)height);
                    gl.glEnd();
                }
            }
        }
        if (this.showHorizontal) {
            gl.glLineWidth((float)this.majorLineThickness);
            gl.glColor4fv(this.majorLineColor, 0);
            stipplePhase = (int)axisX.valueToScreenPixelUnits(converterX.fromAxisUnits(0.0)) % 4;
            stipplePhase = stipplePhase < 0 ? stipplePhase + 4 : stipplePhase;
            switch (stipplePhase) {
                case 3: {
                    gl.glLineStipple(1, (short)Integer.parseInt("1100110011001100", 2));
                    break;
                }
                case 2: {
                    gl.glLineStipple(1, (short)Integer.parseInt("0110011001100110", 2));
                    break;
                }
                case 1: {
                    gl.glLineStipple(1, (short)Integer.parseInt("0011001100110011", 2));
                    break;
                }
                case 0: {
                    gl.glLineStipple(1, (short)Integer.parseInt("1001100110011001", 2));
                    break;
                }
            }
            for (i2 = 0; i2 < yTicks.length; ++i2) {
                int jTick = axisY.valueToScreenPixel(converterY.fromAxisUnits(yTicks[i2]));
                if (jTick == height) {
                    --jTick;
                }
                if (jTick < 0) continue;
                if (jTick > height) break;
                gl.glBegin(1);
                gl.glVertex2f(0.0f, (float)jTick);
                gl.glVertex2f((float)width, (float)jTick);
                gl.glEnd();
            }
            if (this.showMinorTicks) {
                GlimpseColor.glColor(gl, this.majorLineColor, 0.1f);
                double[] yMinor = this.ticksY.getMinorTickPositions(yTicks);
                for (i = 0; i < yMinor.length; ++i) {
                    int jTick = axisY.valueToScreenPixel(converterY.fromAxisUnits(yMinor[i]));
                    gl.glBegin(1);
                    gl.glVertex2f(0.0f, (float)jTick);
                    gl.glVertex2f((float)width, (float)jTick);
                    gl.glEnd();
                }
            }
        }
    }
}

