/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.layout;

import com.metsci.glimpse.layout.GlimpseLayoutDelegate;
import com.metsci.glimpse.layout.GlimpseLayoutManager;
import com.metsci.glimpse.util.GeneralUtils;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.ComponentWrapper;
import net.miginfocom.layout.ConstraintParser;
import net.miginfocom.layout.ContainerWrapper;
import net.miginfocom.layout.Grid;
import net.miginfocom.layout.LC;
import net.miginfocom.layout.LayoutCallback;

public class GlimpseLayoutManagerMig
implements GlimpseLayoutManager {
    private LC lc = null;
    private AC cc = null;
    private AC rc = null;
    private ArrayList<LayoutCallback> callbackList = GeneralUtils.newArrayList();
    private int cacheHash = -1;
    private Grid gridCache = null;
    private Map<GlimpseLayoutDelegate, Object> childDataCache = new IdentityHashMap<GlimpseLayoutDelegate, Object>(8);
    private Map<ComponentWrapper, CC> childConstraintCache = GeneralUtils.newHashMap();

    public GlimpseLayoutManagerMig() {
        this("", "", "");
    }

    public GlimpseLayoutManagerMig(LC layoutConstraints, AC colConstraints, AC rowConstraints) {
        this.lc = layoutConstraints;
        this.cc = colConstraints;
        this.rc = rowConstraints;
    }

    public GlimpseLayoutManagerMig(String layoutConstraints, String colConstraints, String rowConstraints) {
        this.setLayoutConstraints(layoutConstraints);
        this.setColumnConstraints(colConstraints);
        this.setRowConstraints(rowConstraints);
    }

    public void setLayoutConstraints(String s) {
        this.lc = ConstraintParser.parseLayoutConstraint((String)ConstraintParser.prepare((String)s));
        this.gridCache = null;
    }

    public void setColumnConstraints(String s) {
        this.cc = ConstraintParser.parseColumnConstraints((String)ConstraintParser.prepare((String)s));
        this.gridCache = null;
    }

    public void setRowConstraints(String s) {
        this.rc = ConstraintParser.parseRowConstraints((String)ConstraintParser.prepare((String)s));
        this.gridCache = null;
    }

    private void setChildConstraint(GlimpseLayoutDelegate child, Object constraint, boolean noCheck) {
        if (!noCheck && !this.childDataCache.containsKey(child)) {
            throw new IllegalArgumentException("Component must already be added to parent!");
        }
        if (constraint == null || constraint instanceof String) {
            String ccString = ConstraintParser.prepare((String)((String)constraint));
            this.childDataCache.put(child, constraint);
            this.childConstraintCache.put(child, ConstraintParser.parseComponentConstraint((String)ccString));
        } else if (constraint instanceof CC) {
            this.childDataCache.put(child, constraint);
            this.childConstraintCache.put(child, (CC)constraint);
        } else {
            throw new IllegalArgumentException("Constraint must be String or ComponentConstraint: " + constraint.getClass().toString());
        }
        this.gridCache = null;
    }

    public void addLayoutCallback(LayoutCallback callback) {
        if (callback == null) {
            throw new NullPointerException();
        }
        this.callbackList.add(callback);
    }

    public void removeLayoutCallback(LayoutCallback callback) {
        if (this.callbackList != null) {
            this.callbackList.remove(callback);
        }
    }

    private void checkCache(GlimpseLayoutDelegate parent) {
        this.checkChildCache(parent);
        int hash = parent.getWidth() ^ parent.getHeight();
        Iterator<ComponentWrapper> it = this.childConstraintCache.keySet().iterator();
        while (it.hasNext()) {
            hash += it.next().getLayoutHashCode();
        }
        if (hash != this.cacheHash) {
            this.gridCache = null;
            this.cacheHash = hash;
        }
        if (this.gridCache == null) {
            this.gridCache = new Grid((ContainerWrapper)parent, this.lc, this.rc, this.cc, this.childConstraintCache, this.callbackList);
        }
    }

    private boolean checkChildCache(GlimpseLayoutDelegate parent) {
        GlimpseLayoutDelegate c;
        int i;
        boolean changed;
        ComponentWrapper[] comps = parent.getComponents();
        boolean bl = changed = comps.length != this.childDataCache.size();
        if (!changed) {
            for (i = 0; i < comps.length; ++i) {
                c = (GlimpseLayoutDelegate)comps[i];
                if (this.childDataCache.get(c) == null && c.getLayoutData() == null || this.childDataCache.get(c) == c.getLayoutData()) continue;
                changed = true;
                break;
            }
        }
        if (changed) {
            this.childDataCache.clear();
            for (i = 0; i < comps.length; ++i) {
                c = (GlimpseLayoutDelegate)comps[i];
                this.setChildConstraint(c, c.getLayoutData(), true);
            }
        }
        return changed;
    }

    @Override
    public void layout(GlimpseLayoutDelegate parent) {
        this.checkCache(parent);
        int[] b = new int[]{parent.getX(), parent.getY(), parent.getWidth(), parent.getHeight()};
        boolean layoutAgain = this.gridCache.layout(b, this.lc.getAlignX(), this.lc.getAlignY(), false, true);
        if (layoutAgain) {
            this.gridCache = null;
            this.checkCache(parent);
            this.gridCache.layout(b, this.lc.getAlignX(), this.lc.getAlignY(), false, false);
        }
    }
}

