/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.layout;

import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.context.GlimpseTarget;
import com.metsci.glimpse.context.GlimpseTargetStack;
import com.metsci.glimpse.event.mouse.GlimpseMouseAllListener;
import com.metsci.glimpse.event.mouse.GlimpseMouseEvent;
import com.metsci.glimpse.event.mouse.GlimpseMouseListener;
import com.metsci.glimpse.event.mouse.GlimpseMouseMotionListener;
import com.metsci.glimpse.event.mouse.GlimpseMouseWheelListener;
import com.metsci.glimpse.event.mouse.Mouseable;
import com.metsci.glimpse.layout.GlimpseLayoutCache;
import com.metsci.glimpse.layout.GlimpseLayoutDelegate;
import com.metsci.glimpse.layout.GlimpseLayoutManager;
import com.metsci.glimpse.painter.base.GlimpsePainter;
import com.metsci.glimpse.painter.base.GlimpsePainterCallback;
import com.metsci.glimpse.support.settings.LookAndFeel;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

public class GlimpseLayout
implements GlimpsePainter,
GlimpseTarget,
Mouseable {
    protected String name = "";
    protected GlimpseLayoutCache<GlimpseBounds> layoutCache;
    protected GlimpseLayoutDelegate layoutDelegate;
    protected List<GlimpseTarget> layoutChildren;
    protected List<GlimpseTarget> unmodifiableLayoutChildren;
    protected ReentrantLock lock = new ReentrantLock();
    protected Set<GlimpseMouseListener> mouseListeners;
    protected Set<GlimpseMouseMotionListener> mouseMotionListeners;
    protected Set<GlimpseMouseWheelListener> mouseWheelListeners;
    protected Collection<GlimpseMouseListener> mouseListenersUnmodifiable;
    protected Collection<GlimpseMouseMotionListener> mouseMotionListenersUnmodifiable;
    protected Collection<GlimpseMouseWheelListener> mouseWheelListenersUnmodifiable;
    protected boolean isEventGenerator = true;
    protected boolean isEventConsumer = true;
    protected boolean isVisible = true;

    public GlimpseLayout(GlimpseLayout parent, String name) {
        this.layoutCache = new GlimpseLayoutCache();
        this.layoutDelegate = new GlimpseLayoutDelegate(this);
        this.layoutChildren = new LinkedList<GlimpseTarget>();
        this.unmodifiableLayoutChildren = Collections.unmodifiableList(this.layoutChildren);
        this.lock = new ReentrantLock();
        this.mouseListeners = new HashSet<GlimpseMouseListener>();
        this.mouseMotionListeners = new HashSet<GlimpseMouseMotionListener>();
        this.mouseWheelListeners = new HashSet<GlimpseMouseWheelListener>();
        this.mouseListenersUnmodifiable = Collections.unmodifiableCollection(this.mouseListeners);
        this.mouseMotionListenersUnmodifiable = Collections.unmodifiableCollection(this.mouseMotionListeners);
        this.mouseWheelListenersUnmodifiable = Collections.unmodifiableCollection(this.mouseWheelListeners);
        this.name = name;
        if (parent != null) {
            parent.addLayout(this);
        }
    }

    public GlimpseLayout(GlimpseLayout parent) {
        this(parent, null);
    }

    public GlimpseLayout(String name) {
        this(null, name);
    }

    public GlimpseLayout() {
        this(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        this.lock.lock();
        try {
            String string = this.name;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String name) {
        this.lock.lock();
        try {
            this.name = name;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLayoutManager(GlimpseLayoutManager manager) {
        this.lock.lock();
        try {
            this.layoutDelegate.setLayoutManager(manager);
            this.invalidateLayout();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLayoutData(Object layoutData) {
        this.lock.lock();
        try {
            this.layoutDelegate.setLayoutData(layoutData);
            this.invalidateLayout();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLayout(GlimpseLayout layout) {
        this.lock.lock();
        try {
            this.layoutChildren.remove(layout);
            this.layoutDelegate.removeLayout(layout);
            this.invalidateLayout();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayout(GlimpseLayout layout) {
        this.lock.lock();
        try {
            this.layoutChildren.add(layout);
            this.layoutDelegate.addLayout(layout);
            this.invalidateLayout();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLayout(GlimpseLayout layout, GlimpsePainterCallback callback) {
        this.lock.lock();
        try {
            this.layoutChildren.add(layout);
            this.layoutDelegate.addLayout(layout, callback);
            this.invalidateLayout();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPainter(GlimpsePainter painter) {
        this.lock.lock();
        try {
            this.layoutDelegate.addPainter(painter);
            this.invalidateLayout();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPainter(GlimpsePainter painter, GlimpsePainterCallback callback) {
        this.lock.lock();
        try {
            this.layoutDelegate.addPainter(painter, callback);
            this.invalidateLayout();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePainter(GlimpsePainter painter) {
        this.lock.lock();
        try {
            this.layoutDelegate.removePainter(painter);
            this.invalidateLayout();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateLayout() {
        this.lock.lock();
        try {
            this.layoutCache.clear();
            this.layoutDelegate.invalidateLayout();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlimpseBounds layoutTo(GlimpseTargetStack stack) {
        this.lock.lock();
        try {
            GlimpseBounds bounds = this.layoutCache.getValue(stack);
            if (bounds == null) {
                bounds = stack.getBounds();
                this.layoutCache.setValue(stack, bounds);
                this.layoutDelegate.layoutTo(stack, bounds);
            }
            GlimpseBounds glimpseBounds = bounds;
            return glimpseBounds;
        }
        finally {
            this.lock.unlock();
        }
    }

    public GlimpseBounds layoutTo(GlimpseContext context) {
        return this.layoutTo(context.getTargetStack());
    }

    @Override
    public void paintTo(GlimpseContext context) {
        GlimpseBounds bounds = this.layoutTo(context);
        if (!this.isVisible) {
            return;
        }
        context.getTargetStack().push(this, bounds);
        this.layoutDelegate.paintTo(context);
        context.getTargetStack().pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GlimpseBounds getTargetBounds(GlimpseTargetStack stack) {
        this.lock.lock();
        try {
            GlimpseBounds bounds = this.layoutCache.getValue(stack);
            if (bounds == null) {
                GlimpseBounds glimpseBounds = this.layoutTo(stack);
                return glimpseBounds;
            }
            GlimpseBounds glimpseBounds = bounds;
            return glimpseBounds;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public List<GlimpseTarget> getTargetChildren() {
        return this.unmodifiableLayoutChildren;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose(GlimpseContext context) {
        this.lock.lock();
        try {
            this.layoutDelegate.dispose(context);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDisposed() {
        this.lock.lock();
        try {
            boolean bl = this.layoutDelegate.isDisposed();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return this.name == null ? super.toString() : this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<GlimpseMouseListener> getGlimpseMouseListeners() {
        this.lock.lock();
        try {
            Collection<GlimpseMouseListener> collection = this.mouseListenersUnmodifiable;
            return collection;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<GlimpseMouseMotionListener> getGlimpseMouseMotionListeners() {
        this.lock.lock();
        try {
            Collection<GlimpseMouseMotionListener> collection = this.mouseMotionListenersUnmodifiable;
            return collection;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<GlimpseMouseWheelListener> getGlimpseMouseWheelListeners() {
        this.lock.lock();
        try {
            Collection<GlimpseMouseWheelListener> collection = this.mouseWheelListenersUnmodifiable;
            return collection;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addGlimpseMouseListener(GlimpseMouseListener listener) {
        this.lock.lock();
        try {
            this.mouseListeners.add(listener);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addGlimpseMouseMotionListener(GlimpseMouseMotionListener listener) {
        this.lock.lock();
        try {
            this.mouseMotionListeners.add(listener);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addGlimpseMouseWheelListener(GlimpseMouseWheelListener listener) {
        this.lock.lock();
        try {
            this.mouseWheelListeners.add(listener);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void addGlimpseMouseAllListener(GlimpseMouseAllListener listener) {
        this.addGlimpseMouseListener(listener);
        this.addGlimpseMouseMotionListener(listener);
        this.addGlimpseMouseWheelListener(listener);
    }

    @Override
    public void removeGlimpseMouseAllListener(GlimpseMouseAllListener listener) {
        this.removeGlimpseMouseListener(listener);
        this.removeGlimpseMouseMotionListener(listener);
        this.removeGlimpseMouseWheelListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeGlimpseMouseListener(GlimpseMouseListener listener) {
        this.lock.lock();
        try {
            this.mouseListeners.remove(listener);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeGlimpseMouseMotionListener(GlimpseMouseMotionListener listener) {
        this.lock.lock();
        try {
            this.mouseMotionListeners.remove(listener);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeGlimpseMouseWheelListener(GlimpseMouseWheelListener listener) {
        this.lock.lock();
        try {
            this.mouseWheelListeners.remove(listener);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllGlimpseListeners() {
        this.lock.lock();
        try {
            this.mouseListeners.clear();
            this.mouseWheelListeners.clear();
            this.mouseMotionListeners.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void cacheBounds(GlimpseContext context, GlimpseBounds bounds) {
        this.layoutCache.setValue(context, bounds);
    }

    protected void cacheBounds(GlimpseTargetStack stack, GlimpseBounds bounds) {
        this.layoutCache.setValue(stack, bounds);
    }

    protected GlimpseBounds getBounds(GlimpseContext context) {
        return this.layoutCache.getValue(context);
    }

    protected void preLayout(GlimpseTargetStack stack, GlimpseBounds bounds) {
    }

    protected void preLayout(GlimpseContext context, GlimpseBounds bounds) {
        this.preLayout(context.getTargetStack(), bounds);
    }

    public GlimpseLayoutManager getLayoutManager() {
        return this.getDelegate().getLayoutManager();
    }

    protected GlimpseLayoutDelegate getDelegate() {
        return this.layoutDelegate;
    }

    @Override
    public void mouseEntered(GlimpseMouseEvent event) {
        for (GlimpseMouseListener listener : this.mouseListeners) {
            listener.mouseEntered(event);
        }
    }

    @Override
    public void mouseExited(GlimpseMouseEvent event) {
        for (GlimpseMouseListener listener : this.mouseListeners) {
            listener.mouseExited(event);
        }
    }

    @Override
    public void mousePressed(GlimpseMouseEvent event) {
        for (GlimpseMouseListener listener : this.mouseListeners) {
            listener.mousePressed(event);
        }
    }

    @Override
    public void mouseReleased(GlimpseMouseEvent event) {
        for (GlimpseMouseListener listener : this.mouseListeners) {
            listener.mouseReleased(event);
        }
    }

    @Override
    public void mouseMoved(GlimpseMouseEvent e) {
        for (GlimpseMouseMotionListener listener : this.mouseMotionListeners) {
            listener.mouseMoved(e);
        }
    }

    @Override
    public void mouseWheelMoved(GlimpseMouseEvent e) {
        for (GlimpseMouseWheelListener listener : this.mouseWheelListeners) {
            listener.mouseWheelMoved(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLookAndFeel(LookAndFeel laf) {
        this.lock.lock();
        try {
            for (GlimpseTarget layout : this.layoutChildren) {
                layout.setLookAndFeel(laf);
            }
            this.layoutDelegate.setLookAndFeel(laf);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isEventConsumer() {
        return this.isEventConsumer;
    }

    @Override
    public void setEventConsumer(boolean consume) {
        this.isEventConsumer = consume;
    }

    @Override
    public boolean isEventGenerator() {
        return this.isEventGenerator;
    }

    @Override
    public void setEventGenerator(boolean generate) {
        this.isEventGenerator = generate;
    }

    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    public boolean isVisible() {
        return this.isVisible;
    }
}

