/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.gl.util;

import javax.media.opengl.GL;

public class GLUtils {
    private GLUtils() {
    }

    public static int genBuffer(GL gl) {
        int[] handle = new int[1];
        gl.glGenBuffers(1, handle, 0);
        return handle[0];
    }

    public static int genTexture(GL gl) {
        int[] handle = new int[1];
        gl.glGenTextures(1, handle, 0);
        return handle[0];
    }

    public static int queryGLInteger(int param, GL gl) {
        int[] value = new int[1];
        gl.glGetIntegerv(param, value, 0);
        return value[0];
    }

    public static boolean queryGLBoolean(int param, GL gl) {
        byte[] value = new byte[1];
        gl.glGetBooleanv(param, value, 0);
        return value[0] != 0;
    }

    public static int getGLTextureDim(int ndim) {
        switch (ndim) {
            case 1: {
                return 3552;
            }
            case 2: {
                return 3553;
            }
            case 3: {
                return 32879;
            }
        }
        throw new IllegalArgumentException("Only 1D, 2D, and 3D textures allowed.");
    }

    public static int getGLTextureUnit(int texUnit) {
        if (texUnit > 31 || texUnit < 0) {
            throw new IllegalArgumentException("Only 31 texture units supported.");
        }
        return 33984 + texUnit;
    }
}

