/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.gl.texture;

import com.metsci.glimpse.gl.texture.AbstractTexture;
import com.metsci.glimpse.gl.texture.DrawableTexture;
import com.sun.opengl.util.BufferUtil;
import java.nio.FloatBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.opengl.GL;

public class FloatTexture2D
extends AbstractTexture
implements DrawableTexture {
    private static final Logger logger = Logger.getLogger(FloatTexture2D.class.getName());
    protected FloatBuffer data;
    protected boolean centers;
    protected double[] min;
    protected double[] max;

    public FloatTexture2D(double[] min, double[] max, int n0, int n1, boolean centers) {
        super(n0, n1);
        this.data = BufferUtil.newFloatBuffer((int)(n0 * n1));
        this.min = (double[])min.clone();
        this.max = (double[])max.clone();
        this.centers = centers;
    }

    @Override
    public void draw(GL gl, int texUnit) {
        boolean ready = this.prepare(gl, texUnit);
        if (!ready) {
            logger.log(Level.WARNING, "Unable to make ready.");
            return;
        }
        gl.glTexEnvf(8960, 8704, 7681.0f);
        gl.glPolygonMode(1028, 6914);
        double[][] tminmax = this.computeDrawMinMax();
        double[] tmin = tminmax[0];
        double[] tmax = tminmax[1];
        gl.glBegin(7);
        gl.glTexCoord2f(0.0f, 0.0f);
        gl.glVertex2d(tmin[0], tmin[1]);
        gl.glTexCoord2f(1.0f, 0.0f);
        gl.glVertex2d(tmax[0], tmin[1]);
        gl.glTexCoord2f(1.0f, 1.0f);
        gl.glVertex2d(tmax[0], tmax[1]);
        gl.glTexCoord2f(0.0f, 1.0f);
        gl.glVertex2d(tmin[0], tmax[1]);
        gl.glEnd();
    }

    private final double[][] computeDrawMinMax() {
        double[] texmin = new double[2];
        double[] texmax = new double[2];
        double d0 = (this.max[0] - this.min[0]) / (double)this.dim[0];
        double d1 = (this.max[1] - this.min[1]) / (double)this.dim[1];
        if (!this.centers) {
            texmin[0] = this.min[0];
            texmin[1] = this.min[1];
            texmax[0] = this.max[0];
            texmax[1] = this.max[0];
        } else {
            texmin[0] = this.min[0] - d0 / 2.0;
            texmin[1] = this.min[1] - d1 / 2.0;
            texmax[0] = this.max[0] + d0 / 2.0;
            texmax[1] = this.max[0] + d1 / 2.0;
        }
        return new double[][]{texmin, texmax};
    }

    @Override
    protected void prepare_setTexParameters(GL gl) {
        gl.glTexParameteri(3553, 10240, 9728);
        gl.glTexParameteri(3553, 10241, 9728);
        gl.glTexParameteri(3553, 10242, 10496);
        gl.glTexParameteri(3553, 10243, 10496);
    }

    @Override
    protected void prepare_setData(GL gl) {
        gl.glTexImage2D(3553, 0, 34840, this.dim[0], this.dim[1], 0, 6409, 5126, this.data.rewind());
    }

    @Override
    protected void prepare_setPixelStore(GL gl) {
        gl.glPixelStorei(3317, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mutate(MutatorFloat2D mutator) {
        this.lock.lock();
        try {
            this.data.rewind();
            mutator.mutate(this.data, this.min, this.max, (int[])this.dim.clone());
            this.makeDirty();
        }
        finally {
            this.lock.unlock();
        }
    }

    public static interface MutatorFloat2D {
        public void mutate(FloatBuffer var1, double[] var2, double[] var3, int[] var4);
    }
}

