/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.gl.attribute;

import com.metsci.glimpse.gl.attribute.GLFloatBuffer;
import com.metsci.glimpse.util.primitives.IntsModifiable;
import com.metsci.glimpse.util.quadtree.FilterInt;
import com.metsci.glimpse.util.quadtree.QuadTreeInts;
import java.nio.FloatBuffer;

public class GLFloatBuffer2D
extends GLFloatBuffer {
    protected static final int MAX_BUCKET_SIZE = 500;
    protected QuadTreeInts xyIndex;
    protected boolean indexEnabled;

    public GLFloatBuffer2D(int length, boolean indexEnabled) {
        super(length, 2);
        this.indexEnabled = indexEnabled;
    }

    public GLFloatBuffer2D(int length) {
        this(length, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pruneIndex(int updateIndex) {
        this.lock.lock();
        try {
            if (!this.indexEnabled) {
                this.xyIndex = null;
                return;
            }
            if (this.xyIndex == null || updateIndex > this.getNumVertices()) {
                this.xyIndex = null;
            } else {
                for (int i = updateIndex; i < this.getNumVertices(); ++i) {
                    this.xyIndex.remove(i);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateIndex(int updateIndex) {
        this.lock.lock();
        try {
            if (!this.indexEnabled) {
                this.xyIndex = null;
                return;
            }
            if (this.xyIndex == null) {
                final FloatBuffer floatData = this.data.asFloatBuffer();
                this.xyIndex = new QuadTreeInts(500){

                    protected final float x(int i) {
                        return floatData.get(i * 2);
                    }

                    protected final float y(int i) {
                        return floatData.get(i * 2 + 1);
                    }
                };
                for (int i = 0; i < this.getNumVertices(); ++i) {
                    this.xyIndex.add(i);
                }
            } else {
                for (int i = updateIndex; i < this.getNumVertices(); ++i) {
                    this.xyIndex.add(i);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createIndex() {
        this.lock.lock();
        try {
            if (!this.indexEnabled) {
                this.xyIndex = null;
                return;
            }
            final FloatBuffer floatData = this.data.asFloatBuffer();
            this.xyIndex = new QuadTreeInts(500){

                protected final float x(int i) {
                    return floatData.get(i * 2);
                }

                protected final float y(int i) {
                    return floatData.get(i * 2 + 1);
                }
            };
            for (int i = 0; i < this.getNumVertices(); ++i) {
                this.xyIndex.add(i);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isIndexEnabled() {
        return this.indexEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIndexEnabled(boolean enabled) {
        this.lock.lock();
        try {
            if (enabled == this.indexEnabled) {
                return;
            }
            this.indexEnabled = enabled;
            this.createIndex();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int search(float xMin, float xMax, float yMin, float yMax, IntsModifiable result) {
        this.lock.lock();
        try {
            if (this.xyIndex == null) {
                int n = 0;
                return n;
            }
            int n = this.xyIndex.search(xMin, xMax, yMin, yMax, result);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int search(float xMin, float xMax, float yMin, float yMax, FilterInt filter, IntsModifiable result) {
        this.lock.lock();
        try {
            if (this.xyIndex == null) {
                int n = 0;
                return n;
            }
            int n = this.xyIndex.search(xMin, xMax, yMin, yMax, filter, result);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mutateIndexed(IndexedMutator mutator) {
        this.lock.lock();
        try {
            this.pruneIndex(mutator.getUpdateIndex());
            this.data.clear();
            FloatBuffer floatData = this.data.asFloatBuffer();
            mutator.mutate(floatData, this.elementSize);
            this.updateIndex(mutator.getUpdateIndex());
            this.data.position(0);
            this.data.limit(floatData.limit() * this.getBytesPerElement());
            this.makeDirty();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mutate(GLFloatBuffer.Mutator mutator) {
        this.lock.lock();
        try {
            this.data.clear();
            FloatBuffer floatData = this.data.asFloatBuffer();
            mutator.mutate(floatData, this.elementSize);
            this.data.position(0);
            this.data.limit(floatData.limit() * this.getBytesPerElement());
            this.createIndex();
            this.makeDirty();
        }
        finally {
            this.lock.unlock();
        }
    }

    public static interface IndexedMutator
    extends GLFloatBuffer.Mutator {
        public int getUpdateIndex();

        @Override
        public void mutate(FloatBuffer var1, int var2);
    }
}

