/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.gl;

import com.metsci.glimpse.gl.GLRunnable;
import com.metsci.glimpse.gl.GLSimpleFboListenerEntry;
import com.metsci.glimpse.gl.GLSimpleListener;
import com.metsci.glimpse.gl.texture.DrawableTexture;
import com.metsci.glimpse.gl.util.GLUtils;
import com.metsci.glimpse.util.logging.LoggerUtils;
import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureIO;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;

public class GLSimpleFrameBufferObject {
    private static final Logger logger = Logger.getLogger(GLSimpleFrameBufferObject.class.getName());
    private GLContext context;
    private boolean initialized;
    private int width;
    private int height;
    private int[] textureId;
    private int[] renderBufferId;
    private int[] frameBufferId;
    private List<GLSimpleFboListenerEntry> listeners;
    private ReentrantLock lock;

    public GLSimpleFrameBufferObject(int width, int height, GLContext context) {
        this.context = context;
        this.width = width;
        this.height = height;
        this.listeners = new CopyOnWriteArrayList<GLSimpleFboListenerEntry>();
        this.lock = new ReentrantLock();
    }

    public void resize(int width, int height) {
        this.initialized = false;
        this.width = width;
        this.height = height;
    }

    public Object glSyncExec(final GLRunnable runnable) {
        this.context.makeCurrent();
        Object result = new GLRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run(GLContext context) {
                GLSimpleFrameBufferObject.this.lock.lock();
                try {
                    Object object;
                    GLSimpleFrameBufferObject.this.bind(context);
                    try {
                        object = runnable.run(context);
                    }
                    catch (Throwable throwable) {
                        context.getGL().glFlush();
                        GLSimpleFrameBufferObject.this.unbind(context);
                        throw throwable;
                    }
                    context.getGL().glFlush();
                    GLSimpleFrameBufferObject.this.unbind(context);
                    return object;
                }
                finally {
                    GLSimpleFrameBufferObject.this.lock.unlock();
                }
            }
        }.run(this.context);
        this.context.release();
        return result;
    }

    public void draw() {
        final Rectangle bounds = this.getBounds();
        final ArrayList<GLSimpleFboListenerEntry> entries = new ArrayList<GLSimpleFboListenerEntry>(this.listeners);
        this.glSyncExec(new GLRunnable(){

            @Override
            public Object run(GLContext context) {
                for (GLSimpleFboListenerEntry l : entries) {
                    l.draw(context, bounds);
                }
                return null;
            }
        });
    }

    public void bind(GLContext context) {
        GL gl = context.getGL();
        if (!this.initialized) {
            if (this.textureId != null) {
                gl.glDeleteTextures(1, this.textureId, 0);
            }
            this.textureId = new int[1];
            gl.glGenTextures(1, this.textureId, 0);
            gl.glBindTexture(3553, this.textureId[0]);
            gl.glTexParameterf(3553, 10240, 9729.0f);
            gl.glTexParameterf(3553, 10241, 9987.0f);
            gl.glTexParameterf(3553, 10242, 33071.0f);
            gl.glTexParameterf(3553, 10243, 33071.0f);
            gl.glTexParameteri(3553, 33169, 1);
            gl.glTexImage2D(3553, 0, 6408, this.width, this.height, 0, 6408, 5126, null);
            gl.glBindTexture(3553, 0);
            if (this.renderBufferId != null) {
                gl.glDeleteRenderbuffersEXT(2, this.renderBufferId, 0);
            }
            this.renderBufferId = new int[2];
            gl.glGenRenderbuffersEXT(2, this.renderBufferId, 0);
            gl.glBindRenderbufferEXT(36161, this.renderBufferId[0]);
            gl.glRenderbufferStorageEXT(36161, 6402, this.width, this.height);
            gl.glBindRenderbufferEXT(36161, 0);
            if (this.frameBufferId != null) {
                gl.glDeleteFramebuffersEXT(1, this.frameBufferId, 0);
            }
            this.frameBufferId = new int[1];
            gl.glGenFramebuffersEXT(1, this.frameBufferId, 0);
            gl.glBindFramebufferEXT(36160, this.frameBufferId[0]);
            gl.glFramebufferTexture2DEXT(36160, 36064, 3553, this.textureId[0], 0);
            gl.glFramebufferRenderbufferEXT(36160, 36096, 36161, this.renderBufferId[0]);
            int status = gl.glCheckFramebufferStatusEXT(36160);
            if (status != 36053) {
                LoggerUtils.logWarning((Logger)logger, (String)"Framebuffer not initialized (status=%d)", (Object[])new Object[]{status});
            }
            this.initialized = true;
        } else {
            gl.glBindFramebufferEXT(36160, this.frameBufferId[0]);
        }
    }

    public void unbind(GLContext context) {
        GL gl = context.getGL();
        gl.glBindFramebufferEXT(36160, 0);
        gl.glBindTexture(3553, this.textureId[0]);
        gl.glGenerateMipmapEXT(3553);
        gl.glBindTexture(3553, 0);
    }

    public void addListener(GLSimpleListener listener) {
        this.listeners.add(new GLSimpleFboListenerEntry(listener));
    }

    public Dimension getDimension() {
        return new Dimension(this.width, this.height);
    }

    public Rectangle getBounds() {
        return new Rectangle(0, 0, this.width, this.height);
    }

    public GLContext getGLContext() {
        return this.context;
    }

    public Texture getOpenGLTexture() {
        return TextureIO.newTexture((int)this.textureId[0]);
    }

    public DrawableTexture getGlimpseTexture() {
        return new DrawableTexture(){

            @Override
            public void makeDirty() {
            }

            @Override
            public boolean isDirty() {
                return true;
            }

            @Override
            public boolean prepare(GL gl, int texUnit) {
                return GLSimpleFrameBufferObject.this.textureId != null;
            }

            @Override
            public int getNumDimension() {
                return 2;
            }

            @Override
            public int getDimensionSize(int n) {
                switch (n) {
                    case 0: {
                        return GLSimpleFrameBufferObject.this.width;
                    }
                    case 1: {
                        return GLSimpleFrameBufferObject.this.height;
                    }
                }
                return 0;
            }

            @Override
            public boolean isResident(GL gl) {
                byte[] resident = new byte[1];
                gl.glAreTexturesResident(1, GLSimpleFrameBufferObject.this.textureId, 0, resident, 0);
                return resident[0] > 0;
            }

            @Override
            public void dispose(GLContext context) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void draw(GL gl, int texUnit) {
                boolean ready = this.prepare(gl, texUnit);
                if (!ready) {
                    logger.log(Level.WARNING, "Unable to make ready.");
                    return;
                }
                GLSimpleFrameBufferObject.this.lock.lock();
                try {
                    gl.glTexEnvf(8960, 8704, 7681.0f);
                    gl.glPolygonMode(1032, 6914);
                    gl.glEnable(3553);
                    gl.glActiveTexture(GLUtils.getGLTextureUnit(0));
                    gl.glBindTexture(GLUtils.getGLTextureDim(2), GLSimpleFrameBufferObject.this.textureId[0]);
                    gl.glBegin(7);
                    try {
                        gl.glTexCoord2f(0.0f, 0.0f);
                        gl.glVertex2f(0.0f, 0.0f);
                        gl.glTexCoord2f(0.0f, 1.0f);
                        gl.glVertex2f(0.0f, 10.0f);
                        gl.glTexCoord2f(1.0f, 1.0f);
                        gl.glVertex2f(10.0f, 10.0f);
                        gl.glTexCoord2f(1.0f, 0.0f);
                        gl.glVertex2f(10.0f, 0.0f);
                    }
                    finally {
                        gl.glDisable(3553);
                        gl.glEnd();
                    }
                }
                finally {
                    GLSimpleFrameBufferObject.this.lock.unlock();
                }
            }
        };
    }

    public void dispose(GLContext context) {
        GL gl = context.getGL();
        for (GLSimpleFboListenerEntry entry : this.listeners) {
            entry.dispose(context);
        }
        if (this.textureId != null) {
            gl.glDeleteTextures(1, this.textureId, 0);
        }
        if (this.renderBufferId != null) {
            gl.glDeleteRenderbuffersEXT(2, this.renderBufferId, 0);
        }
        if (this.frameBufferId != null) {
            gl.glDeleteFramebuffersEXT(1, this.frameBufferId, 0);
        }
    }
}

