/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.context;

import com.metsci.glimpse.canvas.GlimpseCanvas;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseTarget;
import com.metsci.glimpse.context.GlimpseTargetStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class GlimpseTargetStackImpl
implements GlimpseTargetStack {
    private LinkedList<GlimpseTarget> targetStack = new LinkedList();
    private LinkedList<GlimpseBounds> boundStack = new LinkedList();

    public GlimpseTargetStackImpl(GlimpseTarget ... targets) {
        for (GlimpseTarget target : targets) {
            this.push(target);
        }
    }

    public GlimpseTargetStackImpl(GlimpseCanvas canvas) {
        this.push(canvas, canvas.getTargetBounds());
    }

    @Override
    public GlimpseTargetStack push(GlimpseTarget target, GlimpseBounds bounds) {
        this.targetStack.push(target);
        this.boundStack.push(bounds);
        return this;
    }

    @Override
    public GlimpseTargetStack push(GlimpseTarget target) {
        GlimpseBounds bounds = target.getTargetBounds(this);
        if (bounds == null) {
            bounds = new GlimpseBounds(0, 0, 0, 0);
        }
        this.targetStack.push(target);
        this.boundStack.push(bounds);
        return this;
    }

    @Override
    public GlimpseTargetStack push(GlimpseTargetStack stack) {
        List<GlimpseTarget> targetList = stack.getTargetList();
        List<GlimpseBounds> boundsList = stack.getBoundsList();
        for (int i = targetList.size() - 1; i >= 0; --i) {
            this.push(targetList.get(i), boundsList.get(i));
        }
        return this;
    }

    @Override
    public GlimpseTargetStack pop() {
        this.targetStack.pop();
        this.boundStack.pop();
        return this;
    }

    @Override
    public GlimpseTarget getTarget() {
        return this.targetStack.peek();
    }

    @Override
    public GlimpseBounds getBounds() {
        return this.boundStack.peek();
    }

    @Override
    public List<GlimpseTarget> getTargetList() {
        ArrayList<GlimpseTarget> copy = new ArrayList<GlimpseTarget>(this.targetStack.size());
        copy.addAll(this.targetStack);
        return Collections.unmodifiableList(copy);
    }

    @Override
    public List<GlimpseBounds> getBoundsList() {
        ArrayList<GlimpseBounds> copy = new ArrayList<GlimpseBounds>(this.boundStack.size());
        copy.addAll(this.boundStack);
        return Collections.unmodifiableList(copy);
    }

    @Override
    public int getSize() {
        return this.targetStack.size();
    }

    public int hashCode() {
        return this.targetStack.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GlimpseTargetStackImpl other = (GlimpseTargetStackImpl)obj;
        return !(this.targetStack == null ? other.targetStack != null : !this.targetStack.equals(other.targetStack));
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        int size = this.getSize();
        b.append("[");
        for (int i = 0; i < size; ++i) {
            b.append(String.format("[%s,%s]", this.targetStack.get(i), this.boundStack.get(i)));
            if (i >= size - 1) continue;
            b.append(",");
        }
        b.append("]");
        return b.toString();
    }
}

