/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.context;

import com.metsci.glimpse.canvas.GlimpseCanvas;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.context.GlimpseTargetStack;
import com.metsci.glimpse.context.GlimpseTargetStackImpl;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;

public class GlimpseContextImpl
implements GlimpseContext {
    private static final String defaultDpiKey = "com.metsci.glimpse.dpi.default";
    private static final int defaultDpiValue = Integer.parseInt(System.getProperty("com.metsci.glimpse.dpi.default", "96"));
    private GLContext glContext;
    private GlimpseTargetStack targetStack;
    private int dpi;

    public GlimpseContextImpl(GlimpseCanvas canvas) {
        this.glContext = canvas.getGLContext();
        this.targetStack = new GlimpseTargetStackImpl(canvas);
        this.dpi = defaultDpiValue;
    }

    @Override
    public GLContext getGLContext() {
        return this.glContext;
    }

    @Override
    public GL getGL() {
        return this.glContext.getGL();
    }

    @Override
    public GlimpseTargetStack getTargetStack() {
        return this.targetStack;
    }

    @Override
    public int getDPI() {
        return this.dpi;
    }

    public String toString() {
        return String.format("[stack: %s dpi: %d]", this.targetStack, this.dpi);
    }
}

