/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.axis.tagged.shader;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.listener.AxisListener1D;
import com.metsci.glimpse.axis.tagged.Tag;
import com.metsci.glimpse.axis.tagged.TaggedAxis1D;
import com.metsci.glimpse.gl.shader.ShaderSource;
import com.metsci.glimpse.support.shader.SimplePointShader;
import java.io.IOException;
import java.util.List;

public class TaggedPointShader
extends SimplePointShader {
    protected TaggedAxis1D taggedColorAxis;
    protected TaggedAxis1D taggedSizeAxis;

    public TaggedPointShader(int colorTextureUnit, int sizeTextureUnit, int colorAttributeIndex, int sizeAttributeIndex, TaggedAxis1D colorAxis, TaggedAxis1D sizeAxis) throws IOException {
        super(colorTextureUnit, sizeTextureUnit, colorAttributeIndex, sizeAttributeIndex, colorAxis, sizeAxis);
    }

    protected TaggedPointShader(int colorTextureUnit, int sizeTextureUnit, int colorAttributeIndex, int sizeAttributeIndex, TaggedAxis1D colorAxis, TaggedAxis1D sizeAxis, ShaderSource ... source) throws IOException {
        super(colorTextureUnit, sizeTextureUnit, colorAttributeIndex, sizeAttributeIndex, colorAxis, sizeAxis, source);
    }

    @Override
    protected void initializeShaderValues(int colorTextureUnit, int sizeTextureUnit, int colorAttributeIndex, int sizeAttributeIndex, Axis1D colorAxis, Axis1D sizeAxis) {
        this.taggedColorAxis = (TaggedAxis1D)colorAxis;
        this.taggedSizeAxis = (TaggedAxis1D)sizeAxis;
        this.colorAttributeIndex = colorAttributeIndex;
        this.sizeAttributeIndex = sizeAttributeIndex;
        this.colorTexUnit.setValue(colorTextureUnit);
        this.colorMin.setValue(this.getMinTag(this.taggedColorAxis));
        this.colorMax.setValue(this.getMaxTag(this.taggedColorAxis));
        colorAxis.addAxisListener(new AxisListener1D(){

            @Override
            public void axisUpdated(Axis1D handler) {
                TaggedPointShader.this.colorMin.setValue(TaggedPointShader.this.getMinTag(TaggedPointShader.this.taggedColorAxis));
                TaggedPointShader.this.colorMax.setValue(TaggedPointShader.this.getMaxTag(TaggedPointShader.this.taggedColorAxis));
            }
        });
        this.sizeTexUnit.setValue(sizeTextureUnit);
        this.sizeMin.setValue(this.getMinTag(this.taggedSizeAxis));
        this.sizeMax.setValue(this.getMaxTag(this.taggedSizeAxis));
        sizeAxis.addAxisListener(new AxisListener1D(){

            @Override
            public void axisUpdated(Axis1D handler) {
                TaggedPointShader.this.sizeMin.setValue(TaggedPointShader.this.getMinTag(TaggedPointShader.this.taggedSizeAxis));
                TaggedPointShader.this.sizeMax.setValue(TaggedPointShader.this.getMaxTag(TaggedPointShader.this.taggedSizeAxis));
            }
        });
        this.discardAboveColor.setValue(false);
        this.discardBelowColor.setValue(false);
        this.discardAboveSize.setValue(false);
        this.discardBelowSize.setValue(false);
        this.constantColor.setValue(true);
        this.constantSize.setValue(true);
    }

    protected double getMinTag(TaggedAxis1D axis) {
        List<Tag> tags = axis.getSortedTags();
        return tags.get(0).getValue();
    }

    protected double getMaxTag(TaggedAxis1D axis) {
        List<Tag> tags = axis.getSortedTags();
        return tags.get(tags.size() - 1).getValue();
    }
}

