/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.axis.tagged;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.listener.AxisListener1D;
import com.metsci.glimpse.axis.tagged.Tag;
import com.metsci.glimpse.axis.tagged.TaggedAxis1D;
import java.util.ArrayList;
import java.util.List;

public abstract class TaggedAxisListener1D
implements AxisListener1D {
    protected List<Tag> previous;

    @Override
    public void axisUpdated(Axis1D axis) {
        TaggedAxis1D taggedAxis;
        List<Tag> current;
        if (axis == null) {
            return;
        }
        if (axis instanceof TaggedAxis1D && this.haveTagsChanged(this.previous, current = (taggedAxis = (TaggedAxis1D)axis).getSortedTags())) {
            this.tagsUpdated(taggedAxis);
            this.previous = this.copyTags(current);
        }
    }

    protected List<Tag> copyTags(List<Tag> list) {
        ArrayList<Tag> newList = new ArrayList<Tag>(list.size());
        for (Tag tag : newList) {
            newList.add(new Tag(tag));
        }
        return newList;
    }

    protected boolean haveTagsChanged(List<Tag> previous, List<Tag> current) {
        if (previous == null && current != null) {
            return true;
        }
        if (previous != null && current == null) {
            return true;
        }
        if (previous == null && current == null) {
            return false;
        }
        if (previous.size() != current.size()) {
            return true;
        }
        for (int i = 0; i < previous.size(); ++i) {
            Tag currentTag;
            Tag previousTag = previous.get(i);
            if (!previousTag.equals(currentTag = current.get(i))) {
                return true;
            }
            if (previousTag.getValue() == currentTag.getValue()) continue;
            return true;
        }
        return false;
    }

    public abstract void tagsUpdated(TaggedAxis1D var1);
}

