/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.axis.painter.label;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.painter.label.GridAxisLabelHandler;
import com.metsci.glimpse.util.geo.LatLonGeo;
import com.metsci.glimpse.util.geo.format.Util;
import com.metsci.glimpse.util.geo.projection.GeoProjection;

public class LatLonAxisLabelHandler
extends GridAxisLabelHandler {
    protected GeoProjection geoProjection;
    protected boolean longitude;

    public LatLonAxisLabelHandler(GeoProjection geoProjection, boolean longitude) {
        this.geoProjection = geoProjection;
        this.longitude = longitude;
    }

    @Override
    public String[] getTickLabels(Axis1D axis, double[] tickPositions) {
        String[] tickLabels = new String[tickPositions.length];
        for (int i = 0; i < tickPositions.length; ++i) {
            String tickString;
            LatLonGeo latLon;
            double tickPosition = tickPositions[i];
            if (this.longitude) {
                latLon = this.geoProjection.unproject(tickPosition, 0.0);
                tickString = Util.toDegreesMinutesSeconds((double)latLon.getLonDeg(), (int)0, (boolean)true);
            } else {
                latLon = this.geoProjection.unproject(0.0, tickPosition);
                tickString = Util.toDegreesMinutesSeconds((double)latLon.getLatDeg(), (int)0, (boolean)false);
            }
            tickLabels[i] = tickString;
        }
        return tickLabels;
    }

    @Override
    public String getAxisLabel(Axis1D axis) {
        return this.axisLabel;
    }
}

