/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.axis.painter.label;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.painter.label.AxisLabelHandler;
import com.metsci.glimpse.axis.painter.label.AxisUnitConverter;
import java.text.NumberFormat;

public class GridAxisLabelHandler
implements AxisLabelHandler {
    protected int tickSpacing;
    protected int minorTickCount;
    protected NumberFormat tickNumberFormatter = NumberFormat.getNumberInstance();
    protected NumberFormat orderNumberFormatter;
    protected String axisLabel = "";
    protected String axisUnits = "";
    protected String axisKiloUnits = "";
    protected String axisMilliUnits = "";
    protected AxisUnitConverter converter;

    public GridAxisLabelHandler() {
        this.tickNumberFormatter.setGroupingUsed(false);
        this.orderNumberFormatter = NumberFormat.getNumberInstance();
        this.orderNumberFormatter.setGroupingUsed(true);
        this.converter = new AxisUnitConverter(){

            @Override
            public double fromAxisUnits(double value) {
                return value;
            }

            @Override
            public double toAxisUnits(double value) {
                return value;
            }
        };
        this.tickSpacing = 100;
        this.minorTickCount = 4;
    }

    @Override
    public AxisUnitConverter getAxisUnitConverter() {
        return this.converter;
    }

    @Override
    public void setAxisUnitConverter(AxisUnitConverter converter) {
        this.converter = converter;
    }

    @Override
    public double[] getTickPositions(Axis1D axis) {
        if (axis.getSizePixels() == 0) {
            return new double[0];
        }
        return this.tickPositions(axis, this.tickInterval(axis));
    }

    @Override
    public String[] getTickLabels(Axis1D axis, double[] tickPositions) {
        double tickInterval = this.tickInterval(axis);
        int orderAxis = this.getOrderAxis(axis);
        int orderTick = this.getOrderTick(tickInterval);
        this.updateFormatter(orderAxis, orderTick);
        String[] tickLabels = new String[tickPositions.length];
        for (int i = 0; i < tickPositions.length; ++i) {
            tickLabels[i] = this.tickString(tickPositions[i], orderAxis);
        }
        return tickLabels;
    }

    @Override
    public double[] getMinorTickPositions(double[] tickPositions) {
        if (tickPositions.length < 2) {
            return new double[0];
        }
        double start = tickPositions[0];
        double end = tickPositions[1];
        double step = (end - start) / (double)(this.minorTickCount + 1);
        int minorIndex = 0;
        double[] minorTickPositions = new double[(tickPositions.length + 1) * this.minorTickCount];
        for (int i = 0; i < tickPositions.length; ++i) {
            start = tickPositions[i];
            for (int j = 1; j < this.minorTickCount + 1; ++j) {
                minorTickPositions[minorIndex++] = start - step * (double)j;
            }
        }
        start = tickPositions[tickPositions.length - 1];
        for (int j = 1; j < this.minorTickCount + 1; ++j) {
            minorTickPositions[minorIndex++] = start + step * (double)j;
        }
        return minorTickPositions;
    }

    @Override
    public String getAxisLabel(Axis1D axis) {
        return this.axisLabel(this.getOrderAxis(axis));
    }

    public void setTickSpacing(int spacing) {
        this.tickSpacing = spacing;
    }

    public void setMinorTickCount(int count) {
        this.minorTickCount = count;
    }

    @Override
    public void setAxisLabel(String label) {
        this.axisLabel = label;
    }

    public void setAxisUnits(String units, boolean abbreviated) {
        if (abbreviated) {
            this.setAxisUnits("m" + units, units, "k" + units);
        } else {
            this.setAxisUnits("milli" + units, units, "kilo" + units);
        }
    }

    public void setAxisUnits(String milliUnits, String units, String kiloUnits) {
        this.axisMilliUnits = milliUnits;
        this.axisUnits = units;
        this.axisKiloUnits = kiloUnits;
    }

    protected String axisLabel(int orderX) {
        String pad;
        String string = pad = this.axisLabel.length() > 0 ? " " : "";
        if (this.axisUnits.length() == 0) {
            if (orderX == 0) {
                return this.axisLabel;
            }
            if (orderX == 3) {
                return this.axisLabel + pad + "(x 1,000)";
            }
            if (orderX == -3) {
                return this.axisLabel + pad + "(x 0.001)";
            }
            return this.axisLabel + pad + "(x 10^" + orderX + ")";
        }
        if (orderX == 0) {
            return this.axisLabel + pad + "(" + this.axisUnits + ")";
        }
        if (orderX == 3) {
            return this.axisLabel + pad + "(" + this.axisKiloUnits + ")";
        }
        if (orderX == -3) {
            return this.axisLabel + pad + "(" + this.axisMilliUnits + ")";
        }
        if (orderX > 3) {
            int labelPower = 1;
            while (orderX > 3) {
                labelPower *= 10;
                --orderX;
            }
            return this.axisLabel + pad + "(x " + this.orderNumberFormatter.format(labelPower) + " " + this.axisKiloUnits + ")";
        }
        return this.axisLabel + pad + "(x 10^" + orderX + " " + this.axisUnits + ")";
    }

    protected double tickInterval(Axis1D axis) {
        double approxNumTicks = (double)axis.getSizePixels() / (double)this.tickSpacing;
        return this.tickInterval(axis, approxNumTicks);
    }

    protected String tickString(double number, int orderAxis) {
        double axisFactor = Math.pow(10.0, -orderAxis);
        return this.tickNumberFormatter.format(number * axisFactor);
    }

    protected double tickInterval(Axis1D axis, double approxNumTicks) {
        double approxTickInterval;
        double prelimTickInterval;
        double min = this.converter.toAxisUnits(axis.getMin());
        double max = this.converter.toAxisUnits(axis.getMax());
        double prelimNumTicks = (max - min) / (prelimTickInterval = Math.pow(10.0, Math.round(Math.log10(approxTickInterval = (max - min) / approxNumTicks))));
        if (prelimNumTicks >= 5.0 * approxNumTicks) {
            return prelimTickInterval * 5.0;
        }
        if (prelimNumTicks >= 2.0 * approxNumTicks) {
            return prelimTickInterval * 2.0;
        }
        if (5.0 * prelimNumTicks <= approxNumTicks) {
            return prelimTickInterval / 5.0;
        }
        if (2.0 * prelimNumTicks <= approxNumTicks) {
            return prelimTickInterval / 2.0;
        }
        return prelimTickInterval;
    }

    protected double[] tickPositions(Axis1D axis, double tickInterval) {
        double max;
        double min = this.converter.toAxisUnits(axis.getMin());
        if (min >= (max = this.converter.toAxisUnits(axis.getMax()))) {
            throw new IllegalArgumentException(String.format("Axis min value (%.3f) greater than axis max value (%.3f). Are you setting axis min/max bounds incorrectly?", min, max));
        }
        int minTickNumber = (int)Math.floor(min / tickInterval);
        int tickCount = (int)Math.ceil((max - min) / tickInterval);
        double[] ticks = new double[tickCount + 1];
        for (int i = 0; i < ticks.length; ++i) {
            ticks[i] = (double)(i + minTickNumber) * tickInterval;
        }
        return ticks;
    }

    protected int getOrderTick(double d) {
        int order;
        double log10 = Math.log10(d);
        if (log10 - (double)(order = (int)Math.floor(log10)) > 0.999999999999) {
            ++order;
        }
        return order;
    }

    protected int getOrderAxis(Axis1D axis) {
        double min = this.converter.toAxisUnits(axis.getMin());
        double max = this.converter.toAxisUnits(axis.getMax());
        int orderX = this.getOrderTick(Math.abs(max - min));
        if (orderX > 0) {
            return 3 * ((orderX - 1) / 3);
        }
        if (orderX < 0) {
            return 3 * (orderX / 3 - 1);
        }
        return 0;
    }

    protected void updateFormatter(int orderAxis, int orderTick) {
        this.tickNumberFormatter.setMaximumFractionDigits(orderAxis - orderTick);
    }
}

