/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.axis.painter;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.painter.TimeAxisPainter;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.plot.timeline.data.Epoch;
import com.metsci.glimpse.support.color.GlimpseColor;
import com.metsci.glimpse.util.units.time.Time;
import com.metsci.glimpse.util.units.time.TimeStamp;
import com.metsci.glimpse.util.units.time.format.TimeStampFormat;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.TimeZone;
import javax.media.opengl.GL;

public class TimeXAxisPainter
extends TimeAxisPainter {
    public TimeXAxisPainter(Epoch epoch) {
        this(defaultMinuteSecondFormat, defaultHourDayMonthFormat, defaultHourMinuteFormat, defaultDayMonthYearFormat, defaultDayFormat, defaultMonthFormat, defaultMonthYearFormat, defaultYearFormat, defaultTimeZone, epoch);
    }

    public TimeXAxisPainter(TimeStampFormat minuteSecondFormat, TimeStampFormat hourMinuteFormat, TimeStampFormat hourDayMonthFormat, TimeStampFormat dayMonthYearFormat, TimeStampFormat dayFormat, TimeStampFormat dayMonthFormat, TimeStampFormat monthYearFormat, TimeStampFormat yearFormat, TimeZone timeZone, Epoch epoch) {
        super(minuteSecondFormat, hourMinuteFormat, hourDayMonthFormat, dayMonthYearFormat, dayFormat, dayMonthFormat, monthYearFormat, yearFormat, timeZone, epoch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintTo(GlimpseContext context, GlimpseBounds bounds, Axis1D axis) {
        GL gl = context.getGL();
        int width = bounds.getWidth();
        int height = bounds.getHeight();
        if (width == 0 || height == 0) {
            return;
        }
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glOrtho(-0.5, (double)((float)(width - 1) + 0.5f), -0.5, (double)((float)(height - 1) + 0.5f), -1.0, 1.0);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        gl.glColor4fv(this.tickColor, 0);
        List<TimeStamp> tickTimes = this.tickTimes(axis, width);
        double tickInterval = this.tickInterval(tickTimes);
        gl.glBegin(1);
        for (TimeStamp t : tickTimes) {
            double x = axis.valueToScreenPixel(this.fromTimeStamp(t));
            gl.glVertex2d(x, (double)height);
            gl.glVertex2d(x, (double)(height - this.tickLineLength));
        }
        gl.glEnd();
        if (this.showCurrentTimeLabel) {
            this.drawCurrentTimeTick(gl, axis, width, height);
        }
        GlimpseColor.setColor(this.textRenderer, this.textColor);
        this.textRenderer.beginRendering(width, height);
        try {
            if (tickInterval <= Time.fromMinutes((double)1.0)) {
                double jTimeText = this.printTickLabels(tickTimes, axis, this.minuteSecondFormat, width, height);
                this.printHoverLabels(tickTimes, axis, this.hourDayMonthFormat, hourStructFactory, jTimeText, width, height);
            } else if (tickInterval <= Time.fromHours((double)12.0)) {
                double jTimeText = this.printTickLabels(tickTimes, axis, this.hourMinuteFormat, width, height);
                this.printHoverLabels(tickTimes, axis, this.dayMonthYearFormat, dayStructFactory, jTimeText, width, height);
            } else if (tickInterval <= Time.fromDays((double)10.0)) {
                double jTimeText = this.printTickLabels(tickTimes, axis, this.dayFormat, width, height);
                this.printHoverLabels(tickTimes, axis, this.monthYearFormat, monthStructFactory, jTimeText, width, height);
            } else if (tickInterval <= Time.fromDays((double)60.0)) {
                double jTimeText = this.printTickLabels(tickTimes, axis, this.monthFormat, width, height);
                this.printHoverLabels(tickTimes, axis, this.yearFormat, yearStructFactory, jTimeText, width, height);
            } else {
                this.printTickLabels(tickTimes, axis, this.yearFormat, width, height);
            }
        }
        finally {
            this.textRenderer.endRendering();
        }
    }

    private void printHoverLabels(List<TimeStamp> tickTimes, Axis1D axis, TimeStampFormat format, TimeAxisPainter.TimeStructFactory factory, double jTimeText, int width, int height) {
        Rectangle2D fixedBounds = this.textRenderer.getBounds("M");
        double textHeight = fixedBounds.getHeight();
        List<TimeAxisPainter.TimeStruct> timeStruts = this.timeStructs(axis, tickTimes, factory);
        for (TimeAxisPainter.TimeStruct time : timeStruts) {
            int iApprox;
            int iMax;
            String text = time.textCenter.toString(format);
            Rectangle2D textBounds = this.textRenderer.getBounds(text);
            double textWidth = textBounds.getWidth();
            int iMin = axis.valueToScreenPixel(this.fromTimeStamp(time.start));
            int i = Math.max(iMin, Math.min(iMax = (int)Math.floor((double)axis.valueToScreenPixel(this.fromTimeStamp(time.end)) - textWidth), iApprox = (int)Math.round((double)axis.valueToScreenPixel(this.fromTimeStamp(time.textCenter)) - 0.5 * textWidth)));
            if (i < 0 || (double)i + textWidth > (double)width) continue;
            int j = (int)Math.floor(jTimeText - textHeight - (double)this.hoverLabelOffset);
            this.textRenderer.draw(text, i, j);
        }
    }

    private double printTickLabels(List<TimeStamp> tickTimes, Axis1D axis, TimeStampFormat format, int width, int height) {
        Rectangle2D fixedBounds = this.textRenderer.getBounds("M");
        double textHeight = fixedBounds.getHeight();
        int jTimeText = Integer.MAX_VALUE;
        for (TimeStamp t : tickTimes) {
            String string = t.toString(format);
            Rectangle2D textBounds = this.textRenderer.getBounds(string);
            double textWidth = textBounds.getWidth();
            int i = (int)Math.round((double)axis.valueToScreenPixel(this.fromTimeStamp(t)) - 0.5 * textWidth);
            if (i < 0 || (double)i + textWidth > (double)width) continue;
            int j = (int)Math.round((double)(height - this.tickLineLength) - textHeight);
            jTimeText = Math.min(jTimeText, j);
            this.textRenderer.draw(string, i, j);
        }
        return jTimeText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawCurrentTimeTick(GL gl, Axis1D axis, int width, int height) {
        int iTick = axis.valueToScreenPixel(this.fromTimeStamp(TimeStamp.currentTime()));
        gl.glColor4fv(this.currentTimeTickColor, 0);
        gl.glLineWidth(this.currentTimeLineThickness);
        gl.glBegin(1);
        gl.glVertex2d((double)iTick, (double)height);
        gl.glVertex2d((double)iTick, 0.0);
        gl.glEnd();
        String text = "NOW";
        GlimpseColor.setColor(this.textRenderer, this.currentTimeTextColor);
        this.textRenderer.beginRendering(width, height);
        try {
            this.textRenderer.draw(text, iTick + 3, 3);
        }
        finally {
            this.textRenderer.endRendering();
        }
    }
}

