/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.axis.painter;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.painter.NumericAxisPainter;
import com.metsci.glimpse.axis.painter.label.AxisLabelHandler;
import com.metsci.glimpse.axis.painter.label.AxisUnitConverter;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.support.color.GlimpseColor;
import java.awt.geom.Rectangle2D;
import javax.media.opengl.GL;

public class NumericYAxisPainter
extends NumericAxisPainter {
    public NumericYAxisPainter(AxisLabelHandler ticks) {
        super(ticks);
    }

    @Override
    public void paintTo(GlimpseContext context, GlimpseBounds bounds, Axis1D axis) {
        GL gl = context.getGL();
        int width = bounds.getWidth();
        int height = bounds.getHeight();
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glOrtho(-0.5, (double)((float)(width - 1) + 0.5f), -0.5, (double)((float)(height - 1) + 0.5f), -1.0, 1.0);
        this.paintTicks(gl, axis, width, height);
        this.paintAxisLabel(gl, axis, width, height);
        this.paintSelectionLine(gl, axis, width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintTicks(GL gl, Axis1D axis, int width, int height) {
        int i;
        double[] yTicks = this.ticks.getTickPositions(axis);
        String[] yLabels = this.ticks.getTickLabels(axis, yTicks);
        AxisUnitConverter converter = this.ticks.getAxisUnitConverter();
        int iTick0 = this.getTickRightX(width, this.tickSize);
        int iTick1 = this.getTickLeftX(width, this.tickSize);
        int min = -1;
        int max = yTicks.length;
        GlimpseColor.glColor(gl, this.tickColor);
        gl.glBegin(1);
        try {
            for (i = 0; i < yTicks.length; ++i) {
                int jTick = axis.valueToScreenPixel(converter.fromAxisUnits(yTicks[i]));
                if (jTick == height) {
                    --jTick;
                }
                if (jTick > height && !this.showLabelsForOffscreenTicks) {
                    max = i;
                    break;
                }
                if (jTick < 0 && !this.showLabelsForOffscreenTicks) {
                    min = i;
                    continue;
                }
                gl.glVertex2f((float)iTick0, (float)jTick);
                gl.glVertex2f((float)iTick1, (float)jTick);
            }
            if (this.showMinorTicks) {
                double[] xMinor = this.ticks.getMinorTickPositions(yTicks);
                iTick0 = this.getTickRightX(width, this.tickSize / 2);
                iTick1 = this.getTickLeftX(width, this.tickSize / 2);
                for (int i2 = 0; i2 < xMinor.length; ++i2) {
                    int jTick = axis.valueToScreenPixel(converter.fromAxisUnits(xMinor[i2]));
                    gl.glVertex2f((float)iTick0, (float)jTick);
                    gl.glVertex2f((float)iTick1, (float)jTick);
                }
            }
        }
        finally {
            gl.glEnd();
        }
        GlimpseColor.setColor(this.textRenderer, this.tickLabelColor);
        this.textRenderer.beginRendering(width, height);
        try {
            for (i = min + 1; i < max; ++i) {
                double yTick = yTicks[i];
                String yLabel = yLabels[i];
                Rectangle2D tickTextBounds = this.textRenderer.getBounds(yLabel);
                int iTickText = this.getTickTextPositionX(width, (int)tickTextBounds.getWidth());
                int jTickText = (int)Math.round((double)axis.valueToScreenPixel(converter.fromAxisUnits(yTick)) - 0.35 * tickTextBounds.getHeight());
                if (this.keepLabelsForExtremaFullyVisible) {
                    if (jTickText < 0) {
                        jTickText = 0;
                    }
                    if ((double)jTickText + tickTextBounds.getHeight() > (double)height) {
                        jTickText = height - (int)tickTextBounds.getHeight();
                    }
                }
                this.textRenderer.draw(yLabel, iTickText, jTickText);
            }
        }
        finally {
            this.textRenderer.endRendering();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintAxisLabel(GL gl, Axis1D axis, int width, int height) {
        if (this.showLabel) {
            GlimpseColor.setColor(this.textRenderer, this.axisLabelColor);
            this.textRenderer.beginRendering(width, height);
            try {
                String label = this.ticks.getAxisLabel(axis);
                Rectangle2D labelSize = this.textRenderer.getBounds(label);
                int iAxisLabel = this.getAxisLabelPositionX(width, (int)labelSize.getHeight());
                int jAxisLabel = Math.round(0.5f * (float)(height - (int)labelSize.getWidth()));
                gl.glMatrixMode(5889);
                gl.glTranslatef((float)iAxisLabel, (float)jAxisLabel, 0.0f);
                gl.glRotatef(90.0f, 0.0f, 0.0f, 1.0f);
                this.textRenderer.draw(label, 0, 0);
            }
            finally {
                this.textRenderer.endRendering();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintSelectionLine(GL gl, Axis1D axis, int width, int height) {
        AxisUnitConverter converter = this.ticks.getAxisUnitConverter();
        if (this.showSelectionLine) {
            gl.glLineWidth((float)this.markerWidth);
            int y0 = axis.valueToScreenPixel(converter.fromAxisUnits(axis.getSelectionCenter()));
            gl.glBegin(1);
            try {
                gl.glVertex2f(0.0f, (float)y0);
                gl.glVertex2f((float)width, (float)y0);
            }
            finally {
                gl.glEnd();
            }
        }
    }

    public int getAxisLabelPositionX(int width, int textHeight) {
        return this.labelBufferSize + textHeight;
    }

    public int getTickTextPositionX(int width, int textWidth) {
        return width - 1 - this.tickBufferSize - this.tickSize - this.textBufferSize - textWidth;
    }

    public int getTickRightX(int width, int size) {
        return width - 1 - this.tickBufferSize;
    }

    public int getTickLeftX(int width, int size) {
        return width - 1 - this.tickBufferSize - size;
    }
}

