/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.axis.listener.mouse;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.listener.mouse.AxisMouseListener;
import com.metsci.glimpse.context.GlimpseTarget;
import com.metsci.glimpse.context.GlimpseTargetStack;
import com.metsci.glimpse.event.mouse.GlimpseMouseEvent;
import com.metsci.glimpse.layout.GlimpseAxisLayout1D;

public class AxisMouseListener1D
extends AxisMouseListener {
    protected GlimpseAxisLayout1D getAxisLayout(GlimpseMouseEvent event) {
        GlimpseTargetStack stack = event.getTargetStack();
        GlimpseTarget target = stack.getTarget();
        if (target instanceof GlimpseAxisLayout1D) {
            return (GlimpseAxisLayout1D)target;
        }
        return null;
    }

    @Override
    public void mousePressed(GlimpseMouseEvent event) {
        GlimpseAxisLayout1D layout = this.getAxisLayout(event);
        if (layout == null) {
            return;
        }
        Axis1D targetAxis = layout.getAxis(event.getTargetStack());
        this.mousePressed(event, targetAxis, layout.isHorizontal());
        this.validateAxes(targetAxis);
    }

    @Override
    public void mouseMoved(GlimpseMouseEvent event) {
        GlimpseAxisLayout1D layout = this.getAxisLayout(event);
        if (layout == null) {
            return;
        }
        Axis1D targetAxis = layout.getAxis(event.getTargetStack());
        this.mouseMoved(event, targetAxis, layout.isHorizontal());
        this.validateAxes(targetAxis);
    }

    @Override
    public void mouseWheelMoved(GlimpseMouseEvent event) {
        GlimpseAxisLayout1D layout = this.getAxisLayout(event);
        if (layout == null) {
            return;
        }
        Axis1D targetAxis = layout.getAxis(event.getTargetStack());
        this.mouseWheelMoved(event, targetAxis, layout.isHorizontal());
        this.validateAxes(targetAxis);
    }

    @Override
    public void mouseReleased(GlimpseMouseEvent event) {
        GlimpseAxisLayout1D layout = this.getAxisLayout(event);
        if (layout == null) {
            return;
        }
        Axis1D targetAxis = layout.getAxis(event.getTargetStack());
        this.mouseReleased(event, targetAxis, layout.isHorizontal());
        this.validateAxes(targetAxis);
    }

    @Override
    public void mouseEntered(GlimpseMouseEvent event) {
    }

    @Override
    public void mouseExited(GlimpseMouseEvent event) {
    }

    protected void validateAxes(Axis1D axis) {
        axis.applyConstraints();
        if (axis.getLockedAspectAxis() != null) {
            axis.getLockedAspectAxis().applyConstraints();
        }
        axis.updateLinkedAxes();
        if (axis.getLockedAspectAxis() != null) {
            axis.getLockedAspectAxis().updateLinkedAxes();
        }
    }
}

