/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.axis.listener;

import com.metsci.glimpse.util.logging.LoggerUtils;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;

public abstract class RateLimitedEventDispatcher<D> {
    public static Logger logger = Logger.getLogger(RateLimitedEventDispatcher.class.getName());
    private long idleTimeMillis;
    private long lastRunTimeMillis;
    private Thread thread;
    private ReentrantLock lock;
    private Condition cond;
    private volatile boolean updated;
    private D data;

    public RateLimitedEventDispatcher() {
        this(16L);
    }

    public RateLimitedEventDispatcher(double maxFreqHz) {
        this((long)(1000.0 / maxFreqHz));
    }

    public RateLimitedEventDispatcher(long _idleTimeMillis) {
        this.idleTimeMillis = _idleTimeMillis;
        this.lastRunTimeMillis = System.currentTimeMillis() - this.idleTimeMillis;
        this.lock = new ReentrantLock();
        this.cond = this.lock.newCondition();
        this.thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    long time;
                    RateLimitedEventDispatcher.this.lock.lock();
                    try {
                        while (!RateLimitedEventDispatcher.this.updated) {
                            try {
                                RateLimitedEventDispatcher.this.cond.await();
                            }
                            catch (InterruptedException e) {}
                        }
                    }
                    catch (Exception e) {
                        LoggerUtils.logWarning((Logger)logger, (String)"Exception in RateLimitedAxisListener", (Throwable)e, (Object[])new Object[0]);
                    }
                    finally {
                        RateLimitedEventDispatcher.this.lock.unlock();
                    }
                    while ((time = RateLimitedEventDispatcher.this.millisToNextUpdate()) > 0L) {
                        try {
                            Thread.sleep(time);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    RateLimitedEventDispatcher.this.eventDispatch0();
                }
            }
        };
        this.thread.setDaemon(true);
        this.thread.setName("rate-limited-axis-listener");
        this.thread.start();
    }

    protected long millisToNextUpdate() {
        long time = System.currentTimeMillis();
        long timeSinceLast = time - this.lastRunTimeMillis;
        long timeToNext = this.idleTimeMillis - timeSinceLast;
        return timeToNext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void eventDispatch0() {
        D data_temp = null;
        this.lock.lock();
        try {
            this.lastRunTimeMillis = System.currentTimeMillis();
            this.updated = false;
            data_temp = this.data;
        }
        finally {
            this.lock.unlock();
        }
        this.eventDispatch(data_temp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventOccurred(D _data) {
        if (!this.updated) {
            this.lock.lock();
            try {
                this.data = _data;
                this.updated = true;
                this.cond.signalAll();
            }
            catch (Exception e) {
                LoggerUtils.logWarning((Logger)logger, (String)"Exception in RateLimitedAxisListener", (Throwable)e, (Object[])new Object[0]);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public abstract void eventDispatch(D var1);
}

