/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.axis;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.axis.UpdateMode;
import com.metsci.glimpse.axis.listener.mouse.AxisMouseListener1D;
import com.metsci.glimpse.axis.listener.mouse.AxisMouseListener2D;
import com.metsci.glimpse.layout.GlimpseAxisLayout1D;
import com.metsci.glimpse.layout.GlimpseAxisLayout2D;

public class AxisUtil {
    public static Axis2D createAxis2D(GlimpseAxisLayout2D layout, Axis2D parentAxis) {
        return AxisUtil.createAxis2D(layout, parentAxis, UpdateMode.MinMax, false, -1.0, -1.0, -1.0, -1.0);
    }

    public static Axis2D createAxis2D(GlimpseAxisLayout2D layout) {
        return AxisUtil.createAxis2D(layout, null, UpdateMode.MinMax, false, -1.0, -1.0, -1.0, -1.0);
    }

    public static Axis2D createAxis2D(GlimpseAxisLayout2D layout, double minX, double maxX, double minY, double maxY) {
        return AxisUtil.createAxis2D(layout, null, UpdateMode.MinMax, true, minX, maxX, minY, maxY);
    }

    public static Axis2D createAxis2D(GlimpseAxisLayout2D layout, Axis2D parentAxis, UpdateMode mode, double minX, double maxX, double minY, double maxY) {
        return AxisUtil.createAxis2D(layout, parentAxis, mode, true, minX, maxX, minY, maxY);
    }

    public static Axis1D createHorizontalAxis(GlimpseAxisLayout1D layout, Axis1D parentAxis, UpdateMode mode) {
        return AxisUtil.createAxis(layout, parentAxis, mode, false, -1.0, -1.0);
    }

    public static Axis1D createVerticalAxis(GlimpseAxisLayout1D layout, Axis1D parentAxis, UpdateMode mode) {
        return AxisUtil.createAxis(layout, parentAxis, mode, false, -1.0, -1.0);
    }

    public static Axis1D createHorizontalAxis(GlimpseAxisLayout1D layout, Axis1D parentAxis) {
        return AxisUtil.createHorizontalAxis(layout, parentAxis, UpdateMode.MinMax);
    }

    public static Axis1D createVerticalAxis(GlimpseAxisLayout1D layout, Axis1D parentAxis) {
        return AxisUtil.createVerticalAxis(layout, parentAxis, UpdateMode.MinMax);
    }

    public static Axis1D createHorizontalAxis(GlimpseAxisLayout1D layout) {
        return AxisUtil.createHorizontalAxis(layout, UpdateMode.MinMax);
    }

    public static Axis1D createVerticalAxis(GlimpseAxisLayout1D layout) {
        return AxisUtil.createVerticalAxis(layout, UpdateMode.MinMax);
    }

    public static Axis1D createHorizontalAxis(GlimpseAxisLayout1D layout, UpdateMode mode) {
        return AxisUtil.createAxis(layout, null, mode, false, -1.0, -1.0);
    }

    public static Axis1D createVerticalAxis(GlimpseAxisLayout1D layout, UpdateMode mode) {
        return AxisUtil.createAxis(layout, null, mode, false, -1.0, -1.0);
    }

    public static Axis1D createHorizontalAxis(GlimpseAxisLayout1D layout, double min, double max) {
        return AxisUtil.createHorizontalAxis(layout, UpdateMode.MinMax, min, max);
    }

    public static Axis1D createVerticalAxis(GlimpseAxisLayout1D layout, double min, double max) {
        return AxisUtil.createVerticalAxis(layout, UpdateMode.MinMax, min, max);
    }

    public static Axis1D createHorizontalAxis(GlimpseAxisLayout1D layout, UpdateMode mode, double min, double max) {
        return AxisUtil.createAxis(layout, null, mode, true, min, max);
    }

    public static Axis1D createVerticalAxis(GlimpseAxisLayout1D layout, UpdateMode mode, double min, double max) {
        return AxisUtil.createAxis(layout, null, mode, true, min, max);
    }

    public static void attachHorizontalMouseListener(GlimpseAxisLayout1D layout) {
        AxisUtil.attachMouseListener(layout);
    }

    public static void attachVerticalMouseListener(GlimpseAxisLayout1D layout) {
        AxisUtil.attachMouseListener(layout);
    }

    public static void attachMouseListener(GlimpseAxisLayout2D layout) {
        AxisMouseListener2D listener = new AxisMouseListener2D();
        layout.addGlimpseMouseAllListener(listener);
    }

    private static void attachMouseListener(GlimpseAxisLayout1D layout) {
        AxisMouseListener1D listener = new AxisMouseListener1D();
        layout.addGlimpseMouseAllListener(listener);
    }

    private static Axis1D createAxis(GlimpseAxisLayout1D layout, Axis1D parentAxis, UpdateMode mode, boolean setMinMax, double min, double max) {
        Axis1D axis = new Axis1D();
        axis.setUpdateMode(mode);
        if (setMinMax) {
            axis.setMin(min);
            axis.setMax(max);
        }
        axis.setParent(parentAxis);
        AxisUtil.attachMouseListener(layout);
        layout.setAxis(axis);
        return axis;
    }

    private static Axis2D createAxis2D(GlimpseAxisLayout2D layout, Axis2D parentAxis, UpdateMode mode, boolean setMinMax, double minX, double maxX, double minY, double maxY) {
        Axis2D axis = new Axis2D();
        axis.getAxisX().setUpdateMode(mode);
        axis.getAxisY().setUpdateMode(mode);
        if (setMinMax) {
            axis.getAxisX().setMin(minX);
            axis.getAxisX().setMax(maxX);
            axis.getAxisY().setMin(minY);
            axis.getAxisY().setMax(maxY);
        }
        axis.setParent(parentAxis);
        AxisUtil.attachMouseListener(layout);
        layout.setAxis(axis);
        return axis;
    }
}

