/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.axis;

import com.metsci.glimpse.axis.UpdateMode;
import com.metsci.glimpse.axis.listener.AxisListener1D;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;

public class Axis1D {
    public static Logger logger = Logger.getLogger(Axis1D.class.getName());
    protected double selectionCenterValue;
    protected double selectionSizeValue;
    protected boolean selectionLocked;
    protected double mousePosValue;
    protected double minValue;
    protected double maxValue;
    protected double pixelsPerValue;
    protected double minValue_lastValid;
    protected double maxValue_lastValid;
    protected UpdateMode updateMode;
    protected boolean lockMin;
    protected double lockMinValue;
    protected boolean lockMax;
    protected double lockMaxValue;
    protected boolean constrainMinDiff;
    protected double minDiff;
    protected boolean constrainMaxDiff;
    protected double maxDiff;
    protected int axisSizePixels;
    protected boolean initialized;
    protected double absoluteMin;
    protected double absoluteMax;
    protected List<AxisListener1D> listeners;
    protected List<Axis1D> children;
    protected Axis1D parentAxis;
    protected Axis1D orthogonalAxis;
    protected double orthogonalAspectRatio;
    protected boolean linkChildren;

    public Axis1D(Axis1D parent) {
        this.initialize(parent);
    }

    public Axis1D() {
        this(null);
    }

    protected void initialize(Axis1D parent) {
        this.children = new CopyOnWriteArrayList<Axis1D>();
        this.listeners = new CopyOnWriteArrayList<AxisListener1D>();
        this.setDefaults();
        this.setParent(parent);
    }

    public Axis1D clone() {
        return new Axis1D(this);
    }

    public void validate() {
        this.applyConstraints();
        this.updateLinkedAxes();
    }

    public void setParent(Axis1D newParent) {
        this.setParent(newParent, false);
    }

    public void setParent(Axis1D newParent, boolean duplicateChild) {
        if (this.parentAxis != null && newParent == null) {
            this.parentAxis.removeChildAxis(this);
        }
        this.parentAxis = newParent;
        if (this.parentAxis != null) {
            this.parentAxis.addChildAxis(this);
            if (!duplicateChild) {
                this.parentAxis.updateLinkedAxes();
            }
        }
        if (duplicateChild) {
            this.updateLinkedAxes();
        }
    }

    public void setLinkChildren(boolean link) {
        this.linkChildren = link;
    }

    protected void removeChildAxis(Axis1D child) {
        this.children.remove(child);
    }

    protected void addChildAxis(Axis1D child) {
        this.children.add(child);
    }

    public void addAxisListener(AxisListener1D listener) {
        this.listeners.add(listener);
    }

    public void removeAxisListener(AxisListener1D listener) {
        this.listeners.remove(listener);
    }

    public void lockAspectRatio(Axis1D orthogonalAxis, double aspectRatio) {
        if (!this.updateMode.isScalePreserving()) {
            this.setUpdateMode(UpdateMode.CenterScale);
        }
        this.orthogonalAxis = orthogonalAxis;
        this.orthogonalAspectRatio = aspectRatio;
    }

    public void setMinSpan(double diff) {
        this.minDiff = diff;
        this.constrainMinDiff = true;
    }

    public void setMaxSpan(double diff) {
        this.maxDiff = diff;
        this.constrainMaxDiff = true;
    }

    public void setConstrainMinSpan(boolean constrain) {
        this.constrainMinDiff = constrain;
    }

    public void setConstrainMaxSpan(boolean constrain) {
        this.constrainMaxDiff = constrain;
    }

    public boolean isMinSpanConstrained() {
        return this.constrainMinDiff;
    }

    public boolean isMaxSpanConstrained() {
        return this.constrainMaxDiff;
    }

    public void unlockAspectRatio() {
        this.orthogonalAxis = null;
    }

    public void lockMin(double value) {
        this.lockMin = true;
        this.lockMinValue = value;
    }

    public void lockMax(double value) {
        this.lockMax = true;
        this.lockMaxValue = value;
    }

    public void unlockMin() {
        this.lockMin = false;
    }

    public void unlockMax() {
        this.lockMax = false;
    }

    public void setUpdateMode(UpdateMode mode) {
        this.updateMode = mode;
    }

    public void setMin(double value) {
        this.minValue = value;
    }

    public void setMax(double value) {
        this.maxValue = value;
    }

    public void setAbsoluteMin(double min) {
        this.absoluteMin = min;
    }

    public void setAbsoluteMax(double max) {
        this.absoluteMax = max;
    }

    public void setSelectionSize(double value) {
        this.selectionSizeValue = value;
    }

    public void setSelectionCenter(double value) {
        this.selectionCenterValue = value;
    }

    public void setSelectionLock(boolean lock) {
        this.selectionLocked = lock;
    }

    public void setMouseValue(double value) {
        this.mousePosValue = value;
    }

    public void setSizePixels(int newSize) {
        this.setSizePixels(newSize, true);
    }

    public void setSizePixels(int newSize, boolean initialize) {
        if (newSize == 0) {
            return;
        }
        this.axisSizePixels = newSize;
        this.applyUpdateMode();
        this.recalculatePixelsPerValue0();
        this.applyConstraints();
        if (initialize) {
            this.setInitialized();
        }
    }

    public void setInitialized() {
        if (!this.initialized && this.axisSizePixels > 0) {
            this.initialized = true;
            this.requestAxisUpdateUp();
        }
    }

    public double getMinSpan() {
        return this.minDiff;
    }

    public double getMaxSpan() {
        return this.maxDiff;
    }

    public Axis1D getLockedAspectAxis() {
        return this.orthogonalAxis;
    }

    public double getLockedAspectRatio() {
        return this.orthogonalAspectRatio;
    }

    public double getLockMin() {
        return this.lockMinValue;
    }

    public double getLockMax() {
        return this.lockMaxValue;
    }

    public boolean isLockMin() {
        return this.lockMin;
    }

    public boolean isLockMax() {
        return this.lockMax;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public UpdateMode getUpdateMode() {
        return this.updateMode;
    }

    public double getMin() {
        return this.minValue;
    }

    public double getMax() {
        return this.maxValue;
    }

    public double getAbsoluteMin() {
        return this.absoluteMin;
    }

    public double getAbsoluteMax() {
        return this.absoluteMax;
    }

    public double getSelectionSize() {
        return this.selectionSizeValue;
    }

    public double getSelectionCenter() {
        return this.selectionCenterValue;
    }

    public boolean isSelectionLocked() {
        return this.selectionLocked;
    }

    public int getSizePixels() {
        return this.axisSizePixels;
    }

    public double getMouseValue() {
        return this.mousePosValue;
    }

    public double getPixelsPerValue() {
        return this.pixelsPerValue;
    }

    public double screenPixelToValue(double pixel) {
        return this.screenPixelToValue0(pixel, this.pixelsPerValue);
    }

    public int valueToScreenPixel(double value) {
        return this.valueToScreenPixel0(value, this.pixelsPerValue);
    }

    public double valueToScreenPixelUnits(double value) {
        return this.valueToScreenPixelUnits0(value, this.pixelsPerValue);
    }

    public void applyConstraints() {
        if (!this.isInitialized()) {
            return;
        }
        this.recalculatePixelsPerValue0();
        this.applyBoundConstraints();
        this.applyDiffConstraints();
        this.applyLockConstraints();
        this.minValue_lastValid = this.minValue;
        this.maxValue_lastValid = this.maxValue;
    }

    protected void applyBoundConstraints() {
        if (this.minValue < this.absoluteMin) {
            this.minValue = this.absoluteMin;
            this.recalculateMaxValue0();
        }
        if (this.maxValue > this.absoluteMax) {
            this.maxValue = this.absoluteMax;
            this.recalculateMinValue0();
        }
        if (this.minValue < this.absoluteMin || this.maxValue > this.absoluteMax) {
            this.minValue = this.absoluteMin;
            this.maxValue = this.absoluteMax;
            this.recalculatePixelsPerValue0();
        }
    }

    protected void applyLockConstraints() {
        double diff = this.maxValue - this.minValue;
        if (this.lockMin && this.lockMax) {
            this.minValue = this.lockMinValue;
            this.maxValue = this.lockMaxValue;
        } else if (this.lockMin) {
            this.minValue = this.lockMinValue;
            this.maxValue = this.minValue + diff;
        } else if (this.lockMax) {
            this.maxValue = this.lockMaxValue;
            this.minValue = this.maxValue - diff;
        }
        this.recalculatePixelsPerValue0();
    }

    protected void applyDiffConstraints() {
        double diff = this.maxValue - this.minValue;
        double center = (this.maxValue_lastValid - this.minValue_lastValid) / 2.0 + this.minValue_lastValid;
        if (this.constrainMinDiff && diff < this.minDiff) {
            this.minValue = center - this.minDiff / 2.0;
            this.maxValue = center + this.minDiff / 2.0;
        } else if (this.constrainMaxDiff && diff > this.maxDiff) {
            this.minValue = center - this.maxDiff / 2.0;
            this.maxValue = center + this.maxDiff / 2.0;
        }
        if (this.orthogonalAxis != null) {
            double orthoginalMinDiff = this.orthogonalAxis.minDiff * this.orthogonalAspectRatio;
            double orthoginalMaxDiff = this.orthogonalAxis.maxDiff * this.orthogonalAspectRatio;
            if (this.orthogonalAxis.constrainMinDiff && diff < orthoginalMinDiff) {
                this.minValue = center - orthoginalMinDiff / 2.0;
                this.maxValue = center + orthoginalMinDiff / 2.0;
            } else if (this.orthogonalAxis.constrainMaxDiff && diff > orthoginalMaxDiff) {
                this.minValue = center - orthoginalMaxDiff / 2.0;
                this.maxValue = center + orthoginalMaxDiff / 2.0;
            }
        }
    }

    protected void applyUpdateMode() {
        if (!(!this.isInitialized() || this.lockMax && this.lockMin)) {
            if (this.updateMode == UpdateMode.MinScale) {
                if (this.lockMax) {
                    this.recalculateMinValue0();
                } else {
                    this.recalculateMaxValue0();
                }
            } else if (this.updateMode == UpdateMode.CenterScale) {
                if (this.lockMax) {
                    this.recalculateMinValue0();
                } else if (this.lockMin) {
                    this.recalculateMaxValue0();
                } else {
                    this.recalculateMinMaxValue0();
                }
            } else if (this.updateMode == UpdateMode.MinMax) {
                this.recalculatePixelsPerValue0();
            } else if (this.updateMode == UpdateMode.FixedPixel) {
                double maxPercent = (this.maxValue - this.absoluteMin) / (this.absoluteMax - this.absoluteMin);
                double minPercent = (this.minValue - this.absoluteMin) / (this.absoluteMax - this.absoluteMin);
                this.absoluteMax = this.absoluteMin + (double)this.axisSizePixels;
                if (this.lockMax) {
                    this.minValue = minPercent * (double)this.axisSizePixels + this.absoluteMin;
                } else if (this.lockMin) {
                    this.maxValue = maxPercent * (double)this.axisSizePixels + this.absoluteMin;
                } else {
                    this.minValue = minPercent * (double)this.axisSizePixels + this.absoluteMin;
                    this.maxValue = maxPercent * (double)this.axisSizePixels + this.absoluteMin;
                }
                this.recalculatePixelsPerValue0();
            }
        }
    }

    public void updateLinkedAxes() {
        HashSet<Axis1D> visited = new HashSet<Axis1D>();
        this.broadcastAxisUpdateUp(this, visited);
    }

    public void updateLinkedAxes(Axis1D ... ignore) {
        HashSet<Axis1D> visited = new HashSet<Axis1D>();
        for (Axis1D axis : ignore) {
            visited.add(axis);
        }
        this.broadcastAxisUpdateUp(this, visited);
    }

    protected void updateAspectRatio(Axis1D updated, double aspectRatio, Set<Axis1D> visited) {
        this.updateAspectRatio(updated, aspectRatio);
        this.broadcastAxisUpdateUp(this, visited);
    }

    protected void updateAspectRatio(Axis1D updated, double aspectRatio) {
        if (!this.isInitialized()) {
            return;
        }
        double oldPixelsPerValue = this.getPixelsPerValue();
        double newPixelsPerValue = updated.getPixelsPerValue() * aspectRatio;
        this.minValue = this.recenterMinValue0((double)this.getSizePixels() / 2.0, oldPixelsPerValue, newPixelsPerValue);
        this.pixelsPerValue = newPixelsPerValue;
        this.recalculateMaxValue0();
        this.applyConstraints();
    }

    protected void updateOrthogonalAspectRatio(Set<Axis1D> visited) {
        if (this.orthogonalAxis != null) {
            this.orthogonalAxis.updateAspectRatio(this, this.orthogonalAspectRatio, visited);
        }
    }

    protected double recenterMinValue0(double proposedCenterPixels, double oldPixelsPerValue, double newPixelsPerValue) {
        double zoomCenterPixels;
        double zoomCenterValue;
        if (this.lockMax) {
            zoomCenterValue = this.maxValue;
            zoomCenterPixels = this.axisSizePixels;
        } else if (this.lockMin) {
            zoomCenterValue = this.minValue;
            zoomCenterPixels = 0.0;
        } else {
            zoomCenterPixels = proposedCenterPixels;
            zoomCenterValue = this.screenPixelToValue0(zoomCenterPixels, oldPixelsPerValue);
        }
        return zoomCenterValue - zoomCenterPixels / newPixelsPerValue;
    }

    protected void axisUpdated0(Axis1D axis) {
        this.updateMode = axis.getUpdateMode();
        this.lockMin = axis.isLockMin();
        this.lockMax = axis.isLockMax();
        this.lockMinValue = axis.getLockMin();
        this.lockMaxValue = axis.getLockMax();
        this.absoluteMin = axis.getAbsoluteMin();
        this.absoluteMax = axis.getAbsoluteMax();
        this.selectionCenterValue = axis.getSelectionCenter();
        this.selectionSizeValue = axis.getSelectionSize();
        this.selectionLocked = axis.isSelectionLocked();
        if (!this.isInitialized()) {
            this.minValue = axis.getMin();
            this.maxValue = axis.getMax();
            this.pixelsPerValue = axis.getPixelsPerValue();
        } else if (this.updateMode == UpdateMode.MinScale) {
            this.minValue = axis.getMin();
            this.pixelsPerValue = axis.getPixelsPerValue();
            this.recalculateMaxValue0();
            this.applyConstraints();
        } else if (this.updateMode == UpdateMode.CenterScale) {
            this.pixelsPerValue = axis.getPixelsPerValue();
            double centerValue = (axis.getMax() - axis.getMin()) / 2.0 + axis.getMin();
            this.recalculateMinMaxValue0(centerValue);
            this.applyConstraints();
        } else if (this.updateMode == UpdateMode.MinMax) {
            this.minValue = axis.getMin();
            this.maxValue = axis.getMax();
            this.recalculatePixelsPerValue0();
            this.applyConstraints();
        } else if (this.updateMode == UpdateMode.FixedPixel) {
            // empty if block
        }
    }

    protected double screenPixelToValue0(double pixel, double pixelsPerValue) {
        return pixel / pixelsPerValue + this.minValue;
    }

    protected int valueToScreenPixel0(double value, double pixelsPerValue) {
        return (int)Math.rint(Axis1D.tweakUp(this.valueToScreenPixelUnits0(value, pixelsPerValue)));
    }

    protected double valueToScreenPixelUnits0(double value, double pixelsPerValue) {
        return (value - this.minValue) * pixelsPerValue;
    }

    protected void recalculateMinValue0() {
        this.minValue = this.maxValue - (double)this.axisSizePixels / this.pixelsPerValue;
    }

    protected void recalculateMaxValue0() {
        this.maxValue = this.minValue + (double)this.axisSizePixels / this.pixelsPerValue;
    }

    protected void recalculatePixelsPerValue0() {
        this.pixelsPerValue = (double)this.axisSizePixels / (this.maxValue - this.minValue);
    }

    protected void recalculateMinMaxValue0(double centerValue) {
        double axisSizeValue = (double)this.axisSizePixels / this.pixelsPerValue;
        this.minValue = centerValue - axisSizeValue / 2.0;
        this.maxValue = centerValue + axisSizeValue / 2.0;
    }

    private void recalculateMinMaxValue0() {
        this.recalculateMinMaxValue0(this.getCenterValue());
    }

    private double getCenterValue() {
        return (this.maxValue - this.minValue) / 2.0 + this.minValue;
    }

    protected void requestAxisUpdateUp() {
        if (this.parentAxis != null) {
            this.parentAxis.requestAxisUpdateUp();
        } else {
            this.axisUpdated(this, new HashSet<Axis1D>());
        }
    }

    protected void broadcastAxisUpdateUp(Axis1D source, Set<Axis1D> visited) {
        if (this.parentAxis != null && this.parentAxis.linkChildren) {
            this.parentAxis.broadcastAxisUpdateUp(source, visited);
        } else {
            this.axisUpdated(source, visited);
        }
    }

    protected void axisUpdated(Axis1D source, Set<Axis1D> visited) {
        if (!visited.add(this)) {
            return;
        }
        this.axisUpdated0(source);
        this.updateOrthogonalAspectRatio(visited);
        if (this.linkChildren) {
            for (Axis1D axis : this.children) {
                axis.axisUpdated(source, visited);
            }
        }
        for (AxisListener1D child : this.listeners) {
            child.axisUpdated(source);
        }
    }

    protected void setDefaults() {
        this.selectionCenterValue = 5.0;
        this.selectionSizeValue = 1.0;
        this.selectionLocked = false;
        this.mousePosValue = 0.0;
        this.minValue = 0.0;
        this.maxValue = 10.0;
        this.pixelsPerValue = 1.0;
        this.minValue_lastValid = 0.0;
        this.maxValue_lastValid = 10.0;
        this.updateMode = UpdateMode.MinMax;
        this.lockMin = false;
        this.lockMax = false;
        this.linkChildren = true;
        this.axisSizePixels = 0;
        this.initialized = false;
        this.absoluteMin = -1.7976931348623157E308;
        this.absoluteMax = Double.MAX_VALUE;
    }

    protected static double tweakUp(double val) {
        if (Double.isInfinite(val) || Double.isNaN(val)) {
            return val;
        }
        double eps = 1.0;
        while (val + (eps /= 2.0) / 2.0 != val) {
        }
        return val + eps * 2.0 * 10.0;
    }

    public String toString() {
        return String.format("[%.3f %.3f %d]", this.minValue, this.maxValue, this.axisSizePixels);
    }
}

