/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.support.texture;

import com.metsci.glimpse.gl.util.GLUtils;
import com.metsci.glimpse.support.texture.TextureProjected2D;
import com.metsci.glimpse.util.logging.LoggerUtils;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.logging.Logger;
import javax.media.opengl.GL;

public class FloatTextureProjected2D
extends TextureProjected2D {
    private static final Logger logger = Logger.getLogger(FloatTextureProjected2D.class.getName());

    public FloatTextureProjected2D(int dataSizeX, int dataSizeY) {
        this(dataSizeX, dataSizeY, false);
    }

    public FloatTextureProjected2D(int dataSizeX, int dataSizeY, boolean useVertexZCoord) {
        super(dataSizeX, dataSizeY, useVertexZCoord);
    }

    protected Buffer prepare_setPixelStore(GL gl, int i) {
        gl.glPixelStorei(3317, 1);
        gl.glPixelStorei(3316, this.texStartsX[i]);
        gl.glPixelStorei(3314, this.dataSizeX);
        return this.data.asFloatBuffer().position(this.texStartsY[i] * this.dataSizeX);
    }

    @Override
    protected void prepare_setData(GL gl) {
        for (int i = 0; i < this.numTextures; ++i) {
            gl.glBindTexture(GLUtils.getGLTextureDim(2), this.textureHandles[i]);
            this.prepare_setTexParameters(gl);
            Buffer positionedBuffer = this.prepare_setPixelStore(gl, i);
            gl.glTexImage2D(3553, 0, 34840, this.texSizesX[i], this.texSizesY[i], 0, 6409, 5126, positionedBuffer);
        }
        gl.glPixelStorei(3316, 0);
        gl.glPixelStorei(3315, 0);
        gl.glPixelStorei(3314, 0);
    }

    @Override
    protected int getRequiredCapacityBytes() {
        return this.dataSizeX * this.dataSizeY * 4;
    }

    @Override
    protected float getData(int index) {
        return this.data.asFloatBuffer().get(index);
    }

    public void setData(float[][] data) {
        this.mutate(new SetDataMutator(data));
    }

    public void setData(float[][] data, boolean flip) {
        this.mutate(new SetDataMutator(data, flip));
    }

    public void setData(double[][] data) {
        this.mutate(new SetDataMutator(data));
    }

    public void setData(double[][] data, boolean flip) {
        this.mutate(new SetDataMutator(data, flip));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mutate(MutatorFloat2D mutator) {
        this.lock.lock();
        try {
            this.data.rewind();
            mutator.mutate(this.data.asFloatBuffer(), this.dataSizeX, this.dataSizeY);
            this.makeDirty();
        }
        finally {
            this.lock.unlock();
        }
    }

    public static class SetDataMutator
    implements MutatorFloat2D {
        public float[][] dataf;
        public double[][] datad;
        public boolean flip;

        public SetDataMutator(float[][] data, boolean flip) {
            this.dataf = data;
            this.flip = flip;
        }

        public SetDataMutator(double[][] data, boolean flip) {
            this.datad = data;
            this.flip = flip;
        }

        public SetDataMutator(float[][] data) {
            this(data, false);
        }

        public SetDataMutator(double[][] data) {
            this(data, false);
        }

        @Override
        public void mutate(FloatBuffer buffer, int dataSizeX, int dataSizeY) {
            if (this.dataf != null) {
                this.mutatef(buffer, dataSizeX, dataSizeY);
            } else if (this.datad != null) {
                this.mutated(buffer, dataSizeX, dataSizeY);
            }
        }

        public void mutatef(FloatBuffer buffer, int dataSizeX, int dataSizeY) {
            if (this.dataf == null) {
                logger.warning("Null data array passed to SetDataMutator.");
                return;
            }
            buffer.clear();
            if (!this.flip) {
                if (this.dataf.length != dataSizeX || this.dataf[0].length != dataSizeY) {
                    LoggerUtils.logWarning((Logger)logger, (String)"Incorrectly sized data array passed to SetDataMutator. Expected %d %d. Got %d %d.", (Object[])new Object[]{dataSizeX, dataSizeY, this.dataf.length, this.dataf[0].length});
                    return;
                }
                for (int y = 0; y < dataSizeY; ++y) {
                    for (int x = 0; x < dataSizeX; ++x) {
                        buffer.put(this.dataf[x][y]);
                    }
                }
            } else {
                if (this.dataf.length != dataSizeY || this.dataf[0].length != dataSizeX) {
                    LoggerUtils.logWarning((Logger)logger, (String)"Incorrectly sized data array passed to SetDataMutator. Expected %d %d. Got %d %d.", (Object[])new Object[]{dataSizeX, dataSizeY, this.dataf[0].length, this.dataf.length});
                    return;
                }
                for (int y = 0; y < dataSizeY; ++y) {
                    for (int x = 0; x < dataSizeX; ++x) {
                        buffer.put(this.dataf[y][x]);
                    }
                }
            }
        }

        public void mutated(FloatBuffer buffer, int dataSizeX, int dataSizeY) {
            if (this.datad == null) {
                logger.warning("Null data array passed to SetDataMutator.");
                return;
            }
            buffer.clear();
            if (!this.flip) {
                if (this.datad.length != dataSizeX || this.datad[0].length != dataSizeY) {
                    LoggerUtils.logWarning((Logger)logger, (String)"Incorrectly sized data array passed to SetDataMutator. Expected %d %d. Got %d %d.", (Object[])new Object[]{dataSizeX, dataSizeY, this.datad.length, this.datad[0].length});
                    return;
                }
                for (int y = 0; y < dataSizeY; ++y) {
                    for (int x = 0; x < dataSizeX; ++x) {
                        buffer.put((float)this.datad[x][y]);
                    }
                }
            } else {
                if (this.datad.length != dataSizeY || this.datad[0].length != dataSizeX) {
                    LoggerUtils.logWarning((Logger)logger, (String)"Incorrectly sized data array passed to SetDataMutator. Expected %d %d. Got %d %d.", (Object[])new Object[]{dataSizeX, dataSizeY, this.datad[0].length, this.dataf.length});
                    return;
                }
                for (int y = 0; y < dataSizeY; ++y) {
                    for (int x = 0; x < dataSizeX; ++x) {
                        buffer.put((float)this.datad[y][x]);
                    }
                }
            }
        }
    }

    public static interface MutatorFloat2D {
        public void mutate(FloatBuffer var1, int var2, int var3);
    }
}

