/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.support.selection;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.axis.listener.RateLimitedAxisListener2D;
import com.metsci.glimpse.painter.track.Point;
import com.metsci.glimpse.painter.track.TrackPainter;
import com.metsci.glimpse.support.selection.SpatialSelectionListener;
import java.util.Collection;
import java.util.Collections;

public class SpatialSelectionAxisListener
extends RateLimitedAxisListener2D {
    private TrackPainter painter;
    private SpatialSelectionListener<Point> listener;

    public SpatialSelectionAxisListener(TrackPainter painter, SpatialSelectionListener<Point> listener) {
        this.painter = painter;
        this.listener = listener;
    }

    @Override
    public void axisUpdatedRateLimited(Axis2D axis) {
        Axis1D axisX = axis.getAxisX();
        Axis1D axisY = axis.getAxisY();
        double centerX = axisX.getSelectionCenter();
        double sizeX = axisX.getSelectionSize() / 2.0;
        double centerY = axisY.getSelectionCenter();
        double sizeY = axisY.getSelectionSize() / 2.0;
        double minX = centerX - sizeX;
        double maxX = centerX + sizeX;
        double minY = centerY - sizeY;
        double maxY = centerY + sizeY;
        Collection<Point> selection = Collections.unmodifiableCollection(this.painter.getTimeGeoRange(minX, maxX, minY, maxY));
        this.listener.selectionChanged(selection);
    }
}

