/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.support.color;

import com.sun.opengl.util.j2d.TextRenderer;
import java.awt.Color;
import java.text.ParseException;
import javax.media.opengl.GL;

public class GlimpseColor {
    public static float[] fromColorRgb(float r, float g, float b) {
        return new float[]{r, g, b, 1.0f};
    }

    public static float[] fromColorRgba(float r, float g, float b, float a) {
        return new float[]{r, g, b, a};
    }

    public static float[] fromColorRgb(int r, int g, int b) {
        float fr = (float)r / 255.0f;
        float fg = (float)g / 255.0f;
        float fb = (float)b / 255.0f;
        return new float[]{fr, fg, fb, 1.0f};
    }

    public static float[] fromColorRgba(int r, int g, int b, int a) {
        float fr = (float)r / 255.0f;
        float fg = (float)g / 255.0f;
        float fb = (float)b / 255.0f;
        float fa = (float)a / 255.0f;
        return new float[]{fr, fg, fb, fa};
    }

    public static float[] fromColorHsb(float hue, float saturation, float brightness) {
        int rgb = Color.HSBtoRGB(hue, saturation, brightness);
        int r = rgb >> 16 | 0xFF;
        int g = rgb >> 8 | 0xFF;
        int b = rgb | 0xFF;
        return GlimpseColor.fromColorRgb(r, g, b);
    }

    public static float[] fromColorAwt(Color color) {
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        float a = (float)color.getAlpha() / 255.0f;
        return GlimpseColor.fromColorRgba(r, g, b, a);
    }

    public static float[] fromColorHex(String color) throws ParseException {
        if ((color = color.trim()) == null || color.length() != 7 && color.length() != 9) {
            throw new ParseException("Color string must be of the form: #RRGGBB or #RRGGBBAA", 0);
        }
        int r = Integer.decode("#" + color.substring(1, 3));
        int g = Integer.decode("#" + color.substring(3, 5));
        int b = Integer.decode("#" + color.substring(5, 7));
        int a = color.length() == 9 ? Integer.decode("#" + color.substring(7, 9)) : 255;
        return GlimpseColor.fromColorRgba(r, g, b, a);
    }

    public static Color toColorAwt(float[] color) {
        return new Color(color[0], color[1], color[2], color[3]);
    }

    public static void glClearColor(GL gl, float[] color) {
        gl.glClearColor(color[0], color[1], color[2], color[3]);
    }

    public static void setColor(TextRenderer renderer, float[] color) {
        renderer.setColor(color[0], color[1], color[2], color[3]);
    }

    public static void glColor(GL gl, float[] color) {
        gl.glColor4fv(color, 0);
    }

    public static void glColor(GL gl, float[] color, float alphaOverride) {
        gl.glColor4f(color[0], color[1], color[2], alphaOverride);
    }

    public static String getString(float[] color) {
        if (color == null || color.length == 0) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < color.length - 1; ++i) {
            s.append(color[i]).append(",");
        }
        s.append(color[color.length - 1]);
        return s.toString();
    }

    public static float[] getRed() {
        return new float[]{1.0f, 0.0f, 0.0f, 1.0f};
    }

    public static float[] getRed(float alpha) {
        return new float[]{1.0f, 0.0f, 0.0f, alpha};
    }

    public static float[] getGreen() {
        return new float[]{0.0f, 1.0f, 0.0f, 1.0f};
    }

    public static float[] getGreen(float alpha) {
        return new float[]{0.0f, 1.0f, 0.0f, alpha};
    }

    public static float[] getYellow() {
        return new float[]{1.0f, 1.0f, 0.0f, 1.0f};
    }

    public static float[] getYellow(float alpha) {
        return new float[]{1.0f, 1.0f, 0.0f, alpha};
    }

    public static float[] getBlue() {
        return new float[]{0.0f, 0.0f, 1.0f, 1.0f};
    }

    public static float[] getBlue(float alpha) {
        return new float[]{0.0f, 0.0f, 1.0f, alpha};
    }

    public static float[] getWhite() {
        return new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    }

    public static float[] getWhite(float alpha) {
        return new float[]{1.0f, 1.0f, 1.0f, alpha};
    }

    public static float[] getBlack() {
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    }

    public static float[] getBlack(float alpha) {
        return new float[]{0.0f, 0.0f, 0.0f, alpha};
    }

    public static float[] getGray() {
        return new float[]{0.5f, 0.5f, 0.5f, 1.0f};
    }

    public static float[] getGray(float alpha) {
        return new float[]{0.5f, 0.5f, 0.5f, alpha};
    }
}

