/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.plot;

import com.metsci.glimpse.layout.GlimpseAxisLayout2D;
import com.metsci.glimpse.painter.base.GlimpsePainter;
import com.metsci.glimpse.painter.decoration.BackgroundPainter;
import com.metsci.glimpse.painter.decoration.BorderPainter;
import com.metsci.glimpse.painter.decoration.CrosshairPainter;
import com.metsci.glimpse.painter.decoration.GridPainter;
import com.metsci.glimpse.plot.Plot2D;

public class SimplePlot2D
extends Plot2D {
    protected BorderPainter borderPainter;
    protected BackgroundPainter plotBackgroundPainter;
    protected GridPainter gridPainter;
    protected GlimpseAxisLayout2D contentLayout;
    protected CrosshairPainter crosshairPainter;

    public SimplePlot2D() {
        this.initialize();
    }

    public SimplePlot2D(String name) {
        this.initialize();
        this.setName(name);
    }

    @Override
    protected void initializePainters() {
        super.initializePainters();
        this.plotBackgroundPainter = new BackgroundPainter(false);
        this.axisLayoutXY.addPainter(this.plotBackgroundPainter);
        this.gridPainter = new GridPainter(this.tickX, this.tickY);
        this.axisLayoutXY.addPainter(this.gridPainter);
        this.contentLayout = new GlimpseAxisLayout2D("Plot");
        this.contentLayout.setEventConsumer(false);
        this.axisLayoutXY.addLayout(this.contentLayout);
        this.crosshairPainter = new CrosshairPainter();
        this.axisLayoutXY.addPainter(this.crosshairPainter);
        this.borderPainter = new BorderPainter();
        this.axisLayoutXY.addPainter(this.borderPainter);
        this.setAxisSizeZ(0);
    }

    public void addPainterOuter(GlimpsePainter painter) {
        super.addPainter(painter);
    }

    public void removePainterOuter(GlimpsePainter painter) {
        super.removePainter(painter);
    }

    @Override
    public void addPainter(GlimpsePainter painter) {
        this.contentLayout.addPainter(painter);
    }

    @Override
    public void removePainter(GlimpsePainter painter) {
        this.contentLayout.removePainter(painter);
    }

    public void setPlotBackgroundColor(float[] color) {
        this.plotBackgroundPainter.setColor(color);
    }

    @Override
    public void setBackgroundColor(float[] color) {
        this.backgroundPainter.setColor(color);
    }

    public CrosshairPainter getCrosshairPainter() {
        return this.crosshairPainter;
    }

    public BorderPainter getBorderPainter() {
        return this.borderPainter;
    }

    public GridPainter getGridPainter() {
        return this.gridPainter;
    }

    @Override
    public GlimpseAxisLayout2D getLayoutCenter() {
        return this.contentLayout;
    }

    @Override
    public String toString() {
        return SimplePlot2D.class.getSimpleName();
    }
}

