/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.painter.treemap;

import com.metsci.glimpse.painter.treemap.TreeMapLayout;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SquarifiedLayout
implements TreeMapLayout {
    @Override
    public Rectangle2D[] layout(Rectangle2D boundary, double[] areas, int level) {
        int[] order = this.sort(areas);
        double sumOfAreas = 0.0;
        for (double a : areas) {
            sumOfAreas += a;
        }
        double[] sorted = new double[areas.length];
        for (int i = 0; i < order.length; ++i) {
            sorted[i] = areas[order[i]] / sumOfAreas * boundary.getWidth() * boundary.getHeight();
        }
        ArrayList<Rectangle2D> rectList = new ArrayList<Rectangle2D>();
        if (sorted.length > 1) {
            double shortestSide = Math.min(boundary.getWidth(), boundary.getHeight());
            this.squarify(0, sorted, boundary, new ArrayList<Double>(), shortestSide, rectList);
        } else {
            rectList.add(boundary);
        }
        Rectangle2D[] rects = new Rectangle2D[areas.length];
        for (int i = 0; i < rectList.size(); ++i) {
            rects[order[i]] = (Rectangle2D)rectList.get(i);
        }
        return rects;
    }

    protected void squarify(int head, double[] sortedSizes, Rectangle2D boundary, List<Double> row, double shortestSide, List<Rectangle2D> rects) {
        if (row.isEmpty() || this.worst(row, null, shortestSide) >= this.worst(row, sortedSizes[head], shortestSide)) {
            if (head == sortedSizes.length - 1) {
                row.add(sortedSizes[head]);
                this.layoutRow(boundary, rects, row);
            } else {
                row.add(sortedSizes[head]);
                this.squarify(head + 1, sortedSizes, boundary, row, shortestSide, rects);
            }
        } else {
            Rectangle2D newBoundary = this.layoutRow(boundary, rects, row);
            shortestSide = Math.min(newBoundary.getWidth(), newBoundary.getHeight());
            this.squarify(head, sortedSizes, newBoundary, new ArrayList<Double>(), shortestSide, rects);
        }
    }

    protected Rectangle2D layoutRow(Rectangle2D boundary, List<Rectangle2D> rects, List<Double> row) {
        double sumOfAreas = 0.0;
        for (double a : row) {
            sumOfAreas += a;
        }
        boolean vertical = boundary.getWidth() >= boundary.getHeight();
        double x = boundary.getMinX();
        double y = boundary.getMaxY();
        double width = sumOfAreas / boundary.getHeight();
        double height = sumOfAreas / boundary.getWidth();
        for (double area : row) {
            if (vertical) {
                height = area / width;
            } else {
                width = area / height;
            }
            Rectangle2D.Double rect = new Rectangle2D.Double(x, y - height, width, height);
            rects.add(rect);
            if (vertical) {
                y -= height;
                continue;
            }
            x += width;
        }
        if (vertical) {
            return new Rectangle2D.Double(boundary.getMinX() + width, boundary.getMinY(), boundary.getWidth() - width, boundary.getHeight());
        }
        return new Rectangle2D.Double(boundary.getMinX(), boundary.getMinY(), boundary.getWidth(), boundary.getHeight() - height);
    }

    protected double worst(List<Double> areas, Double newArea, double shortestSide) {
        double minArea = Double.POSITIVE_INFINITY;
        double maxArea = Double.NEGATIVE_INFINITY;
        double totalArea = 0.0;
        for (double a : areas) {
            minArea = Math.min(a, minArea);
            maxArea = Math.max(a, maxArea);
            totalArea += a;
        }
        if (newArea != null) {
            minArea = Math.min(newArea, minArea);
            maxArea = Math.max(newArea, maxArea);
            totalArea += newArea.doubleValue();
        }
        double worst = Math.max(maxArea * shortestSide * shortestSide / (totalArea * totalArea), totalArea * totalArea / (minArea * shortestSide * shortestSide));
        return worst;
    }

    protected int[] sort(final double[] areas) {
        ArrayList<Integer> list = new ArrayList<Integer>(areas.length);
        for (int i = 0; i < areas.length; ++i) {
            list.add(i);
        }
        Collections.sort(list, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return Double.compare(areas[o2], areas[o1]);
            }
        });
        int[] indexes = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            indexes[i] = (Integer)list.get(i);
        }
        return indexes;
    }
}

