/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.painter.plot;

import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.painter.base.GlimpseDataPainter2D;
import com.sun.opengl.util.BufferUtil;
import it.unimi.dsi.fastutil.floats.Float2IntMap;
import it.unimi.dsi.fastutil.floats.Float2IntOpenHashMap;
import java.nio.FloatBuffer;
import java.util.concurrent.locks.ReentrantLock;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;

public class HistogramPainter
extends GlimpseDataPainter2D {
    public static final int FLOATS_PER_BAR = 8;
    protected float[] barColor = new float[]{1.0f, 0.0f, 0.0f, 0.6f};
    protected int dataSize = 0;
    protected int[] bufferHandle = null;
    protected FloatBuffer dataBuffer = null;
    protected ReentrantLock dataBufferLock = new ReentrantLock();
    protected volatile boolean newData = false;
    protected volatile boolean bufferInitialized = false;
    protected float binSize;
    protected float binStart;
    protected float minY;
    protected float maxY;
    protected float minX;
    protected float maxX;

    public void setColor(float[] rgba) {
        this.barColor = rgba;
    }

    public void setColor(float r, float g, float b, float a) {
        this.barColor[0] = r;
        this.barColor[1] = g;
        this.barColor[2] = b;
        this.barColor[3] = a;
    }

    public void autoAdjustAxisBounds(Axis2D axis) {
        axis.getAxisX().setMin(this.minX);
        axis.getAxisX().setMax(this.maxX);
        axis.getAxisY().setMin(this.minY);
        axis.getAxisY().setMax(this.maxY);
    }

    public void setData(double[] data) {
        this.setData(data, data.length);
    }

    public void setData(double[] data, int size) {
        if (data == null || data.length == 0) {
            return;
        }
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        for (int i = 0; i < size; ++i) {
            double value = data[i];
            if (value > max) {
                max = value;
            }
            if (!(value < min)) continue;
            min = value;
        }
        double binSize = (max - min) / Math.sqrt(size);
        this.setData(data, size, binSize, min);
    }

    public void setData(float[] data) {
        this.setData(data, data.length);
    }

    public void setData(float[] data, int size) {
        if (data == null || data.length == 0) {
            return;
        }
        float min = Float.MAX_VALUE;
        float max = -3.4028235E38f;
        for (int i = 0; i < size; ++i) {
            float value = data[i];
            if (value > max) {
                max = value;
            }
            if (!(value < min)) continue;
            min = value;
        }
        float binSize = (max - min) / (float)Math.sqrt(size);
        this.setData(data, size, binSize, min);
    }

    public void setData(double[] data, double binSize, double binStart) {
        this.setData(data, data.length, binSize, binStart);
    }

    public void setData(double[] data, int size, double binSize, double binStart) {
        this.binStart = (float)binStart;
        Float2IntOpenHashMap counts = new Float2IntOpenHashMap();
        for (int i = 0; i < size; ++i) {
            double value = data[i];
            float bin = HistogramPainter.getBin(value, binSize, binStart);
            if (!counts.containsKey(bin)) {
                counts.put(bin, 1);
                continue;
            }
            counts.put(bin, counts.get(bin) + 1);
        }
        this.setData((Float2IntMap)counts, size, (float)binSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(Float2IntMap counts, int totalSize, float binSize) {
        this.binSize = binSize;
        this.dataBufferLock.lock();
        try {
            this.minY = 0.0f;
            this.maxY = 0.0f;
            this.minX = Float.POSITIVE_INFINITY;
            this.maxX = Float.NEGATIVE_INFINITY;
            this.dataSize = counts.size();
            if (this.dataBuffer == null || this.dataBuffer.rewind().capacity() < this.dataSize * 8) {
                this.dataBuffer = BufferUtil.newFloatBuffer((int)(this.dataSize * 8));
            }
            for (Float2IntMap.Entry entry : counts.float2IntEntrySet()) {
                float bin = entry.getFloatKey();
                int count = entry.getIntValue();
                float freq = (float)count / (float)totalSize;
                if (freq > this.maxY) {
                    this.maxY = freq;
                }
                if (bin < this.minX) {
                    this.minX = bin;
                }
                if (bin > this.maxX) {
                    this.maxX = bin;
                }
                this.dataBuffer.put(bin).put(0.0f);
                this.dataBuffer.put(bin).put(freq);
                this.dataBuffer.put(bin + this.binSize).put(freq);
                this.dataBuffer.put(bin + this.binSize).put(0.0f);
            }
            this.newData = true;
        }
        finally {
            this.dataBufferLock.unlock();
        }
    }

    public void setData(double[] data, float binSize, float binStart) {
        this.setData(data, data.length, (double)binSize, (double)binStart);
    }

    public void setData(float[] data, int size, float binSize, float binStart) {
        this.binStart = binStart;
        Float2IntOpenHashMap counts = new Float2IntOpenHashMap();
        for (int i = 0; i < size; ++i) {
            float value = data[i];
            float bin = HistogramPainter.getBin(value, binSize, binStart);
            if (!counts.containsKey(bin)) {
                counts.put(bin, 1);
                continue;
            }
            counts.put(bin, counts.get(bin) + 1);
        }
        this.setData((Float2IntMap)counts, size, binSize);
    }

    public float getBinSize() {
        return this.binSize;
    }

    public float getBinStart() {
        return this.binStart;
    }

    public float getMinY() {
        return this.minY;
    }

    public float getMaxY() {
        return this.maxY;
    }

    public float getMinX() {
        return this.minX;
    }

    public float getMaxX() {
        return this.maxX;
    }

    protected static float getBin(double data, double binSize, double binStart) {
        return (float)(Math.floor((data - binStart) / binSize) * binSize + binStart);
    }

    @Override
    public void dispose(GLContext context) {
        if (this.bufferInitialized) {
            context.getGL().glDeleteBuffers(1, this.bufferHandle, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintTo(GL gl, GlimpseBounds bounds, Axis2D axis) {
        if (this.dataSize == 0) {
            return;
        }
        if (!this.bufferInitialized) {
            this.bufferHandle = new int[1];
            gl.glGenBuffers(1, this.bufferHandle, 0);
            this.bufferInitialized = true;
        }
        gl.glBindBuffer(34962, this.bufferHandle[0]);
        if (this.newData) {
            this.dataBufferLock.lock();
            try {
                gl.glBufferData(34962, this.dataSize * 8 * 4, this.dataBuffer.rewind(), 35048);
                this.glHandleError(gl);
                this.newData = false;
            }
            finally {
                this.dataBufferLock.unlock();
            }
        }
        gl.glBindBuffer(34962, this.bufferHandle[0]);
        gl.glVertexPointer(2, 5126, 0, 0L);
        gl.glEnableClientState(32884);
        gl.glColor4fv(this.barColor, 0);
        gl.glDrawArrays(7, 0, this.dataSize * 4);
    }
}

