/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.painter.geo;

import com.metsci.glimpse.painter.track.Point;
import com.metsci.glimpse.painter.track.TrackPainter;
import com.metsci.glimpse.util.geo.LatLonGeo;
import com.metsci.glimpse.util.geo.projection.GeoProjection;
import com.metsci.glimpse.util.vector.Vector2d;
import java.util.Collection;

public class LatLonTrackPainter
extends TrackPainter {
    protected GeoProjection geoProjection;

    public LatLonTrackPainter(GeoProjection geoProjection) {
        this(geoProjection, true);
    }

    public LatLonTrackPainter(GeoProjection geoProjection, boolean enableSpatialIndex) {
        super(enableSpatialIndex);
        this.geoProjection = geoProjection;
    }

    public void addPointGeo(int trackId, int pointId, double lat, double lon, long time) {
        this.addPointGeo(trackId, pointId, new LatLonGeo(lat, lon), time);
    }

    public void addPointGeo(int trackId, int pointId, LatLonGeo latLon, long time) {
        Vector2d projected = this.geoProjection.project(latLon);
        this.addPoint(trackId, pointId, projected.getX(), projected.getY(), time);
    }

    public Collection<Point> getGeoRange(LatLonGeo minLatLon, LatLonGeo maxLatLon) {
        Vector2d projectedMin = this.geoProjection.project(minLatLon);
        Vector2d projectedMax = this.geoProjection.project(maxLatLon);
        return super.getGeoRange((float)projectedMin.getX(), (float)projectedMax.getX(), (float)projectedMax.getY(), (float)projectedMax.getY());
    }

    public Collection<Point> getTimeGeoRange(LatLonGeo minLatLon, LatLonGeo maxLatLon) {
        Vector2d projectedMin = this.geoProjection.project(minLatLon);
        Vector2d projectedMax = this.geoProjection.project(maxLatLon);
        return super.getTimeGeoRange((float)projectedMin.getX(), (float)projectedMax.getX(), (float)projectedMax.getY(), (float)projectedMax.getY());
    }

    public Collection<Point> getTimeGeoRange(long minTime, long maxTime, LatLonGeo minLatLon, LatLonGeo maxLatLon) {
        Vector2d projectedMin = this.geoProjection.project(minLatLon);
        Vector2d projectedMax = this.geoProjection.project(maxLatLon);
        return super.getTimeGeoRange(minTime, maxTime, (double)((float)projectedMin.getX()), (double)((float)projectedMax.getX()), (double)((float)projectedMax.getY()), (double)((float)projectedMax.getY()));
    }
}

