/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.layout;

import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.context.GlimpseTargetStack;
import com.metsci.glimpse.layout.GlimpseLayout;
import com.metsci.glimpse.layout.GlimpseLayoutManager;
import com.metsci.glimpse.layout.GlimpseLayoutManagerMig;
import com.metsci.glimpse.painter.base.GlimpsePainter;
import com.metsci.glimpse.painter.base.GlimpsePainterCallback;
import com.metsci.glimpse.support.settings.LookAndFeel;
import java.awt.Dimension;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.media.opengl.GL;
import net.miginfocom.layout.ComponentWrapper;
import net.miginfocom.layout.ContainerWrapper;

public class GlimpseLayoutDelegate
implements ComponentWrapper,
ContainerWrapper {
    public static final int DEFAULT = -1;
    public static final int DEFAULT_WIDTH = 100;
    public static final int DEFAULT_HEIGHT = 100;
    private int x;
    private int y;
    private int width;
    private int height;
    private boolean isDisposed = false;
    private boolean visible = true;
    private boolean visualPadding = false;
    private static final boolean zeroMinSize = true;
    private GlimpseLayoutManager layoutManager = new GlimpseLayoutManagerMig("bottomtotop, gapx 0, gapy 0, insets 0", null, null);
    private Object layoutData = "push, grow";
    private GlimpseLayout layout;
    private GlimpseLayoutDelegate layoutParent;
    private List<GlimpseLayoutDelegate> layoutChildren;
    private List<Member> members;

    public GlimpseLayoutDelegate(GlimpseLayout layout) {
        this.layout = layout;
        this.layoutChildren = new CopyOnWriteArrayList<GlimpseLayoutDelegate>();
        this.members = new CopyOnWriteArrayList<Member>();
    }

    protected GlimpseBounds getClippedBounds(GlimpseContext context) {
        int minX = Integer.MIN_VALUE;
        int maxX = Integer.MAX_VALUE;
        int minY = Integer.MIN_VALUE;
        int maxY = Integer.MAX_VALUE;
        for (GlimpseBounds parentBounds : context.getTargetStack().getBoundsList()) {
            minX = Math.max(parentBounds.getX(), minX);
            maxX = Math.min(parentBounds.getX() + parentBounds.getWidth(), maxX);
            minY = Math.max(parentBounds.getY(), minY);
            maxY = Math.min(parentBounds.getY() + parentBounds.getHeight(), maxY);
        }
        return new GlimpseBounds(minX, minY, maxX - minX, maxY - minY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintTo(GlimpseContext context) {
        GL gl = context.getGL();
        GlimpseBounds bounds = context.getTargetStack().getBounds();
        GlimpseBounds clippedBounds = this.getClippedBounds(context);
        if (!clippedBounds.isValid()) {
            return;
        }
        for (Member m : this.members) {
            try {
                gl.glEnable(3089);
                gl.glViewport(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
                gl.glScissor(clippedBounds.getX(), clippedBounds.getY(), clippedBounds.getWidth(), clippedBounds.getHeight());
                if (m.callback != null) {
                    m.callback.prePaint(m.painter, context);
                }
                m.painter.paintTo(context);
                if (m.callback == null) continue;
                m.callback.postPaint(m.painter, context);
            }
            finally {
                gl.glDisable(3089);
            }
        }
    }

    public void layoutTo(GlimpseContext context, GlimpseBounds bounds) {
        this.layoutTo(context.getTargetStack(), bounds);
    }

    public void layoutTo(GlimpseTargetStack stack, GlimpseBounds bounds) {
        stack.push(this.layout, bounds);
        this.layout.preLayout(stack, bounds);
        this.setBounds(bounds);
        for (GlimpseLayoutDelegate child : this.layoutChildren) {
            child.setParent(this);
        }
        this.layoutManager.layout(this);
        for (GlimpseLayoutDelegate child : this.layoutChildren) {
            GlimpseBounds childBounds = child.getBounds();
            child.cacheBounds(stack, childBounds);
            child.layoutTo(stack, childBounds);
        }
        stack.pop();
    }

    public void setLookAndFeel(LookAndFeel laf) {
        for (Member m : this.members) {
            m.painter.setLookAndFeel(laf);
        }
    }

    public void invalidateLayout() {
        for (GlimpseLayoutDelegate child : this.layoutChildren) {
            child.layout.invalidateLayout();
        }
    }

    public void removeLayout(GlimpseLayout layout) {
        this.members.remove(new Member(layout, null));
        GlimpseLayoutDelegate delegate = layout.getDelegate();
        this.layoutChildren.remove(delegate);
    }

    public void addLayout(GlimpseLayout layout) {
        this.addLayout(layout, null);
    }

    public void addLayout(GlimpseLayout layout, GlimpsePainterCallback callback) {
        this.members.add(new Member(layout, callback));
        GlimpseLayoutDelegate delegate = layout.getDelegate();
        this.layoutChildren.add(delegate);
    }

    public void addPainter(GlimpsePainter painter) {
        this.addPainter(painter, null);
    }

    public void addPainter(GlimpsePainter painter, GlimpsePainterCallback callback) {
        this.members.add(new Member(painter, callback));
    }

    public void removePainter(GlimpsePainter painter) {
        this.members.remove(new Member(painter, null));
    }

    public GlimpseBounds getCachedBounds(GlimpseContext context) {
        return this.layout.getBounds(context);
    }

    public void cacheBounds(GlimpseContext context, GlimpseBounds bounds) {
        this.layout.cacheBounds(context, bounds);
    }

    public void cacheBounds(GlimpseTargetStack stack, GlimpseBounds bounds) {
        this.layout.cacheBounds(stack, bounds);
    }

    public GlimpseBounds getBounds() {
        return new GlimpseBounds(this.x, this.y, this.width, this.height);
    }

    public Object getLayoutData() {
        return this.layoutData;
    }

    public void setLayoutManager(GlimpseLayoutManager manager) {
        this.layoutManager = manager;
    }

    public GlimpseLayoutManager getLayoutManager() {
        return this.layoutManager;
    }

    public void setLayoutData(Object layoutData) {
        this.layoutData = layoutData;
    }

    public void setParent(GlimpseLayoutDelegate parent) {
        this.layoutParent = parent;
    }

    public void dispose(GlimpseContext context) {
        if (!this.isDisposed) {
            for (Member member : this.members) {
                member.painter.dispose(context);
            }
        }
        this.isDisposed = true;
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    public void setBounds(GlimpseBounds bounds) {
        this.x = bounds.getX();
        this.y = bounds.getY();
        this.width = bounds.getWidth();
        this.height = bounds.getHeight();
    }

    public void setBounds(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public GlimpseLayoutDelegate getComponent() {
        return this;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    private final Dimension computeSize(int wHint, int hHint) {
        int width = wHint == -1 ? 100 : wHint;
        int height = hHint == -1 ? 100 : hHint;
        int border = 0;
        return new Dimension(width += border * 2, height += border * 2);
    }

    public int getMinimumWidth(int hHint) {
        return 0;
    }

    public int getMinimumHeight(int wHint) {
        return 0;
    }

    public int getPreferredWidth(int hHint) {
        return this.computeSize((int)-1, (int)hHint).width;
    }

    public int getPreferredHeight(int wHint) {
        return this.computeSize((int)wHint, (int)-1).height;
    }

    public int getMaximumWidth(int hHint) {
        return Short.MAX_VALUE;
    }

    public int getMaximumHeight(int wHint) {
        return Short.MAX_VALUE;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public int getBaseline(int width, int height) {
        return -1;
    }

    public boolean hasBaseline() {
        return false;
    }

    public GlimpseLayoutDelegate getParent() {
        return this.layoutParent;
    }

    public String getLinkId() {
        return null;
    }

    public int getLayoutHashCode() {
        String id;
        int h = this.x + (this.y << 12) + (this.width << 22) + (this.height << 16);
        if (this.isVisible()) {
            h |= 0x2000000;
        }
        if ((id = this.getLinkId()) != null) {
            h += id.hashCode();
        }
        if (this.isLeftToRight()) {
            h |= 0x4000000;
        }
        return h;
    }

    public boolean isPadded() {
        return this.visualPadding;
    }

    public void setPadding(boolean v) {
        this.visualPadding = v;
    }

    public int[] getVisualPadding() {
        return null;
    }

    public int getComponetType(boolean disregardScrollPane) {
        return 1;
    }

    RuntimeException screenAccessException() {
        return new UnsupportedOperationException("GL layout parameters cannot use screen parameters.");
    }

    public void paintDebugOutline() {
        throw this.screenAccessException();
    }

    public float getPixelUnitFactor(boolean isHor) {
        return 1.0f;
    }

    public int getHorizontalScreenDPI() {
        throw this.screenAccessException();
    }

    public int getVerticalScreenDPI() {
        throw this.screenAccessException();
    }

    public int getScreenWidth() {
        throw this.screenAccessException();
    }

    public int getScreenHeight() {
        throw this.screenAccessException();
    }

    public int getScreenLocationX() {
        throw this.screenAccessException();
    }

    public int getScreenLocationY() {
        throw this.screenAccessException();
    }

    public ComponentWrapper[] getComponents() {
        return this.layoutChildren.toArray(new ComponentWrapper[0]);
    }

    public int getComponentCount() {
        return this.layoutChildren.size();
    }

    public GlimpseLayoutManager getLayout() {
        return this.layoutManager;
    }

    public boolean isLeftToRight() {
        return true;
    }

    public void paintDebugCell(int x, int y, int width, int height) {
        throw this.screenAccessException();
    }

    private static class Member {
        public GlimpsePainter painter;
        public GlimpsePainterCallback callback;

        public Member(GlimpsePainter painter, GlimpsePainterCallback callback) {
            this.painter = painter;
            this.callback = callback;
        }

        public int hashCode() {
            return 31 + (this.painter == null ? 0 : this.painter.hashCode());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Member other = (Member)obj;
            if (this.painter == null && other.painter != null) {
                return false;
            }
            return this.painter.equals(other.painter);
        }
    }
}

