/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.gl.util;

import com.metsci.glimpse.gl.util.GLUtils;
import com.metsci.glimpse.util.logging.LoggerUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;

public class GLCapabilityUtils {
    public static final String glVendorDocumentation = "The company responsible for this GL implementation. This name does not change from release to release.";
    public static final String glRendererDocumentation = "The name of the renderer. This name is typically specific to a particular configuration of a hardware platform. It does not change from release to release.";
    public static final String glVersionDocumentation = "A version or release number.";
    public static final String glShaderVersionDocumentation = "A version or release number for the shading language.";
    public static final String glExtensionDocumentation = "A list of supported extensions to GL.";

    private GLCapabilityUtils() {
    }

    public static void logGLBufferProperties(Logger logger, Level level, GLContext context, String prefix) {
        GL gl = context.getGL();
        if (prefix == null) {
            prefix = "";
        }
        int rBits = GLUtils.queryGLInteger(3410, gl);
        int gBits = GLUtils.queryGLInteger(3411, gl);
        int bBits = GLUtils.queryGLInteger(3412, gl);
        int aBits = GLUtils.queryGLInteger(3413, gl);
        int iBits = GLUtils.queryGLInteger(3409, gl);
        int dBits = GLUtils.queryGLInteger(3414, gl);
        int sBits = GLUtils.queryGLInteger(3415, gl);
        int arBits = GLUtils.queryGLInteger(3416, gl);
        int agBits = GLUtils.queryGLInteger(3417, gl);
        int abBits = GLUtils.queryGLInteger(3418, gl);
        int aaBits = GLUtils.queryGLInteger(3419, gl);
        int totalBits = iBits + rBits + gBits + bBits + aBits + arBits + agBits + abBits + aaBits + dBits + sBits;
        LoggerUtils.log((Logger)logger, (Level)level, (String)"%sbuffer-properties: %2d bits depth", (Object[])new Object[]{prefix, dBits});
        LoggerUtils.log((Logger)logger, (Level)level, (String)"%sbuffer-properties: %2d bits stencil", (Object[])new Object[]{prefix, sBits});
        LoggerUtils.log((Logger)logger, (Level)level, (String)"%sbuffer-properties: %2d bits color-index", (Object[])new Object[]{prefix, iBits});
        LoggerUtils.log((Logger)logger, (Level)level, (String)"%sbuffer-properties: %2d bits red", (Object[])new Object[]{prefix, rBits});
        LoggerUtils.log((Logger)logger, (Level)level, (String)"%sbuffer-properties: %2d bits green", (Object[])new Object[]{prefix, gBits});
        LoggerUtils.log((Logger)logger, (Level)level, (String)"%sbuffer-properties: %2d bits blue", (Object[])new Object[]{prefix, bBits});
        LoggerUtils.log((Logger)logger, (Level)level, (String)"%sbuffer-properties: %2d bits alpha", (Object[])new Object[]{prefix, aBits});
        LoggerUtils.log((Logger)logger, (Level)level, (String)"%sbuffer-properties: %2d bits accum red", (Object[])new Object[]{prefix, arBits});
        LoggerUtils.log((Logger)logger, (Level)level, (String)"%sbuffer-properties: %2d bits accum green", (Object[])new Object[]{prefix, agBits});
        LoggerUtils.log((Logger)logger, (Level)level, (String)"%sbuffer-properties: %2d bits accum blue", (Object[])new Object[]{prefix, abBits});
        LoggerUtils.log((Logger)logger, (Level)level, (String)"%sbuffer-properties: %2d bits accum alpha", (Object[])new Object[]{prefix, aaBits});
        LoggerUtils.log((Logger)logger, (Level)level, (String)"%sbuffer-properties: %d bits TOTAL", (Object[])new Object[]{prefix, totalBits});
        boolean isDoubleBuffered = GLUtils.queryGLBoolean(3122, gl);
        LoggerUtils.log((Logger)logger, (Level)level, (String)"%sbuffer-properties: %s double buffered", (Object[])new Object[]{prefix, isDoubleBuffered ? "is" : "is NOT"});
        boolean isStereo = GLUtils.queryGLBoolean(3123, gl);
        LoggerUtils.log((Logger)logger, (Level)level, (String)"%sbuffer-properties: %s stereo", (Object[])new Object[]{prefix, isStereo ? "is" : "is NOT"});
    }

    public static void logGLVersionInfo(Logger logger, Level level, GLContext context) {
        GLCapabilityUtils.logGLVersionInfo(logger, level, context, false);
    }

    public static void logGLVersionInfo(Logger logger, Level level, GLContext context, boolean includeDocumentations) {
        String shaderVersion;
        String glVersion;
        String renderer;
        GL gl = context.getGL();
        String vendor = GLCapabilityUtils.getGLVendorString(gl);
        if (vendor == null) {
            vendor = "unavailable";
        }
        if ((renderer = GLCapabilityUtils.getGLRendererString(gl)) == null) {
            renderer = "unavailable";
        }
        if ((glVersion = GLCapabilityUtils.getGLVersionString(gl)) == null) {
            glVersion = "unavailable";
        }
        if ((shaderVersion = GLCapabilityUtils.getGLShaderVersionString(gl)) == null) {
            shaderVersion = "unavailable";
        }
        LoggerUtils.log((Logger)logger, (Level)level, (String)"OpenGL Vendor: %s", (Object[])new Object[]{vendor});
        if (includeDocumentations) {
            LoggerUtils.log((Logger)logger, (Level)level, (String)"OpenGL Vendor Documentation: %s", (Object[])new Object[]{glVendorDocumentation});
        }
        LoggerUtils.log((Logger)logger, (Level)level, (String)"OpenGL Renderer: %s", (Object[])new Object[]{renderer});
        if (includeDocumentations) {
            LoggerUtils.log((Logger)logger, (Level)level, (String)"OpenGL Renderer Documentation: %s", (Object[])new Object[]{glRendererDocumentation});
        }
        LoggerUtils.log((Logger)logger, (Level)level, (String)"OpenGL Version: %s", (Object[])new Object[]{glVersion});
        if (includeDocumentations) {
            LoggerUtils.log((Logger)logger, (Level)level, (String)"OpenGL Version Documentation: %s", (Object[])new Object[]{glVersionDocumentation});
        }
        LoggerUtils.log((Logger)logger, (Level)level, (String)"OpenGL Shader Version: %s", (Object[])new Object[]{shaderVersion});
        if (includeDocumentations) {
            LoggerUtils.log((Logger)logger, (Level)level, (String)"OpenGL Shader Version Documentation: %s", (Object[])new Object[]{glShaderVersionDocumentation});
        }
    }

    public static void logGLExtensions(Logger logger, Level level, GLContext context, boolean separateLines) {
        GL gl = context.getGL();
        String extString = GLCapabilityUtils.getGLExtensions(gl);
        if (extString == null) {
            LoggerUtils.log((Logger)logger, (Level)level, (String)"No OpenGL extensions found.", (Object[])new Object[0]);
        } else {
            String[] exts = extString.split(" ");
            if (separateLines) {
                LoggerUtils.log((Logger)logger, (Level)level, (String)"%d OpenGL extenstions found.", (Object[])new Object[]{exts.length});
                for (int i = 0; i < exts.length; ++i) {
                    LoggerUtils.log((Logger)logger, (Level)level, (String)"OpenGL extension found: %s", (Object[])new Object[]{exts[i]});
                }
            } else {
                LoggerUtils.log((Logger)logger, (Level)level, (String)"%d OpenGL extenstions found: %s", (Object[])new Object[]{exts.length, extString.trim()});
            }
        }
    }

    public static void logGLMaximumValues(Logger logger, Level level, GLContext context) {
        GL gl = context.getGL();
        int maxVertexAttributes = GLCapabilityUtils.getGLMaxVertexAttributes(gl);
        int maxGeomShaderOutput = GLCapabilityUtils.getGLMaxGeometryShaderOutput(gl);
        int maxTexEdge = GLCapabilityUtils.getGLMaxTextureEdgeLength(gl);
        int maxTexBuffer = GLCapabilityUtils.getGLMaxTextureBufferSize(gl);
        int maxIndices = GLCapabilityUtils.getGLMaxElementsIndices(gl);
        int maxVertices = GLCapabilityUtils.getGLMaxElementsVertices(gl);
        LoggerUtils.log((Logger)logger, (Level)level, (String)"OpenGL Max Vertex Attributes: %d", (Object[])new Object[]{maxVertexAttributes});
        LoggerUtils.log((Logger)logger, (Level)level, (String)"OpenGL Max Geometry Outputs: %d", (Object[])new Object[]{maxGeomShaderOutput});
        LoggerUtils.log((Logger)logger, (Level)level, (String)"OpenGL Max Texture Edge Length: %d", (Object[])new Object[]{maxTexEdge});
        LoggerUtils.log((Logger)logger, (Level)level, (String)"OpenGL Max Texture Buffer Size: %d", (Object[])new Object[]{maxTexBuffer});
        LoggerUtils.log((Logger)logger, (Level)level, (String)"OpenGL Max Element Indices: %d", (Object[])new Object[]{maxIndices});
        LoggerUtils.log((Logger)logger, (Level)level, (String)"OpenGL Max Element Vertices: %d", (Object[])new Object[]{maxVertices});
    }

    public static int getGLMaxVertexAttributes(GL gl) {
        return GLUtils.queryGLInteger(34921, gl);
    }

    public static int getGLMaxGeometryShaderOutput(GL gl) {
        return GLUtils.queryGLInteger(36321, gl);
    }

    public static int getGLMaxTextureEdgeLength(GL gl) {
        return GLUtils.queryGLInteger(3379, gl);
    }

    public static int getGLMaxTextureBufferSize(GL gl) {
        return GLUtils.queryGLInteger(35883, gl);
    }

    public static int getGLMaxElementsIndices(GL gl) {
        return GLUtils.queryGLInteger(33001, gl);
    }

    public static int getGLMaxElementsVertices(GL gl) {
        return GLUtils.queryGLInteger(33000, gl);
    }

    public static String getGLVendorString(GL gl) {
        return gl.glGetString(7936);
    }

    public static String getGLRendererString(GL gl) {
        return gl.glGetString(7937);
    }

    public static String getGLVersionString(GL gl) {
        return gl.glGetString(7938);
    }

    public static String getGLShaderVersionString(GL gl) {
        return gl.glGetString(35724);
    }

    public static String getGLExtensions(GL gl) {
        return gl.glGetString(7939);
    }
}

