/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.gl.texture;

import com.metsci.glimpse.gl.texture.Texture;
import com.metsci.glimpse.gl.util.GLUtils;
import java.util.concurrent.locks.ReentrantLock;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;

public abstract class AbstractTexture
implements Texture {
    protected ReentrantLock lock = new ReentrantLock();
    protected boolean glAllocated;
    protected int glHandle;
    protected boolean dirty;
    protected int[] dim;

    public AbstractTexture(int n0) {
        this.dim = new int[]{n0};
        this.glAllocated = false;
        this.makeDirty();
    }

    public AbstractTexture(int n0, int n1) {
        this.dim = new int[]{n0, n1};
        this.glAllocated = false;
        this.makeDirty();
    }

    public AbstractTexture(int n0, int n1, int n2) {
        this.dim = new int[]{n0, n1, n2};
        this.glAllocated = false;
        this.makeDirty();
    }

    @Override
    public void makeDirty() {
        this.dirty = true;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public int getNumDimension() {
        return this.dim.length;
    }

    @Override
    public int getDimensionSize(int n) {
        return this.dim[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isResident(GL gl) {
        this.lock.lock();
        try {
            if (!this.glAllocated) {
                boolean bl = false;
                return bl;
            }
            int[] handle = new int[]{this.glHandle};
            byte[] resident = new byte[1];
            gl.glAreTexturesResident(1, handle, 0, resident, 0);
            boolean bl = resident[0] > 0;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean prepare(GL gl, int texUnit) {
        this.lock.lock();
        try {
            if (!this.glAllocated) {
                this.allocate_genHandles(gl);
            }
            gl.glActiveTexture(GLUtils.getGLTextureUnit(texUnit));
            gl.glBindTexture(GLUtils.getGLTextureDim(this.dim.length), this.glHandle);
            if (this.glAllocated && this.isDirty()) {
                this.prepare_setPixelStore(gl);
                this.prepare_setTexParameters(gl);
                this.prepare_setData(gl);
                this.dirty = false;
            }
            boolean bl = !this.isDirty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void allocate_genHandles(GL gl) {
        int[] handle = new int[1];
        gl.glGenTextures(1, handle, 0);
        this.glHandle = handle[0];
        this.glAllocated = true;
        this.makeDirty();
    }

    @Override
    public void dispose(GLContext context) {
        if (this.glAllocated) {
            context.getGL().glDeleteTextures(1, new int[]{this.glHandle}, 0);
        }
    }

    protected abstract void prepare_setTexParameters(GL var1);

    protected abstract void prepare_setPixelStore(GL var1);

    protected abstract void prepare_setData(GL var1);
}

