/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.gl.shader;

import com.metsci.glimpse.gl.shader.GLShaderUtils;
import com.metsci.glimpse.gl.shader.ShaderArg;
import com.metsci.glimpse.gl.shader.ShaderArgInOut;
import com.metsci.glimpse.gl.shader.ShaderArgQualifier;
import com.metsci.glimpse.gl.shader.ShaderSource;
import com.metsci.glimpse.gl.shader.ShaderType;
import com.metsci.glimpse.util.io.StreamOpener;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;

public abstract class Shader {
    private static final Logger logger = Logger.getLogger(Shader.class.getName());
    private final String name;
    private final ShaderType type;
    private final ShaderSource[] sources;
    private final ShaderArg[] args;
    private int[] glShaderHandles;
    private int[] glArgHandles;

    public static ShaderSource[] getSource(String ... shaderFile) {
        ShaderSource[] list = new ShaderSource[shaderFile.length];
        try {
            for (int i = 0; i < shaderFile.length; ++i) {
                list[i] = new ShaderSource(shaderFile[i], StreamOpener.fileThenResource);
            }
            return list;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public Shader(String name, ShaderType type, String ... source) {
        this(name, type, false, Shader.getSource(source));
    }

    public Shader(String name, ShaderType type, ShaderSource ... source) {
        this(name, type, false, source);
    }

    public Shader(String name, ShaderType type, boolean noParse, String ... source) {
        this(name, type, noParse, Shader.getSource(source));
    }

    public Shader(String name, ShaderType type, boolean noParse, ShaderSource ... source) {
        this.args = noParse ? new ShaderArg[0] : Shader.verify(type, source);
        this.name = name;
        this.type = type;
        this.sources = source;
        GLShaderUtils.logShaderArgs(logger, Level.INFO, this.args, this.toString() + ": ");
    }

    private static ShaderArg[] verify(ShaderType type, ShaderSource ... source) {
        if (type == null) {
            throw new GLException("Shader type not specified.");
        }
        if (source == null || source.length == 0) {
            throw new GLException("Shader source code not present.");
        }
        List<ShaderArg> args = source[0].extractArgs();
        return args.toArray(new ShaderArg[0]);
    }

    protected ShaderArg getArg(String name) {
        for (int i = 0; i < this.args.length; ++i) {
            if (!this.args[i].getName().contentEquals(name)) continue;
            return this.args[i];
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public ShaderType getType() {
        return this.type;
    }

    public abstract boolean preLink(GL var1, int var2);

    public abstract void preDisplay(GL var1);

    public abstract void postDisplay(GL var1);

    public String toString() {
        return "'" + this.getType().toString().toUpperCase() + " SHADER " + this.getName() + "'";
    }

    protected boolean compileAndAttach(GL gl, int glProgramHandle) {
        int segmentIndex = 0;
        this.glShaderHandles = new int[this.sources.length];
        for (ShaderSource segment : this.sources) {
            int handle = gl.glCreateShader(this.type.glTypeCode());
            this.glShaderHandles[segmentIndex++] = handle;
            gl.glShaderSource(handle, 1, segment.getSourceLines(), null);
            gl.glCompileShader(handle);
            boolean success = GLShaderUtils.logGLShaderInfoLog(logger, gl, handle, this.toString());
            if (success) continue;
            return false;
        }
        for (int i = 0; i < this.glShaderHandles.length; ++i) {
            logger.info("Attached " + this.toString() + " to GL program handle " + glProgramHandle + ".");
            gl.glAttachShader(glProgramHandle, this.glShaderHandles[i]);
        }
        return this.preLink(gl, glProgramHandle);
    }

    protected boolean getShaderArgHandles(GL gl, int glProgramHandle) {
        this.glArgHandles = new int[this.args.length];
        for (int i = 0; i < this.args.length; ++i) {
            ShaderArg arg = this.args[i];
            if (arg.getQual() == ShaderArgQualifier.UNIFORM) {
                this.glArgHandles[i] = gl.glGetUniformLocation(glProgramHandle, arg.getName());
                continue;
            }
            if (arg.getInOut() != ShaderArgInOut.IN) continue;
            this.glArgHandles[i] = gl.glGetAttribLocation(glProgramHandle, arg.getName());
        }
        return true;
    }

    protected void updateArgValues(GL gl) {
        for (int i = 0; i < this.args.length; ++i) {
            ShaderArg arg = this.args[i];
            if (arg.getQual() != ShaderArgQualifier.UNIFORM) continue;
            arg.update(gl, this.glArgHandles[i]);
        }
    }

    public void dispose(GLContext context) {
        GL gl = context.getGL();
        if (this.glShaderHandles != null) {
            for (int handle : this.glShaderHandles) {
                gl.glDeleteShader(handle);
            }
        }
    }
}

